/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.exception;

import com.cleveranalytics.service.authn.rest.dto.HttpErrorDTO;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;

public class ShellExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(ShellExceptionHandler.class);
    private static ObjectMapper mapper = new MdObjectMapper();

    public static void handle(Exception ex, boolean exitOnError) {
        block9: {
            try {
                logger.warn("Handling exception={}", (Object)ex.getClass().getCanonicalName(), (Object)ex);
                logger.error("");
                if (ex instanceof HttpServerErrorException || ex instanceof HttpClientErrorException) {
                    HttpStatusCodeException statusEx = (HttpStatusCodeException)ex;
                    String responseBody = statusEx.getResponseBodyAsString();
                    String responseBodyMessage = "";
                    try {
                        responseBodyMessage = ((HttpErrorDTO)mapper.readValue(responseBody, HttpErrorDTO.class)).getMessage();
                    }
                    catch (JsonMappingException mappingException) {
                        logger.warn("Error parsing status exception response body. Using empty body.");
                    }
                    if (ex instanceof HttpServerErrorException) {
                        logger.error("Server Error={} - {}", (Object)statusEx.getStatusCode(), (Object)statusEx.getStatusText());
                    } else {
                        logger.error("Client Error={} - {}", (Object)statusEx.getStatusCode(), (Object)statusEx.getStatusText());
                    }
                    if (responseBody.length() > 0) {
                        logger.error("Error description={}", (Object)responseBodyMessage);
                    }
                    break block9;
                }
                logger.error("General Error={}", (Object)ex.getMessage());
            }
            catch (IOException exc) {
                logger.warn("Error parsing exception={}", (Throwable)exc);
            }
        }
        logger.error("Execution failed. Please contact support for assistance with requestId={}\n", (Object)MDC.get((String)"requestId"));
        if (exitOnError) {
            System.exit(1);
        }
    }
}

