/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class AddMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(AddMetadataCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public AddMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"addMetadata"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"addMetadata"}, help="Add new metadata object(s) from a dump directory to the server.")
    public void addMetadataCmd(@CliOption(key={"objectName"}, mandatory=false, help="Name of the new metadata object located in current dump to be added (with or without \".json\" extension).") String inputName) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            File metadataDumpDirectory = this.context.getMetadataDumpPath().toFile();
            List<File> metadataFiles = FileTools.findAllMetadataInDump(metadataDumpDirectory);
            List<File> unwrappedMetadataFiles = FileTools.filterWrappedMetadataFiles(metadataFiles);
            List<File> newMetadataFiles = FileTools.filterFilesPresentInMd5List(this.context, unwrappedMetadataFiles);
            String objectName = inputName;
            File foundFile = null;
            if (objectName == null) {
                if (newMetadataFiles.size() > 0) {
                    this.addAllNewFiles(newMetadataFiles);
                } else {
                    System.out.println("There are no new objects to add\n");
                    System.out.println("No new objects were uploaded to the server\n");
                }
            } else {
                objectName = FileTools.appendExtension(objectName, ".json");
                for (File searchedFile : metadataFiles) {
                    if (!searchedFile.getName().equals(objectName)) continue;
                    foundFile = searchedFile;
                }
                if (foundFile == null) {
                    System.out.println("Object " + FilenameUtils.removeExtension((String)objectName) + " could not be found in dump " + this.context.getCurrentDump() + "\n");
                    System.out.println("No new objects were uploaded to the server\n");
                } else if (newMetadataFiles.contains(foundFile)) {
                    this.addOneNewFile(foundFile);
                } else if (metadataFiles.contains(foundFile)) {
                    System.out.println("Object " + objectName + " was found in dump " + this.context.getCurrentDump() + ", but it's not new (it's already wrapped)\n");
                    System.out.println("No new objects were uploaded to the server\n");
                }
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    protected void addOneNewFile(File file) throws IOException {
        logger.error("Adding new object {} to the server...\n", (Object)file.getName());
        AbstractShellClient shellClient = this.context.getShellClient();
        shellClient.addObject(this.context.getCurrentProject(), file);
        shellClient.putMetadataChecksumListElement(this.context, file);
        logger.error("Object {} successfully uploaded to project {}\n", (Object)file.getName(), (Object)this.context.getCurrentProject());
    }

    protected void addAllNewFiles(List<File> newFiles) throws IOException {
        logger.error("Adding all new objects to the server...\n");
        AbstractShellClient shellClient = this.context.getShellClient();
        int uploadCount = 0;
        ArrayList<File> newDatasets = new ArrayList<File>();
        for (File file : newFiles) {
            if (!this.isDatasetFile(file)) continue;
            newDatasets.add(file);
        }
        newFiles.removeAll(newDatasets);
        for (File file : newFiles) {
            shellClient.addObject(this.context.getCurrentProject(), file);
            logger.error("Added object {}", (Object)file.getName());
            shellClient.putMetadataChecksumListElement(this.context, file);
            ++uploadCount;
        }
        ArrayList workingArray = new ArrayList(newDatasets);
        while (!workingArray.isEmpty()) {
            boolean iterationSuccessful = false;
            for (File datasetFile : newDatasets) {
                try {
                    shellClient.addObject(this.context.getCurrentProject(), datasetFile);
                    logger.error("Added object {}", (Object)datasetFile.getName());
                    shellClient.putMetadataChecksumListElement(this.context, datasetFile);
                    ++uploadCount;
                    workingArray.remove(datasetFile);
                    iterationSuccessful = true;
                }
                catch (Exception exception) {}
            }
            if (iterationSuccessful) continue;
            throw new IOException("Failed to add datasets. Check for JSON syntax errors and invalid foreignKey/geometry reference errors.");
        }
        logger.error("\n{} new {} successfully uploaded to project {}\n", new Object[]{uploadCount, uploadCount == 1 ? "object has been" : "objects have been", this.context.getCurrentProject()});
    }

    private boolean isDatasetFile(File file) {
        return file.getAbsolutePath().contains("datasets");
    }
}

