/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.NameLinkReplacer;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class RenameMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(RenameMetadataCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public RenameMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"renameMetadata"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"renameMetadata"}, help="Rename a metadata object in current dump and on the server.")
    public void renameMetadataCmd(@CliOption(key={"objectName"}, mandatory=true, help="Name of the existing object to be renamed.") String objectName, @CliOption(key={"newName"}, mandatory=true, help="New name of the object.") String newName) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            this.renameObject(objectName, newName);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    protected void renameObject(String oldNameInput, String newNameInput) throws IOException {
        logger.error("Renaming object {} to {}...\n", (Object)oldNameInput, (Object)newNameInput);
        String newNameWithExt = FileTools.appendExtension(newNameInput, ".json");
        String oldNameWithExt = FileTools.appendExtension(oldNameInput, ".json");
        String newNameWithoutExt = FilenameUtils.removeExtension((String)newNameWithExt);
        String oldNameWithoutExt = FilenameUtils.removeExtension((String)oldNameWithExt);
        File alreadyNamedFile = FileTools.findMetadataInDump(this.context, newNameWithExt);
        if (alreadyNamedFile != null) {
            throw new IOException("File=" + newNameWithExt + " already exists in dump=" + this.context.getCurrentDump());
        }
        File localFile = FileTools.findMetadataInDump(this.context, oldNameWithExt);
        if (localFile == null) {
            throw new IOException("File=" + oldNameWithExt + " not found in dump=" + this.context.getCurrentDump());
        }
        if (this.context.getShellClient() instanceof MdShellClient) {
            MdShellClient mdShellClient = (MdShellClient)this.context.getShellClient();
            mdShellClient.mdObjectNameCheck(newNameWithoutExt);
            NameLinkReplacer replacer = new NameLinkReplacer(oldNameWithoutExt, newNameWithoutExt);
            MdObjectDumpDTO renamedObject = mdShellClient.renameObject(this.context, localFile, oldNameWithExt, newNameWithExt);
            List<MdObjectDumpDTO> renamedReferences = mdShellClient.replaceURIReferences(this.context.getMetadataDumpPath().toFile(), renamedObject.getContent(), replacer);
            mdShellClient.renameObjectReferences(this.context, renamedObject, renamedReferences);
        } else {
            logger.error("Renaming object is not supported for this project type.");
        }
    }
}

