/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.commands.project.DumpProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class OpenDumpCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(OpenDumpCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public OpenDumpCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"openDump"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getLoggedUser() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"openDump"}, help="Set a dump as current (e.g. working directory).")
    public void openDumpCmd(@CliOption(key={"directory"}, mandatory=false, help="Path to a shell directory, where the dumps are located. E.g. /var/local/can-shell") String inputDirectory, @CliOption(key={"dump"}, mandatory=false, help="DumpId of CleverAnalytics project. E.g. 2016-02-08_10-36-19") String dumpId) {
        try {
            File shellDirectory = DumpProjectCommand.createShellDirectory(inputDirectory, this.context);
            File projectDirectory = DumpProjectCommand.createProjectDirectory(shellDirectory, this.context);
            MDC.put((String)"requestId", (String)UriTool.randomId());
            this.openMetadataDump(projectDirectory, dumpId);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    protected void openMetadataDump(File projectDirectory, String dumpId) throws ParseException {
        File dumpDirectory;
        if (dumpId == null) {
            dumpId = this.findLatestDump(projectDirectory);
        }
        if (!(dumpDirectory = Paths.get(projectDirectory.getAbsolutePath(), dumpId).toFile()).exists()) {
            throw new IllegalArgumentException("Dump " + dumpId + " could not be found in directory " + this.context.getProjectPath());
        }
        this.context.setCurrentDump(dumpId);
        System.out.println("Dump " + dumpId + " opened and set as current");
        System.out.println("Full path: " + this.context.getDumpPath() + "\n");
    }

    protected String findLatestDump(File projectDirectory) throws ParseException {
        ArrayList<File> dumpFolders = new ArrayList<File>();
        try {
            for (File dump : projectDirectory.listFiles()) {
                if (!FileTools.isValidDumpDirectory(dump)) continue;
                dumpFolders.add(dump);
            }
            DateFormat directoryDateFormat = FileTools.DUMP_ID_FORMAT;
            Date lastDumpDate = directoryDateFormat.parse(((File)dumpFolders.get(0)).getName());
            for (File dump : dumpFolders) {
                Date date = directoryDateFormat.parse(dump.getName());
                if (date.compareTo(lastDumpDate) < 0) continue;
                lastDumpDate = date;
            }
            return directoryDateFormat.format(lastDumpDate);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IndexOutOfBoundsException("No valid dump directories found in: " + projectDirectory.getName() + ", please make a dump first");
        }
        catch (NullPointerException ex) {
            throw new NullPointerException("No directories found in: " + projectDirectory.getName() + ", please make a dump first");
        }
    }
}

