/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.dwh.rest.dto.DataPullRequest;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.shell.ExecutionType;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class LoadCsvCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(LoadCsvCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public LoadCsvCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"loadCsv"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getLoggedUser() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"loadCsv"}, help="Load CSV file into existing CleverAnalytics dataset.")
    public void loadCsvCmd(@CliOption(key={"dataset"}, mandatory=true, help="Name of the dataset where the data will be loaded.") String datasetName, @CliOption(key={"mode"}, mandatory=true, help="Data load mode. Allowed values=[\"full\", \"incremental\"]") String mode, @CliOption(key={"file"}, mandatory=true, help="Path to a CSV file to be loaded. If a dump is opened and contains some CSV files, file can be specified by using just the filename ('restaurants.csv') instead of full path") String file, @CliOption(key={"execution"}, mandatory=false, unspecifiedDefaultValue="async", help="Data load execution type. Allowed values=[\"async\", \"sync\"]") String execution) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (execution.equals("sync")) {
                logger.error("Synchronous data upload started...\n");
            } else {
                logger.error("Asynchronous data upload started...\n");
            }
            this.loadDataset(datasetName, mode, file, execution);
            logger.error("");
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    private void loadDataset(String datasetName, String mode, String file, String execution) throws IOException {
        DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)this.context.getCanRestClient());
        ExecutionType executionType = dwhShellClient.convertExecutionType(execution);
        DataPullRequest.Mode dataPullRequestMode = this.convertDataPullRequestMode(mode);
        this.loadData(file, datasetName, dataPullRequestMode, executionType);
    }

    public void loadData(String csvName, String datasetName, DataPullRequest.Mode mode, ExecutionType executionType) throws IOException {
        File dwhDataset = FileTools.findMetadataInDump(this.context, datasetName);
        if (dwhDataset == null || !dwhDataset.canRead()) {
            logger.error("Cannot find DWH dataset name=" + datasetName + " corresponding to CSV name=" + csvName + ", skipping the upload");
        } else {
            File csvFile = this.getCsvFile(csvName, datasetName);
            DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)this.context.getCanRestClient());
            dwhShellClient.loadData(this.context, executionType, datasetName, mode, csvFile);
            AbstractShellClient shellClient = this.context.getShellClient();
            if (shellClient instanceof MdShellClient) {
                MdDatasetClient datasetClient = (MdDatasetClient)this.context.getDatasetClient();
                DatasetDTO fetchDataset = datasetClient.getDatasetByName(this.context.getCurrentProject(), datasetName);
                ((MdShellClient)shellClient).wrapAndSaveMdObject(this.context, (MdObjectDTO)fetchDataset);
            }
        }
    }

    protected File getCsvFile(String csvName, String datasetName) throws IOException {
        File csvFile = new FileSystemResource(csvName).getFile();
        if (!(csvFile != null && csvFile.canRead() || (csvFile = FileTools.findDataInDump(this.context, csvName)) != null && csvFile.exists() && csvFile.canRead())) {
            throw new IOException("Cannot find CSV file=" + csvName + " corresponding to dataset name=" + datasetName);
        }
        return csvFile;
    }

    protected DataPullRequest.Mode convertDataPullRequestMode(String mode) throws IllegalArgumentException {
        try {
            return DataPullRequest.Mode.fromValue((String)mode);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid 'mode' parameter=" + mode + ". Supported values are=" + Arrays.toString(DataPullRequest.Mode.values()) + ".");
        }
    }
}

