/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.dwh.rest.dto.DataPullRequest;
import com.cleveranalytics.shell.ExecutionType;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.commands.project.LoadCsvCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class PushProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(PushProjectCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public PushProjectCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"pushProject"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"pushProject"}, help="Push project DWH data and metadata to a server.")
    public void pushProjectCmd(@CliOption(key={"skipData"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip DWH data push.") boolean skipData, @CliOption(key={"skipMetadata"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip metadata push.") boolean skipMetadata, @CliOption(key={"execution"}, mandatory=false, unspecifiedDefaultValue="async", help="Project data load execution type. Allowed values=[\"async\", \"sync\"]") String execution) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            File dataDumpDirectory = this.context.getDataDumpPath().toFile();
            File metadataDumpDirectory = this.context.getMetadataDumpPath().toFile();
            if (!skipMetadata) {
                List<File> allMetadataFiles = FileTools.findAllMetadataInDump(metadataDumpDirectory);
                List<File> unmappableMetadataFiles = FileTools.filterMappableMetadataFiles(allMetadataFiles);
                List<File> modifiedMetadata = FileTools.findModifiedMetadataInDump(this.context, metadataDumpDirectory);
                List<File> modifiedMetadataToPush = this.context.getShellClient() instanceof MdShellClient ? FileTools.filterUnwrappedMetadataFiles(modifiedMetadata) : modifiedMetadata;
                if (modifiedMetadataToPush.size() > 0 || unmappableMetadataFiles.size() > 0) {
                    this.pushMetadata(modifiedMetadataToPush, unmappableMetadataFiles);
                } else {
                    logger.error("No metadata objects were modified - nothing to push\n");
                }
            }
            if (!skipData) {
                List<File> modifiedData = FileTools.findModifiedDataInDump(this.context, dataDumpDirectory);
                if (modifiedData.size() > 0) {
                    this.pushData(modifiedData, execution);
                } else {
                    logger.error("No data files were modified - nothing to push\n");
                }
            }
            DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)this.context.getCanRestClient());
            Map<String, Integer> violationTypes = dwhShellClient.simpleProjectIntegrityCheck(this.context.getCanRestClient(), this.context.getCurrentProject());
            this.printValidationCheck(violationTypes);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    public void printValidationCheck(Map<String, Integer> violationTypes) {
        if (violationTypes.size() > 0) {
            logger.error("FAIL\n");
            logger.error("There are following DWH model/data integrity violations in the project:");
            logger.error(violationTypes.toString() + "\n");
        } else {
            logger.error("OK\n");
        }
    }

    protected void pushMetadata(List<File> metadataFiles, List<File> unmappableMetadataFiles) throws IOException {
        logger.error("Uploading modified metadata objects to the server...\n");
        AbstractShellClient shellClient = this.context.getShellClient();
        if (metadataFiles.size() > 0) {
            for (File file : metadataFiles) {
                shellClient.pushObject(this.context.getCurrentProject(), file);
                shellClient.putMetadataChecksumListElement(this.context, file);
                logger.error("Uploaded object {}", (Object)file.getName());
            }
            logger.error("");
        }
        if (unmappableMetadataFiles.isEmpty()) {
            logger.error("Metadata of project {} successfully updated from dump {}\n", (Object)this.context.getCurrentProject(), (Object)this.context.getCurrentDump());
        } else {
            this.printSyntaxErrorWarning(unmappableMetadataFiles);
        }
    }

    public void printSyntaxErrorWarning(List<File> errorFiles) {
        StringBuilder output = new StringBuilder();
        output.append("Error uploading ");
        output.append(errorFiles.size());
        output.append(errorFiles.size() == 1 ? " file" : " files");
        output.append(", which");
        output.append(errorFiles.size() == 1 ? " contains" : " contain");
        output.append(" syntax errors and/or constraint violations:\n");
        for (File errorFile : errorFiles) {
            output.append("\t");
            output.append(errorFile.getName());
            output.append("\n");
        }
        System.out.println(output);
    }

    protected void pushData(List<File> dataFiles, String execution) throws IOException {
        LoadCsvCommand loadCsvCommand = new LoadCsvCommand(this.context);
        DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)this.context.getCanRestClient());
        ExecutionType executionType = dwhShellClient.convertExecutionType(execution);
        if (executionType.equals((Object)ExecutionType.ASYNCHRONOUS)) {
            logger.error("Asynchronous data upload started...\n");
        } else {
            logger.error("Synchronous data upload started...\n");
        }
        for (File file : dataFiles) {
            String datasetName = FilenameUtils.removeExtension((String)file.getName());
            loadCsvCommand.loadData(file.getName(), datasetName, DataPullRequest.Mode.FULL, executionType, null);
        }
        logger.error("\nDWH data of project {} successfully updated from dump {}\n", (Object)this.context.getCurrentProject(), (Object)this.context.getCurrentDump());
    }
}

