/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.connected;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class EditProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(EditProjectCommand.class);
    protected ProjectClient projectClient;
    private ShellContext context;

    @Autowired
    public EditProjectCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"editProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getLoggedUser() != null;
    }

    @CliCommand(value={"editProject"}, help="Allows to edit project's properties.")
    public void editProjectCmd(@CliOption(key={"project"}, mandatory=true, help="ID of the project to edit.") String projectId, @CliOption(key={"newTitle"}, mandatory=false, help="New title of the project. Use quotes (\"sample project\") if the title contains spaces.") String newTitle, @CliOption(key={"newDescription"}, mandatory=false, help="New description of the project.") String newDescription) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            logger.error("Editing project {}...\n", (Object)projectId);
            if (newTitle == null && newDescription == null) {
                logger.error("Please specify at least one option (--newTitle, --newDescription) for this command");
            }
            this.projectClient = new ProjectClient((CanRestClient)this.context.getCanRestClient());
            this.projectClient.updateProject(projectId, newTitle, newDescription);
            if (newTitle != null) {
                logger.error("Changed project title to \"{}\"", (Object)newTitle);
            }
            if (newDescription != null) {
                logger.error("Changed project description to \"{}\"", (Object)newDescription);
            }
            logger.error("");
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }
}

