/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.config;

import com.cleveranalytics.shell.config.ShellContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.support.DefaultPromptProvider;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class PromptProvider
extends DefaultPromptProvider {
    private ShellContext context;

    @Autowired
    public PromptProvider(ShellContext context) {
        this.context = context;
    }

    public String getPrompt() {
        StringBuilder prompt = new StringBuilder();
        if (this.context.getLoggedUser() != null && this.context.getConnectedServer() != null) {
            prompt.append(this.context.getLoggedUsername());
            prompt.append("@");
            prompt.append(this.context.getConnectedServerRelativeUrl());
            if (this.context.getCurrentProject() != null) {
                prompt.append("/project:");
                prompt.append(this.context.getCurrentProject());
            }
            if (this.context.getCurrentDump() != null) {
                prompt.append("/dump:");
                prompt.append(this.context.getCurrentDump());
            }
            prompt.append("$ ");
            return prompt.toString();
        }
        return "CleverAnalytics$ ";
    }

    public String getProviderName() {
        return "CleverAnalytics";
    }
}

