/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.shell.client.JobShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.stereotype.Component;

@Component
public class TruncateProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(TruncateProjectCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public TruncateProjectCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"truncateProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getLoggedUser() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"truncateProject"}, help="Delete all data and metadata from the project.")
    public void truncateProjectCmd() {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            JobShellClient jobClient = new JobShellClient();
            jobClient.truncateProject(this.context);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }
}

