/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.cleveranalytics.service.metadata.util.CanPrettyPrinter;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.JsonSyntaxException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Component
public class DiffCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(DiffCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;
    private final ObjectMapper mapper = new MdObjectMapper();
    private CanPrettyPrinter canPrettyPrinter = new CanPrettyPrinter();
    private ObjectWriter objectWriter = this.mapper.writer().with((PrettyPrinter)this.canPrettyPrinter);
    public static final Ansi ANSI_RED = Ansi.ansi().fg(Ansi.Color.RED);
    public static final Ansi ANSI_GREEN = Ansi.ansi().fg(Ansi.Color.GREEN);
    public static final Ansi ANSI_CYAN = Ansi.ansi().fg(Ansi.Color.CYAN);
    public static final Ansi ANSI_RESET = Ansi.ansi().reset();
    public static final int WRAPPER_LINES = 4;

    @Autowired
    public DiffCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"diff"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"diff"}, help="Compare local metadata objects with those in project line by line.")
    public void diffCmd(@CliOption(key={"objectName"}, mandatory=false, help="Name of the local object to be compared.") String inputName) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            String output = this.formatDiff(inputName);
            if (output != null) {
                AnsiConsole.systemInstall();
                System.out.println(output);
                AnsiConsole.systemUninstall();
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    public String formatDiff(String inputName) throws IOException {
        File metadataDumpDirectory = this.context.getMetadataDumpPath().toFile();
        List<File> allMetadataFiles = FileTools.findAllMetadataInDump(metadataDumpDirectory);
        List<File> unmappableMetadataFiles = FileTools.filterMappableMetadataFiles(allMetadataFiles);
        List<File> mappableMetadataFiles = FileTools.filterUnmappableMetadataFiles(allMetadataFiles);
        List<File> unwrappedMetadataFiles = FileTools.filterWrappedMetadataFiles(mappableMetadataFiles);
        List<File> newMetadataFiles = FileTools.filterFilesPresentInMd5List(this.context, unwrappedMetadataFiles);
        List<File> localModifiedMetadata = FileTools.findModifiedMetadataInDump(this.context, metadataDumpDirectory);
        List<File> localModifiedWrappedMetadata = FileTools.filterUnwrappedMetadataFiles(localModifiedMetadata);
        Map<File, Long> modifiedOnServer = FileTools.findModifiedMetadataOnServer(this.context, metadataDumpDirectory);
        ArrayList<File> remoteModifiedMetadata = new ArrayList<File>(modifiedOnServer.keySet());
        StringBuilder completeDiff = new StringBuilder();
        String objectName = inputName;
        File foundFile = null;
        if (objectName == null) {
            MdObjectDTO mdObject;
            if (localModifiedWrappedMetadata.isEmpty() && newMetadataFiles.isEmpty() && remoteModifiedMetadata.isEmpty() && unmappableMetadataFiles.isEmpty()) {
                return "Local dump " + this.context.getCurrentDump() + " and project " + this.context.getCurrentProject() + " are identical\n";
            }
            localModifiedWrappedMetadata.sort(new FileNameComparator());
            newMetadataFiles.sort(new FileNameComparator());
            remoteModifiedMetadata.sort(new FileNameComparator());
            for (File localModifiedFile : localModifiedWrappedMetadata) {
                if (remoteModifiedMetadata.contains(localModifiedFile)) continue;
                mdObject = FileTools.loadFileAsMdObjectDump(localModifiedFile).getContent();
                completeDiff.append(this.formatFileDiff(localModifiedFile, mdObject.getName(), false, false));
            }
            for (File newFile : newMetadataFiles) {
                mdObject = FileTools.loadFileAsClass(newFile, MdObjectDTO.class);
                completeDiff.append(this.formatFileDiff(newFile, mdObject.getName(), true, false));
            }
            for (File remoteModifiedFile : remoteModifiedMetadata) {
                mdObject = FileTools.loadFileAsMdObjectDump(remoteModifiedFile).getContent();
                completeDiff.append(this.formatFileDiff(remoteModifiedFile, mdObject.getName(), false, true));
            }
            for (File unmappableMetadataFile : unmappableMetadataFiles) {
                this.diffSyntaxErrorFile(unmappableMetadataFile);
            }
        } else {
            objectName = FileTools.appendExtension(objectName, ".json");
            for (File searchedFile : allMetadataFiles) {
                if (!searchedFile.getName().equals(objectName)) continue;
                foundFile = searchedFile;
            }
            if (foundFile == null) {
                logger.error("Object {} not found in dump {}\n", (Object)FilenameUtils.removeExtension((String)objectName), (Object)this.context.getCurrentDump());
                return null;
            }
            if (unmappableMetadataFiles.contains(foundFile)) {
                this.diffSyntaxErrorFile(foundFile);
            } else if (newMetadataFiles.contains(foundFile)) {
                completeDiff.append(this.formatFileDiff(foundFile, objectName, true, false));
            } else if (remoteModifiedMetadata.contains(foundFile)) {
                completeDiff.append(this.formatFileDiff(foundFile, objectName, false, true));
            } else {
                completeDiff.append(this.formatFileDiff(foundFile, objectName, false, false));
            }
        }
        return completeDiff.toString();
    }

    private String formatFileDiff(File localFile, String objectName, boolean isNewObject, boolean wasModifiedOnServer) throws IOException {
        MdObjectDTO remoteObject;
        MdObjectDTO localObject = isNewObject ? this.fetchLocalUnwrappedObject(localFile) : this.fetchLocalWrappedObject(localFile);
        String localObjectType = localObject.getType().toStringPlural();
        ArrayList<String> localObjectLines = this.processStringInput(this.objectWriter.writeValueAsString((Object)localObject));
        ArrayList<Object> remoteObjectLines = isNewObject ? new ArrayList() : ((remoteObject = this.fetchRemoteObject(localObject.getId(), localObjectType)) == null ? new ArrayList() : this.processStringInput(this.objectWriter.writeValueAsString((Object)remoteObject)));
        StringBuilder objectDiff = new StringBuilder();
        Patch patch = DiffUtils.diff(localObjectLines, remoteObjectLines);
        List deltas = patch.getDeltas();
        if (deltas.isEmpty()) {
            return "Local object " + objectName + " and its project version are identical\n";
        }
        objectDiff.append(OsUtils.LINE_SEPARATOR);
        objectDiff.append(this.formatFileHeader(localFile));
        for (Delta delta : deltas) {
            objectDiff.append(this.formatDeltaOutput(delta, localObjectLines, isNewObject, wasModifiedOnServer));
        }
        return objectDiff.toString();
    }

    private MdObjectDTO fetchLocalWrappedObject(File file) throws IOException {
        MdObjectDTO localMdObject = FileTools.loadFileAsMdObjectDump(file).getContent();
        this.removeAdditionalProperties(localMdObject);
        return localMdObject;
    }

    private MdObjectDTO fetchLocalUnwrappedObject(File file) throws IOException {
        MdObjectDTO localMdObject = FileTools.loadFileAsClass(file, MdObjectDTO.class);
        this.removeAdditionalProperties(localMdObject);
        return localMdObject;
    }

    private MdObjectDTO fetchRemoteObject(String id, String objectType) {
        MdObjectDTO remoteObject;
        MdObjectClient mdObjectClient = new MdObjectClient((CanRestClient)this.context.getCanRestClient());
        try {
            remoteObject = mdObjectClient.getMdObjectById(this.context.getCurrentProject(), objectType, id);
            this.removeAdditionalProperties(remoteObject);
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw ex;
        }
        return remoteObject;
    }

    private String formatDeltaOutput(Delta delta, List<String> localObjectLines, boolean isNewObject, boolean wasModifiedOnServer) {
        StringBuilder output = new StringBuilder();
        output.append(OsUtils.LINE_SEPARATOR);
        int originalDeltaStart = delta.getOriginal().getPosition();
        int minus3 = originalDeltaStart - 3;
        int minus2 = originalDeltaStart - 2;
        int minus1 = originalDeltaStart - 1;
        if (minus3 >= 1) {
            output.append("  ");
            output.append(localObjectLines.get(minus3 - 1));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        if (minus2 >= 1) {
            output.append("  ");
            output.append(localObjectLines.get(minus2 - 1));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        if (minus1 >= 1) {
            output.append("  ");
            output.append(localObjectLines.get(minus1 - 1));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        int originalDeltaSize = delta.getOriginal().getLines().size();
        for (int i = 0; i < originalDeltaSize; ++i) {
            if (!wasModifiedOnServer) {
                output.append(ANSI_GREEN);
                output.append("+ ");
            } else {
                output.append(ANSI_RED);
                output.append("- ");
            }
            output.append(delta.getOriginal().getLines().get(i));
            output.append(ANSI_RESET);
            output.append(OsUtils.LINE_SEPARATOR);
        }
        int revisedDeltaSize = delta.getRevised().getLines().size();
        for (int i = 0; i < revisedDeltaSize; ++i) {
            if (!wasModifiedOnServer) {
                output.append(ANSI_RED);
                output.append("- ");
            } else {
                output.append(ANSI_GREEN);
                output.append("+ ");
            }
            output.append(delta.getRevised().getLines().get(i));
            output.append(ANSI_RESET);
            output.append(OsUtils.LINE_SEPARATOR);
        }
        int originalDeltaEnd = originalDeltaStart + originalDeltaSize - 1;
        int plus1 = originalDeltaEnd + 1;
        int plus2 = originalDeltaEnd + 2;
        int plus3 = originalDeltaEnd + 3;
        if (plus1 < localObjectLines.size()) {
            output.append("  ");
            output.append(localObjectLines.get(plus1));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        if (plus2 < localObjectLines.size()) {
            output.append("  ");
            output.append(localObjectLines.get(plus2));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        if (plus3 < localObjectLines.size()) {
            output.append("  ");
            output.append(localObjectLines.get(plus3));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        int revisedDeltaStart = delta.getRevised().getPosition();
        int revisedDeltaEnd = revisedDeltaStart + revisedDeltaSize - 1;
        String deltaHeader = this.formatDeltaHeader(originalDeltaStart, originalDeltaEnd, revisedDeltaStart, revisedDeltaEnd, isNewObject, wasModifiedOnServer);
        output.insert(0, deltaHeader);
        return output.toString();
    }

    private String formatDeltaHeader(int originalDeltaStart, int originalDeltaEnd, int revisedDeltaStart, int revisedDeltaEnd, boolean isNewObject, boolean wasModifiedOnServer) {
        ++originalDeltaStart;
        ++originalDeltaEnd;
        ++revisedDeltaStart;
        ++revisedDeltaEnd;
        if (!isNewObject) {
            originalDeltaStart += 4;
            originalDeltaEnd += 4;
            revisedDeltaStart += 4;
            revisedDeltaEnd += 4;
        }
        StringBuilder deltaHeader = new StringBuilder();
        deltaHeader.append(ANSI_CYAN);
        deltaHeader.append("[ ");
        String originalSign = "+";
        String revisedSign = "-";
        if (wasModifiedOnServer) {
            originalSign = "-";
            revisedSign = "+";
        }
        if (originalDeltaStart == originalDeltaEnd) {
            deltaHeader.append(originalSign);
            deltaHeader.append(originalDeltaStart);
        } else if (originalDeltaStart < originalDeltaEnd) {
            deltaHeader.append(originalSign);
            deltaHeader.append(originalDeltaStart);
            deltaHeader.append(" ");
            deltaHeader.append(originalSign);
            deltaHeader.append(originalDeltaEnd);
        }
        if (originalDeltaStart <= originalDeltaEnd && revisedDeltaStart <= revisedDeltaEnd) {
            deltaHeader.append(" | ");
        }
        if (revisedDeltaStart == revisedDeltaEnd) {
            deltaHeader.append(revisedSign);
            deltaHeader.append(revisedDeltaStart);
        } else if (revisedDeltaStart < revisedDeltaEnd) {
            deltaHeader.append(revisedSign);
            deltaHeader.append(revisedDeltaStart);
            deltaHeader.append(" ");
            deltaHeader.append(revisedSign);
            deltaHeader.append(revisedDeltaEnd);
        }
        deltaHeader.append(" ]");
        deltaHeader.append(ANSI_RESET);
        return deltaHeader.toString();
    }

    private String formatFileHeader(File file) {
        StringBuilder fileHeader = new StringBuilder();
        fileHeader.append(ANSI_CYAN);
        fileHeader.append("/");
        fileHeader.append(Paths.get(file.getParent(), new String[0]).toFile().getName());
        fileHeader.append("/");
        fileHeader.append(file.getName());
        fileHeader.append(ANSI_RESET);
        fileHeader.append(OsUtils.LINE_SEPARATOR);
        return fileHeader.toString();
    }

    public ArrayList<String> processStringInput(String input) {
        String[] linesArray = input.split("\\r?\\n|\\r");
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : linesArray) {
            line = line.replace("\r", "");
            line = line.replace("/" + this.context.getCurrentProject() + "/", "/$projectId/");
            lines.add(line);
        }
        return lines;
    }

    protected void removeAdditionalProperties(MdObjectDTO mdObject) {
        mdObject.setAccessInfo(null);
        mdObject.getAdditionalProperties().remove("links");
    }

    private void diffSyntaxErrorFile(File file) throws IOException {
        try {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            this.mapper.readValue(content, MdObjectDTO.class);
        }
        catch (JsonProcessingException exception) {
            throw new JsonSyntaxException(file, "diff", exception);
        }
    }

    private static class FileNameComparator
    implements Comparator<File> {
        private FileNameComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            return file1.getName().compareToIgnoreCase(file2.getName());
        }
    }
}

