/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.login;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.authn.client.AuthnClient;
import com.cleveranalytics.service.authn.client.UserCredentialsCanRestClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverAnalyticsShellException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class LoginCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(LoginCommand.class);
    @Value(value="${service.name}")
    private final String serviceName;
    @Value(value="${can.service.authn.serverUrl:#{null}}")
    private final String authnServerUrl;
    private String authnServer;
    private ClientHttpRequestFactory requestFactory;
    protected UserCredentialsCanRestClient canRestClient;
    private ShellContext context;
    private static final String CONFIG_TIP = "Tip: you can save your shell configuration in a file named \"config\" (without any file extension) in \".cleverAnalytics\"\nfolder located in your OS's home folder. The \"config\" file should have following syntax:\n\ndumpDirectory=/var/local/metadata\nserver=https://staging.cleveranalytics.com\n";
    private static final String CREDENTIALS_TIP = "Tip: you can save your user credentials in a file named \"credentials\" (without any file extension) in \".cleverAnalytics\"\nfolder located in your OS's home folder. The \"credentials\" file should have following syntax:\n\nemail=address@domain.com\npassword=MY_SECRET_PASSWORD\n";

    @Autowired
    public LoginCommand(ShellContext context, @Qualifier(value="nonCachingHttpClientRequestFactory") ClientHttpRequestFactory requestFactory) {
        this.serviceName = null;
        this.authnServerUrl = null;
        this.context = context;
        this.requestFactory = requestFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CliCommand(value={"login"}, help="Log in using correct CleverAnalytics credentials.")
    public void loginCmd(@CliOption(key={"email"}, mandatory=false, help="Email of a CleverAnalytics user.") String email, @CliOption(key={"password"}, mandatory=false, help="Valid password to the user account.") String password, @CliOption(key={"server"}, mandatory=false, unspecifiedDefaultValue="https://secure.cleveranalytics.com", help="Target hostname where to connect.") String server) {
        try {
            Properties config;
            File configFile;
            File credentialsFile;
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (this.context.isIncompatibleVersion()) {
                throw new CleverAnalyticsShellException("It's forbidden to login if a change with 'FATAL' level has been introduced. Please download the latest version.");
            }
            Path canPath = Paths.get(System.getProperty("user.home"), ".cleverAnalytics");
            File canDirectory = canPath.toFile();
            Path credentialsPath = Paths.get(canPath.toString(), "credentials");
            Path credentialsTxtPath = Paths.get(canPath.toString(), "credentials.txt");
            if (credentialsPath.toFile().exists()) {
                credentialsFile = credentialsPath.toFile();
            } else if (credentialsTxtPath.toFile().exists()) {
                credentialsFile = credentialsTxtPath.toFile();
                credentialsPath = credentialsTxtPath;
            } else {
                credentialsFile = null;
            }
            Path configPath = Paths.get(canPath.toString(), "config");
            Path configTxtPath = Paths.get(canPath.toString(), "config.txt");
            if (configPath.toFile().exists()) {
                configFile = configPath.toFile();
            } else if (configTxtPath.toFile().exists()) {
                configFile = configTxtPath.toFile();
                configPath = configTxtPath;
            } else {
                configFile = null;
            }
            if (canDirectory.exists() || canDirectory.mkdirs()) {
                // empty if block
            }
            if (server == null) {
                if (configFile == null) {
                    System.out.println("\nPlease specify option (--server) for this command\n");
                    System.out.println(CONFIG_TIP);
                    return;
                }
                config = this.loadConfigFile(configPath);
                this.setDumpDirectoryFromConfigFile(config);
                this.setServerFromConfigFile(config);
            } else {
                if (configFile != null) {
                    config = this.loadConfigFile(configPath);
                    this.setDumpDirectoryFromConfigFile(config);
                }
                this.context.setConnectedServer(server);
            }
            if (email == null && password == null) {
                if (credentialsFile == null) {
                    System.out.println("\nPlease specify options (--email, --password) for this command\n");
                    System.out.println(CREDENTIALS_TIP);
                    return;
                }
                this.setCredentialsFromFile(credentialsPath);
            } else {
                this.context.setLoggedUser(email);
                this.context.setUserPassword(password);
            }
            if (this.authnServerUrl != null) {
                this.authnServer = this.authnServerUrl;
                System.out.println("\nObtaining refresh token from " + this.authnServerUrl);
            } else {
                this.authnServer = this.context.getConnectedServer();
            }
            this.canRestClient = new UserCredentialsCanRestClient(new AuthnClient(this.serviceName, this.authnServer, this.requestFactory), this.serviceName, this.context.getConnectedServer(), this.context.getLoggedUser(), this.context.getUserPassword(), this.requestFactory);
            System.out.println("\nSuccessfully logged in as " + this.context.getLoggedUser() + "\n");
            ArrayList<Object> converters = new ArrayList<Object>();
            converters.add(new StringHttpMessageConverter(Charset.forName("UTF-8")));
            converters.add(new MappingJackson2HttpMessageConverter(new ObjectMapper()));
            converters.add(new FormHttpMessageConverter());
            this.canRestClient.setMessageConverters(converters);
            this.context.setCanRestClient(this.canRestClient);
            this.context.setCurrentProject(null);
            this.context.setCurrentDump(null);
            return;
        }
        catch (Exception ex) {
            this.context.setLoggedUser(null);
            this.context.setUserPassword(null);
            this.context.setConnectedServer(null);
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    protected void setReadWriteForOwnerOnly(Path path) throws IOException {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("mac")) {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(path, permissions);
        } else if (osName.contains("win")) {
            File file = new File(path.toString());
            file.setExecutable(false, true);
            file.setReadable(false, true);
            file.setWritable(false, true);
        }
    }

    protected Properties loadConfigFile(Path configPath) throws IOException {
        Properties config = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(configPath.toString());
            String properties = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            config.load(new StringReader(properties.replace("\\", "\\\\")));
            ((InputStream)inputStream).close();
            System.out.println("Found config file: " + configPath.toString());
        }
        catch (FileNotFoundException ex) {
            throw new FileNotFoundException("Config file=" + configPath.toString() + " not found.");
        }
        catch (IOException ex) {
            throw new IOException("Failed to read config file=" + configPath.toString() + ".");
        }
        return config;
    }

    protected void setServerFromConfigFile(Properties config) {
        if (config.containsKey("server")) {
            System.out.println("\t* setting " + config.getProperty("server") + " as default server");
            this.context.setConnectedServer(config.getProperty("server"));
        }
    }

    protected void setDumpDirectoryFromConfigFile(Properties config) {
        if (config.containsKey("dumpDirectory")) {
            System.out.println("\t* setting " + config.getProperty("dumpDirectory") + " as default dump directory");
            this.context.setShellDirectory(config.getProperty("dumpDirectory"));
        }
    }

    protected void setCredentialsFromFile(Path credentialsPath) throws IOException {
        try {
            Properties credentials = new Properties();
            FileInputStream inputStream = new FileInputStream(credentialsPath.toString());
            credentials.load(inputStream);
            this.context.setLoggedUser(credentials.getProperty("email"));
            this.context.setUserPassword(credentials.getProperty("password"));
            ((InputStream)inputStream).close();
        }
        catch (FileNotFoundException ex) {
            throw new FileNotFoundException("Credentials file=" + credentialsPath.toString() + " not found.");
        }
        catch (IOException ex) {
            throw new IOException("Failed to read credentials file=" + credentialsPath.toString() + ".");
        }
    }
}

