/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.connected;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.MetadataServiceType;
import com.cleveranalytics.service.project.rest.dto.ProjectDTO;
import com.cleveranalytics.shell.commands.connected.OpenProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class CreateProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(CreateProjectCommand.class);
    protected ProjectClient projectClient;
    private ShellContext context;
    private OpenProjectCommand openProjectCommand;

    @Autowired
    public CreateProjectCommand(ShellContext context, @Qualifier(value="nonCachingHttpClientRequestFactory") ClientHttpRequestFactory requestFactory) {
        this.context = context;
        this.openProjectCommand = new OpenProjectCommand(context, requestFactory);
    }

    @CliAvailabilityIndicator(value={"createProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getLoggedUser() != null;
    }

    @CliCommand(value={"createProject"}, help="Creates a new project and opens it.")
    public void createProjectCmd(@CliOption(key={"title"}, mandatory=true, help="Title of the project. Use quotes (\"sample project\") if the title contains spaces.") String title, @CliOption(key={"description"}, mandatory=false, help="Description of the project. Use quotes (\"sample description\") if the description contains spaces.") String description, @CliOption(key={"metadataServiceType"}, mandatory=false, unspecifiedDefaultValue="md", help="Type of metadata service the project will have. Allowed values=[\"md\", \"metadata\"].") String serviceType) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            String newProjectId = this.createProject(title, description, serviceType);
            this.openProjectCommand.openProjectCmd(newProjectId);
            this.context.setCurrentProject(newProjectId);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    protected String createProject(String title, String description, String serviceType) {
        this.projectClient = new ProjectClient((CanRestClient)this.context.getCanRestClient());
        MetadataServiceType metadataServiceType = MetadataServiceType.fromValue((String)serviceType);
        ProjectDTO project = this.projectClient.createProject(title, description, metadataServiceType);
        System.out.println("Created project " + project.getId());
        return project.getId();
    }
}

