/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetTypeEnum;
import com.cleveranalytics.service.metadata.client.IDatasetClient;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasetDTO;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasets;
import com.cleveranalytics.shell.ExecutionType;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.commands.project.DumpProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class DumpCsvCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(DumpCsvCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public DumpCsvCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"dumpCsv"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getLoggedUser() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"dumpCsv"}, help="Dump DWH data of one dataset to a CSV file.")
    public void dumpCsvCmd(@CliOption(key={"directory"}, mandatory=false, help="Path to a dump directory, where the project will be saved in a defined directory structure.") String directory, @CliOption(key={"dataset"}, mandatory=true, help="Name of the dataset to dump.") String datasetName, @CliOption(key={"execution"}, mandatory=false, unspecifiedDefaultValue="async", help="Data dump execution mode. Allowed values=[\"async\", \"sync\"].") String execution) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            File shellDirectory = DumpProjectCommand.createShellDirectory(directory, this.context);
            File dumpDirectory = DumpProjectCommand.createDumpDirectory(shellDirectory, this.context, true);
            DumpProjectCommand.createDataDumpDirectory(dumpDirectory, this.context);
            DumpProjectCommand.createMetadataDumpDirectory(dumpDirectory, this.context);
            logger.error("");
            AbstractShellClient shellClient = this.context.getShellClient();
            shellClient.createMetadataDumpFile(this.context);
            this.dumpDataset(datasetName, execution);
            logger.error("\nDump {} opened and set as current\n", (Object)this.context.getCurrentDump());
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    private void dumpDataset(String datasetName, String execution) throws IOException {
        IDatasetClient datasetClient = this.context.getDatasetClient();
        IDatasetDTO dataset = datasetClient.getDatasetByName(this.context.getCurrentProject(), datasetName);
        if (!dataset.getRef().getType().equals(DatasetTypeEnum.DWH_TYPE.toString())) {
            throw new IllegalArgumentException("Dataset " + datasetName + " is not of DWH type, it's data cannot be dumped");
        }
        DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)this.context.getCanRestClient());
        ExecutionType executionType = dwhShellClient.convertExecutionType(execution);
        IDatasets oneDataset = new IDatasets();
        oneDataset.add((Object)dataset);
        this.dumpData(this.context, (IDatasets<IDatasetDTO>)oneDataset, executionType, false);
    }

    public void dumpData(ShellContext context, IDatasets<IDatasetDTO> datasets, ExecutionType executionType, boolean skipErrors) throws IOException {
        DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)context.getCanRestClient());
        dwhShellClient.dumpData(context, executionType, datasets, skipErrors);
    }
}

