/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.metadata.client.IDatasetClient;
import com.cleveranalytics.service.metadata.rest.dto.MetadataObjectType;
import com.cleveranalytics.service.metadata.rest.dto.dataset.DatasetDwhTypeDTO;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasetDTO;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasets;
import com.cleveranalytics.shell.ExecutionType;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.commands.project.DumpCsvCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.DumpFileWriteException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class DumpProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(DumpProjectCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public DumpProjectCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"dumpProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getLoggedUser() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"dumpProject"}, help="Dump project DWH data and metadata to a local directory.")
    public void dumpProjectCmd(@CliOption(key={"directory"}, mandatory=false, help="Path to a dump directory, where the project will be saved in a defined directory structure.") String inputDirectory, @CliOption(key={"skipData"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip DWH data dump.") boolean skipData, @CliOption(key={"skipMetadata"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip metadata dump.") boolean skipMetadata, @CliOption(key={"execution"}, mandatory=false, unspecifiedDefaultValue="async", help="Project data dump execution type. Allowed values=[\"async\", \"sync\"].") String execution, @CliOption(key={"nativeDatasetsOnly"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import only native project datasets (those without origin attribute).") boolean nativeDatasetsOnly, @CliOption(key={"force"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Force dump to continue when dump of one dataset fails.") boolean force) {
        this.dumpProject(inputDirectory, skipData, skipMetadata, execution, nativeDatasetsOnly, true, force);
    }

    protected void dumpProject(String inputDirectory, boolean skipData, boolean skipMetadata, String execution, boolean nativeDatasetsOnly, boolean createNewDirectory, boolean force) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (skipData && skipMetadata) {
                logger.error("Skipping project dump - nothing to dump\n");
            } else {
                File shellDirectory = DumpProjectCommand.createShellDirectory(inputDirectory, this.context);
                File dumpDirectory = DumpProjectCommand.createDumpDirectory(shellDirectory, this.context, createNewDirectory);
                File dataDumpDirectory = DumpProjectCommand.createDataDumpDirectory(dumpDirectory, this.context);
                File metadataDumpDirectory = DumpProjectCommand.createMetadataDumpDirectory(dumpDirectory, this.context);
                logger.error("");
                AbstractShellClient shellClient = this.context.getShellClient();
                shellClient.createMetadataDumpFile(this.context);
                if (!skipMetadata) {
                    this.dumpMetadata(metadataDumpDirectory);
                } else {
                    logger.error("Skipping metadata dump of project {}\n", (Object)this.context.getCurrentProject());
                }
                if (!skipData) {
                    this.dumpData(dataDumpDirectory, execution, nativeDatasetsOnly, force);
                } else {
                    logger.error("Skipping data dump of project {}\n", (Object)this.context.getCurrentProject());
                }
                logger.error("Dump {} opened and set as current\n", (Object)this.context.getCurrentDump());
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    protected void dumpData(File dataDumpPath, String execution, boolean nativeDatasetsOnly, boolean force) throws IOException {
        IDatasetClient datasetClient = this.context.getDatasetClient();
        IDatasets dwhDatasets = nativeDatasetsOnly ? datasetClient.getNativeDatasets(this.context.getCurrentProject()) : datasetClient.getDatasetsByType(this.context.getCurrentProject(), DatasetDwhTypeDTO.class);
        DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)this.context.getCanRestClient());
        ExecutionType executionType = dwhShellClient.convertExecutionType(execution);
        DumpCsvCommand dumpCsvCommand = new DumpCsvCommand(this.context);
        dumpCsvCommand.dumpData(this.context, (IDatasets<IDatasetDTO>)dwhDatasets, executionType, force);
        logger.error("\nProject DWH data successfully dumped to {}\n", (Object)dataDumpPath.getPath());
    }

    protected void dumpMetadata(File metadataDumpPath) throws IOException {
        logger.error("Metadata dump started...\n");
        AbstractShellClient shellClient = this.context.getShellClient();
        shellClient.dumpObjectsLocal(this.context);
        logger.error("\nProject metadata successfully dumped to {}\n", (Object)metadataDumpPath.getPath());
    }

    protected static File createShellDirectory(String inputDirectory, ShellContext context) {
        File shellDirectory;
        if (inputDirectory == null) {
            if (context.getShellDirectory() == null) {
                shellDirectory = new File(System.getProperty("user.dir"));
                System.out.println("No directory specified, setting " + shellDirectory.toString() + " as shell directory");
            } else {
                shellDirectory = new File(context.getShellDirectory());
            }
        } else {
            shellDirectory = new File(inputDirectory);
        }
        if (!shellDirectory.exists()) {
            if (shellDirectory.mkdirs()) {
                logger.error("Creating shell directory {}", (Object)shellDirectory.toString());
            } else {
                throw new DumpFileWriteException("Cannot create shell directory=" + shellDirectory.getAbsolutePath() + ".");
            }
        }
        context.setShellDirectory(shellDirectory.toString());
        return shellDirectory;
    }

    protected static File createProjectDirectory(File shellDirectory, ShellContext context) {
        File projectDirectory = Paths.get(shellDirectory.getAbsolutePath(), context.getCurrentProject()).toFile();
        if (!projectDirectory.exists() && projectDirectory.mkdirs()) {
            logger.error("Creating project directory {}", (Object)projectDirectory.toString());
        }
        return projectDirectory;
    }

    protected static File createDumpDirectory(File shellDirectory, ShellContext context, boolean createNewDirectory) {
        if (context.getCurrentDump() != null && !createNewDirectory) {
            logger.error("Import in progress, dumping into actual directory: {}", (Object)context.getCurrentDump());
            return context.getDumpPath().toFile();
        }
        String dumpDate = FileTools.DUMP_ID_FORMAT.format(new Date());
        context.setCurrentDump(dumpDate);
        File dumpDirectory = Paths.get(shellDirectory.getAbsolutePath(), context.getCurrentProject(), dumpDate).toFile();
        if (!dumpDirectory.exists()) {
            if (dumpDirectory.mkdirs()) {
                logger.error("Creating dump directory {}", (Object)dumpDirectory.toString());
            } else {
                throw new DumpFileWriteException("Cannot create dump directory=" + dumpDirectory.getAbsolutePath() + ".");
            }
        }
        return dumpDirectory;
    }

    protected static File createDataDumpDirectory(File dumpDirectory, ShellContext context) {
        if (context.getDataDumpPath().toFile().exists()) {
            return context.getDataDumpPath().toFile();
        }
        File dataDumpDirectory = Paths.get(dumpDirectory.getAbsolutePath(), "data").toFile();
        if (!dataDumpDirectory.exists()) {
            if (dataDumpDirectory.mkdirs()) {
                logger.error("Creating data dump directory {}", (Object)dataDumpDirectory.toString());
            } else {
                throw new DumpFileWriteException("Cannot create data dump directory=" + dataDumpDirectory.getAbsolutePath() + ".");
            }
        }
        return dataDumpDirectory;
    }

    protected static File createMetadataDumpDirectory(File dumpDirectory, ShellContext context) {
        if (context.getMetadataDumpPath().toFile().exists()) {
            return context.getMetadataDumpPath().toFile();
        }
        File metadataDumpDirectory = Paths.get(dumpDirectory.getAbsolutePath(), "metadata").toFile();
        if (!metadataDumpDirectory.exists()) {
            if (metadataDumpDirectory.mkdirs()) {
                logger.error("Creating metadata dump directory {}", (Object)metadataDumpDirectory.toString());
                List typeList = context.getShellClient() instanceof MdShellClient ? MdObjectType.getList() : MetadataObjectType.getList();
                for (String objectType : typeList) {
                    File subdirectory = Paths.get(context.getMetadataDumpPath().toString(), objectType).toFile();
                    if (subdirectory.mkdirs()) continue;
                    throw new DumpFileWriteException("Cannot create metadata type subdirectory=" + metadataDumpDirectory.getAbsolutePath() + ".");
                }
            } else {
                throw new DumpFileWriteException("Cannot create metadata dump directory=" + metadataDumpDirectory.getAbsolutePath() + ".");
            }
        }
        return metadataDumpDirectory;
    }
}

