/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.authn.client.AuthnClient;
import com.cleveranalytics.service.authn.client.UserCredentialsCanRestClient;
import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.rest.dto.MdFileList;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDwhTypeDTO;
import com.cleveranalytics.service.metadata.client.IDatasetClient;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasetDTO;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasets;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.ProjectServices;
import com.cleveranalytics.service.project.rest.dto.Role;
import com.cleveranalytics.shell.ExecutionType;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.PrefixLinkReplacer;
import com.cleveranalytics.shell.commands.connected.OpenProjectCommand;
import com.cleveranalytics.shell.commands.login.LoginCommand;
import com.cleveranalytics.shell.commands.project.DumpCsvCommand;
import com.cleveranalytics.shell.commands.project.DumpProjectCommand;
import com.cleveranalytics.shell.commands.project.OpenDumpCommand;
import com.cleveranalytics.shell.config.BannerProvider;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DumpMetadataDTO;
import com.cleveranalytics.shell.exception.CleverAnalyticsShellException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Component
public class ImportCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(ImportCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;
    private ClientHttpRequestFactory requestFactory;
    private DumpProjectCommand dumpProjectCommand;
    private LoginCommand loginCommand;
    private OpenProjectCommand openProjectCommand;
    private OpenDumpCommand openDumpCommand;
    private DumpCsvCommand dumpCsvCommand;

    @Autowired
    public ImportCommand(ShellContext context, @Qualifier(value="nonCachingHttpClientRequestFactory") ClientHttpRequestFactory requestFactory) {
        this.context = context;
        this.requestFactory = requestFactory;
        this.dumpProjectCommand = new DumpProjectCommand(context);
        this.loginCommand = new LoginCommand(context, requestFactory);
        this.openProjectCommand = new OpenProjectCommand(context, requestFactory);
        this.openDumpCommand = new OpenDumpCommand(context);
        this.dumpCsvCommand = new DumpCsvCommand(context);
    }

    @CliAvailabilityIndicator(value={"import"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"import"}, help="Import specific parts of a project to another project.")
    public void importCmd(@CliOption(key={"project"}, mandatory=false, help="ID of a project from which the files will be imported.") String project, @CliOption(key={"server"}, mandatory=false, specifiedDefaultValue="https://secure.cleveranalytics.com", help="Hostname of the server from which the project will be imported. Defaults to https://secure.cleveranalytics.com.") String server, @CliOption(key={"dump"}, mandatory=false, help="ID of a project dump which will be imported. E.g. 2019-01-01_12-00-00.") String dump, @CliOption(key={"dashboards"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import dashboards of the specified project.") boolean dashboards, @CliOption(key={"dataPermissions"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import dataPermissions of the specified project.") boolean dataPermissions, @CliOption(key={"datasets"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import datasets of the specified project.") boolean datasets, @CliOption(key={"exports"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import exports of the specified project.") boolean exports, @CliOption(key={"indicators"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import indicators of the specified project.") boolean indicators, @CliOption(key={"indicatorDrills"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import indicator drills of the specified project.") boolean indicatorDrills, @CliOption(key={"markers"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import markers of the specified project.") boolean markers, @CliOption(key={"markerSelectors"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import marker selectors of the specified project.") boolean markerSelectors, @CliOption(key={"metrics"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import metrics of the specified project.") boolean metrics, @CliOption(key={"projectSettings"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import specified project's settings.") boolean projectSettings, @CliOption(key={"views"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import views of the specified project.") boolean views, @CliOption(key={"prefix"}, mandatory=false, help="Prefix which will be added to the name of all imported objects.") String prefix, @CliOption(key={"execution"}, mandatory=false, unspecifiedDefaultValue="async", help="Project data import execution type. Allowed values=[\"async\", \"sync\"].") String execution, @CliOption(key={"force"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Force import when there are DWH model/data violations in source project, or the source project is not empty.") boolean force, @CliOption(key={"skipData"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip DWH data import.") boolean skipData) {
        ShellContext backup = this.createBackupContext();
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            LinkedHashMap<String, Boolean> importArguments = new LinkedHashMap<String, Boolean>();
            importArguments.put("dashboards", dashboards);
            importArguments.put("dataPermissions", dataPermissions);
            importArguments.put("datasets", datasets);
            importArguments.put("exports", exports);
            importArguments.put("indicators", indicators);
            importArguments.put("indicatorDrills", indicatorDrills);
            importArguments.put("markers", markers);
            importArguments.put("markerSelectors", markerSelectors);
            importArguments.put("metrics", metrics);
            importArguments.put("projectSettings", projectSettings);
            importArguments.put("views", views);
            if (!importArguments.containsValue(true)) {
                importArguments = new LinkedHashMap();
            }
            if (!this.checkImportParameters(server, project, dump)) {
                return;
            }
            if (dump == null) {
                this.importProject(server, project, importArguments, prefix, execution, force, skipData);
            } else {
                this.importDump(project, dump, importArguments, prefix, execution, force, skipData);
            }
        }
        catch (Exception ex) {
            this.restoreBackupContext(backup);
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    protected void importDump(String sourceProjectId, String sourceDumpId, Map<String, Boolean> typesToImport, String prefix, String execution, boolean force, boolean skipData) throws IOException {
        if (sourceProjectId == null) {
            sourceProjectId = this.context.getCurrentProject();
        }
        MdShellClient shellClient = (MdShellClient)this.context.getShellClient();
        boolean shouldProceed = this.checkEmptyProject(this.context.getCurrentProject(), shellClient, force);
        if (!shouldProceed) {
            return;
        }
        logger.error("Importing local dump {} of project {}...\n", (Object)sourceDumpId, (Object)sourceProjectId);
        File sourceProjectDirectory = Paths.get(this.context.getDumpDirectory(), sourceProjectId).toFile();
        File sourceDumpDirectory = Paths.get(this.context.getDumpDirectory(), sourceProjectId, sourceDumpId).toFile();
        if (sourceProjectDirectory == null || !sourceProjectDirectory.exists() || !sourceProjectDirectory.canRead()) {
            throw new FileNotFoundException("Source project directory=" + sourceProjectDirectory + " not found.");
        }
        if (sourceDumpDirectory == null || !sourceDumpDirectory.exists() || !sourceDumpDirectory.canRead()) {
            throw new FileNotFoundException("Source dump directory=" + sourceDumpDirectory + " not found.");
        }
        if (this.context.getCurrentDump() == null) {
            this.dumpProjectCommand.dumpProject(null, true, false, execution, false, true, force);
        }
        File sourceMetadataDumpDirectory = Paths.get(this.context.getDumpDirectory(), sourceProjectId, sourceDumpId, "metadata").toFile();
        List<File> metadataFiles = FileTools.findAllMetadataInDump(sourceMetadataDumpDirectory);
        List<File> wrappedMetadataFiles = FileTools.filterUnwrappedMetadataFiles(metadataFiles);
        int importedObjects = 0;
        for (File file : wrappedMetadataFiles) {
            MdObjectDumpDTO object = FileTools.loadFileAsMdObjectDump(file);
            MdObjectDTO unwrappedObject = shellClient.unwrapMdObject(object);
            if (typesToImport.size() != 0 && !typesToImport.get(unwrappedObject.getType().toStringPlural()).booleanValue()) continue;
            String objectName = unwrappedObject.getName();
            if (prefix != null) {
                objectName = prefix + objectName;
                unwrappedObject.setName(objectName);
            }
            File unwrappedObjectFile = this.createUnwrappedObjectFile(unwrappedObject);
            FileTools.saveObjectToJson(unwrappedObject, unwrappedObjectFile.getAbsolutePath());
            logger.error("Imported object " + file.getName());
            ++importedObjects;
        }
        logger.error("");
        int importedCsvs = 0;
        if (!skipData) {
            File sourceDataDumpDirectory = Paths.get(this.context.getDumpDirectory(), sourceProjectId, sourceDumpId, "data").toFile();
            List<File> csvFiles = FileTools.findAllDataInDump(sourceDataDumpDirectory);
            if (typesToImport.size() == 0 || typesToImport.get("datasets").booleanValue()) {
                for (File file : csvFiles) {
                    File newCsvFile = Paths.get(this.context.getDataDumpPath().toString(), file.getName()).toFile();
                    FileUtils.copyFile((File)file, (File)newCsvFile);
                    ++importedCsvs;
                    logger.error("Imported csv file " + file.getName());
                }
                logger.error("");
            }
        }
        File dumpMetadataFile = Paths.get(this.context.getDumpDirectory(), sourceProjectId, sourceDumpId, "dumpMetadata.json").toFile();
        DumpMetadataDTO dumpMetadata = FileTools.loadFileAsClass(dumpMetadataFile, DumpMetadataDTO.class);
        this.printImportDumpMessage(sourceDumpId, sourceProjectId, dumpMetadata.getProjectTitle(), this.context.getCurrentDump(), this.context.getCurrentProject(), this.context.getProjectTitle(), importedObjects, importedCsvs);
    }

    protected boolean checkImportParameters(String server, String project, String dump) {
        if (server == null && project == null && dump == null) {
            System.out.println(BannerProvider.ANSI_MAGENTA + "You should specify option --project with either --server or --dump option following" + BannerProvider.ANSI_RESET);
            return false;
        }
        if (server != null && dump != null || server == null && dump == null) {
            System.out.println(BannerProvider.ANSI_MAGENTA + "Either --server or --dump option must be specified");
            System.out.println("Use --server option to import a project from a server");
            System.out.println("Use --dump option to import a local dump of a project" + BannerProvider.ANSI_RESET);
            return false;
        }
        return true;
    }

    protected boolean checkEmptyProject(String projectId, MdShellClient shellClient, boolean force) throws IOException {
        System.out.printf("Checking if the project " + projectId + " is empty... ", new Object[0]);
        MdFileList fileList = (MdFileList)shellClient.getObjectsList(this.context);
        if (!fileList.isEmpty()) {
            logger.error("FAIL\n");
            if (!force) {
                logger.error("The project already contains " + fileList.size() + " metadata objects.");
                logger.error("To avoid conflicts, the destination project should be empty. To do that, use truncateProject command.");
                logger.error("If you want to proceed with the import anyway, use the --force argument.\n");
            }
            return force;
        }
        logger.error("OK\n");
        return true;
    }

    protected File createUnwrappedObjectFile(MdObjectDTO unwrappedObject) {
        return Paths.get(this.context.getMetadataDumpPath().toString(), unwrappedObject.getType().toStringPlural(), FileTools.appendExtension(unwrappedObject.getName(), ".json")).toFile();
    }

    protected void importProject(String sourceServer, String sourceProjectId, Map<String, Boolean> typesToImport, String prefix, String execution, boolean force, boolean skipData) throws IOException {
        boolean firstImport;
        UserCredentialsCanRestClient sourceRestClient;
        DwhShellClient dwhShellClient;
        Map<String, Integer> violationTypes;
        boolean shouldProceed;
        ProjectClient sourceProjectClient;
        Role roleInProject;
        this.importCompatibilityCheck(sourceServer, sourceProjectId, this.context.getConnectedServer(), this.context.getCurrentProject(), typesToImport);
        if (!(typesToImport.get("datasets") == null && typesToImport.containsValue(true) || (roleInProject = (sourceProjectClient = this.getSourceProjectClient(sourceServer)).getMembershipInProject(sourceProjectId).getRole()).equals((Object)Role.VIEWER) || roleInProject.equals((Object)Role.DUMP_DATA) || (shouldProceed = this.printValidationCheck(violationTypes = (dwhShellClient = new DwhShellClient(sourceProjectClient.getCanRestClient())).simpleProjectIntegrityCheck(sourceRestClient = this.getSourceUserCredentialsClient(sourceServer), sourceProjectId), force)))) {
            return;
        }
        logger.error("Importing project {} from server {}...\n", (Object)sourceProjectId, (Object)sourceServer);
        boolean bl = firstImport = this.context.getCurrentDump() == null;
        if (firstImport) {
            this.dumpProjectCommand.dumpProject(null, true, false, execution, false, true, force);
        }
        boolean importDatasets = this.shouldImportDatasets(typesToImport);
        boolean importMdObjects = this.shouldImportMdObjects(typesToImport);
        File destinationDataDirectory = this.context.getDataDumpPath().toFile();
        String destinationServer = this.context.getConnectedServer();
        String destinationProjectId = this.context.getCurrentProject();
        String destinationProjectTitle = this.context.getProjectTitle();
        String destinationDumpId = this.context.getCurrentDump();
        AbstractShellClient shellClient = this.context.getShellClient();
        this.dumpSourceProject(sourceServer, sourceProjectId, execution, force);
        String sourceProjectTitle = this.context.getProjectTitle();
        String sourceDumpId = this.context.getCurrentDump();
        File sourceDataDirectory = this.context.getDataDumpPath().toFile();
        IDatasets<IDatasetDTO> sourceDatasets = new IDatasets<IDatasetDTO>();
        if (importDatasets) {
            File sourceDatasetsPath = shellClient.getCurrentDatasetsPath(this.context);
            sourceDatasets = shellClient.loadDatasetsFromPath(sourceDatasetsPath);
        }
        ArrayList<MdObjectDTO> sourceMdObjects = new ArrayList();
        ArrayList<MdObjectDTO> destinationMdObjects = new ArrayList();
        if (importMdObjects) {
            File sourceMetadataPath = this.context.getMetadataDumpPath().toFile();
            sourceMdObjects = ((MdShellClient)shellClient).loadMdObjectsFromPath(sourceMetadataPath, typesToImport);
            destinationMdObjects = this.processMdObjects(prefix, sourceServer, sourceMdObjects);
        }
        this.openDestinationProjectDump(destinationServer, destinationProjectId, destinationDumpId);
        File destinationDatasetsPath = shellClient.getCurrentDatasetsPath(this.context);
        File destinationMetadataPath = this.context.getMetadataDumpPath().toFile();
        IDatasets<IDatasetDTO> destinationDatasets = new IDatasets<IDatasetDTO>();
        List<File> destinationCsvs = new ArrayList<File>();
        if (importDatasets) {
            destinationDatasets = shellClient.loadDatasetsFromPath(destinationDatasetsPath);
            destinationDatasets = this.processDatasets(prefix, sourceServer, sourceProjectId, sourceDatasets, destinationDatasets);
            if (!skipData) {
                this.dumpSourceData(sourceServer, sourceProjectId, sourceDumpId, destinationDatasets, execution, force);
                FileUtils.copyDirectory((File)sourceDataDirectory, (File)destinationDataDirectory);
                File[] destinationDataDirectoryFiles = destinationDataDirectory.listFiles();
                if (destinationDataDirectoryFiles != null) {
                    destinationCsvs = Arrays.asList(destinationDataDirectoryFiles);
                }
            }
            if (prefix != null) {
                this.addPrefixToCsvFiles(destinationDataDirectory, prefix, !firstImport);
                destinationDatasets = this.addPrefixToDatasets(destinationDatasets, prefix);
            }
            shellClient.saveDatasetsToPath(destinationDatasets, destinationDatasetsPath);
        }
        if (importMdObjects) {
            ((MdShellClient)shellClient).saveMdObjectsToPath(sourceMdObjects, destinationMetadataPath);
        }
        this.openDestinationProjectDump(destinationServer, destinationProjectId, destinationDumpId);
        this.printImportServerMessage(sourceProjectId, sourceProjectTitle, sourceServer, destinationProjectId, destinationProjectTitle, destinationServer, destinationDatasets, destinationMdObjects, destinationCsvs);
    }

    private ProjectClient getSourceProjectClient(String sourceServer) {
        return new ProjectClient((CanRestClient)this.getSourceUserCredentialsClient(sourceServer));
    }

    private UserCredentialsCanRestClient getSourceUserCredentialsClient(String sourceServer) {
        return new UserCredentialsCanRestClient(new AuthnClient(this.serviceName, sourceServer, this.requestFactory), this.serviceName, sourceServer, this.context.getUserEmail(), this.context.getUserPassword(), this.requestFactory);
    }

    private boolean printValidationCheck(Map<String, Integer> violationTypes, boolean force) {
        if (violationTypes.size() > 0) {
            logger.error("FAIL\n");
            logger.error("There are DWH model/data integrity violations in the source project:");
            logger.error(violationTypes.toString() + "\n");
            if (!force) {
                logger.error("For a verbose output, open the source project and use validate command.");
                logger.error("If you want to proceed with the import anyway, use the --force argument.\n");
            }
            return force;
        }
        logger.error("OK\n");
        return true;
    }

    private void printImportServerMessage(String sourceProjectId, String sourceProjectTitle, String sourceServer, String destinationProjectId, String destinationProjectTitle, String destinationServer, IDatasets<IDatasetDTO> destinationDatasets, List<MdObjectDTO> destinationMdObjects, List<File> destinationCsvs) {
        logger.error("\nImport finished!");
        logger.error("Source project: {} ({})", (Object)sourceProjectId, (Object)sourceProjectTitle);
        logger.error("Source server: {}", (Object)sourceServer);
        logger.error("Destination project: {} ({})", (Object)destinationProjectId, (Object)destinationProjectTitle);
        logger.error("Destination server: {}", (Object)destinationServer);
        logger.error("Imported datasets: {}", (Object)destinationDatasets.size());
        logger.error("Imported metadata objects: {}", (Object)destinationMdObjects.size());
        logger.error("Imported CSV files: {}", (Object)destinationCsvs.size());
        logger.error("\nTo view detailed imported content, use status command.");
        logger.error("Now you can make changes, or import another project.");
        if (destinationDatasets.size() > 0 || destinationMdObjects.size() > 0) {
            logger.error("When you're done, use addMetadata command to add the metadata to the project.");
        }
        if (destinationDatasets.size() > 0) {
            logger.error("To push the data to the project, use pushProject command.");
        }
        logger.error("");
    }

    private void printImportDumpMessage(String sourceDumpId, String sourceProjectId, String sourceProjectTitle, String destinationDumpId, String destinationProjectId, String destinationProjectTitle, int importedObjects, int importedCsvs) {
        logger.error("\nImport finished!");
        logger.error("Source project: {} ({})", (Object)sourceProjectId, (Object)sourceProjectTitle);
        logger.error("Source dump: {}", (Object)sourceDumpId);
        logger.error("Destination project: {} ({})", (Object)destinationProjectId, (Object)destinationProjectTitle);
        logger.error("Destination dump: {}", (Object)destinationDumpId);
        logger.error("Imported metadata objects: {}", (Object)importedObjects);
        logger.error("Imported CSV files: {}", (Object)importedCsvs);
        logger.error("\nTo view detailed imported content, use status command.");
        logger.error("When you're done, use addMetadata command to add the metadata to the project.");
        logger.error("To push the data to the project, use pushProject command.");
        logger.error("");
    }

    private void importCompatibilityCheck(String sourceServer, String sourceProjectId, String destinationServer, String destinationProjectId, Map<String, Boolean> typesToImport) {
        ProjectClient destinationProjectClient;
        ProjectClient sourceProjectClient = destinationProjectClient = new ProjectClient((CanRestClient)this.context.getCanRestClient());
        if (!sourceServer.equals(destinationServer)) {
            sourceProjectClient = this.getSourceProjectClient(sourceServer);
        }
        try {
            sourceProjectClient.getProject(sourceProjectId);
        }
        catch (HttpClientErrorException ex) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND, "Project id=" + sourceProjectId + " not found on server=" + sourceServer + ".");
        }
        ProjectServices sourceProjectServices = sourceProjectClient.getProject(sourceProjectId).getServices();
        ProjectServices destinationProjectServices = destinationProjectClient.getProject(destinationProjectId).getServices();
        if (!this.compatibleMetadataServices(sourceProjectServices, destinationProjectServices)) {
            throw new CleverAnalyticsShellException("Source project and destination project use different types of metadata services. Only imports from a project with the same type of service are allowed.");
        }
        if (!this.compatibleObjectTypes(sourceProjectServices, destinationProjectServices, typesToImport)) {
            throw new CleverAnalyticsShellException("Source project and destination project use 'metadata' service type. Only 'datasets' import is allowed.");
        }
    }

    private boolean compatibleMetadataServices(ProjectServices sourceProjectServices, ProjectServices destinationProjectServices) {
        return sourceProjectServices.containsKey((Object)"metadata") && destinationProjectServices.containsKey((Object)"metadata") || sourceProjectServices.containsKey((Object)"md") && destinationProjectServices.containsKey((Object)"md");
    }

    private boolean compatibleObjectTypes(ProjectServices sourceProjectServices, ProjectServices destinationProjectServices, Map<String, Boolean> typesToImport) {
        return !sourceProjectServices.containsKey((Object)"metadata") && !destinationProjectServices.containsKey((Object)"metadata") || !this.shouldImportMdObjects(typesToImport);
    }

    private boolean shouldImportMdObjects(Map<String, Boolean> typesToImport) {
        return typesToImport.size() == 0 || typesToImport.get("dashboards") != false || typesToImport.get("dataPermissions") != false || typesToImport.get("exports") != false || typesToImport.get("indicators") != false || typesToImport.get("indicatorDrills") != false || typesToImport.get("markers") != false || typesToImport.get("markerSelectors") != false || typesToImport.get("metrics") != false || typesToImport.get("projectSettings") != false || typesToImport.get("views") != false;
    }

    private boolean shouldImportDatasets(Map<String, Boolean> typesToImport) {
        return typesToImport.size() == 0 || typesToImport.get("datasets") != false;
    }

    private String getAbsoluteDatasetURI(String server, String projectId, String datasetName) {
        IDatasetClient datasetClient = this.context.getDatasetClient();
        return datasetClient.getAbsoluteDatasetURI(server, projectId, datasetName);
    }

    private String getAbsoluteObjectURI(String server, String projectId, MdObjectDTO mdObject) {
        String mdObjectType = mdObject.getType().toStringPlural();
        String mdObjectName = mdObject.getName();
        IDatasetClient datasetClient = this.context.getDatasetClient();
        String relativeURI = ((MdObjectClient)datasetClient).objectNameToUri(projectId, mdObjectType, mdObjectName).toString();
        return server + relativeURI;
    }

    private void dumpSourceProject(String sourceServer, String sourceProjectId, String execution, boolean force) {
        this.loginCommand.loginCmd(this.context.getUserEmail(), this.context.getUserPassword(), sourceServer, this.context.getDumpDirectory());
        this.openProjectCommand.openProjectCmd(sourceProjectId);
        this.dumpProjectCommand.dumpProject(null, true, false, execution, false, false, force);
    }

    private void dumpSourceData(String sourceServer, String sourceProjectId, String sourceDumpId, IDatasets<IDatasetDTO> destinationDatasets, String execution, boolean force) throws IOException {
        this.loginCommand.loginCmd(this.context.getUserEmail(), this.context.getUserPassword(), sourceServer, this.context.getDumpDirectory());
        this.openProjectCommand.openProjectCmd(sourceProjectId);
        this.openDumpCommand.openDumpCmd(this.context.getDumpDirectory(), sourceDumpId);
        IDatasets dwhDatasets = new IDatasets();
        for (IDatasetDTO dataset : destinationDatasets) {
            if (!dataset.getRef().getType().equals("dwh")) continue;
            dwhDatasets.add((Object)dataset);
        }
        DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)this.context.getCanRestClient());
        ExecutionType executionType = dwhShellClient.convertExecutionType(execution);
        this.dumpCsvCommand.dumpData(this.context, (IDatasets<IDatasetDTO>)dwhDatasets, executionType, force);
    }

    private void openDestinationProjectDump(String destinationServer, String destinationProjectId, String destinationDumpId) {
        this.loginCommand.loginCmd(this.context.getUserEmail(), this.context.getUserPassword(), destinationServer, this.context.getDumpDirectory());
        this.openProjectCommand.openProjectCmd(destinationProjectId);
        this.openDumpCommand.openDumpCmd(this.context.getDumpDirectory(), destinationDumpId);
    }

    private List<MdObjectDTO> processMdObjects(String prefix, String sourceServer, List<MdObjectDTO> sourceMdObjects) {
        AbstractShellClient shellClient = this.context.getShellClient();
        for (MdObjectDTO mdObject : sourceMdObjects) {
            if (prefix != null) {
                PrefixLinkReplacer prefixLinkReplacer = new PrefixLinkReplacer(prefix, mdObject.getName());
                mdObject = ((MdShellClient)shellClient).replaceURILinks(mdObject, prefixLinkReplacer);
                mdObject.setName(prefix + mdObject.getName());
            }
            String origin = this.getAbsoluteObjectURI(sourceServer, this.context.getCurrentProject(), mdObject);
            mdObject.setOrigin(origin);
        }
        return sourceMdObjects;
    }

    private IDatasets<IDatasetDTO> processDatasets(String prefix, String sourceServer, String sourceProjectId, IDatasets<IDatasetDTO> sourceDatasets, IDatasets<IDatasetDTO> destinationDatasets) {
        AbstractShellClient shellClient = this.context.getShellClient();
        IDatasets datasetsToImport = new IDatasets();
        for (IDatasetDTO sourceDataset : sourceDatasets) {
            sourceDataset = this.setIDatasetType(sourceDataset, shellClient);
            if (prefix == null) {
                IDatasetDTO destinationDataset = destinationDatasets.getDatasetByName(sourceDataset.getName());
                if (destinationDataset != null) {
                    if (sourceDataset.getOrigin() == null || sourceDataset.getOrigin().equals(destinationDataset.getOrigin())) continue;
                    logger.error("Warning: source dataset={} and destination dataset={} have the same name, but different origin.", (Object)sourceDataset.getName(), (Object)destinationDataset.getName());
                    continue;
                }
                if (sourceDataset.getOrigin() == null) {
                    sourceDataset.setOrigin(this.getAbsoluteDatasetURI(sourceServer, sourceProjectId, sourceDataset.getName()));
                }
                datasetsToImport.add((Object)sourceDataset);
                continue;
            }
            if (sourceDataset.getOrigin() == null) {
                sourceDataset.setOrigin(this.getAbsoluteDatasetURI(sourceServer, sourceProjectId, sourceDataset.getName()));
            }
            datasetsToImport.add((Object)sourceDataset);
        }
        return datasetsToImport;
    }

    private void addPrefixToCsvFiles(File dataDumpDirectory, String prefix, boolean makeCopies) throws IOException {
        File[] files = dataDumpDirectory.listFiles();
        if (files != null) {
            for (File csvFile : files) {
                String basePath = FilenameUtils.getFullPath((String)csvFile.getPath());
                String newFilename = prefix + FilenameUtils.getName((String)csvFile.toString());
                if (makeCopies) {
                    File newFile = new File(basePath + newFilename);
                    FileUtils.copyFile((File)csvFile, (File)newFile);
                    if (newFile.exists()) continue;
                    throw new FileSystemException("Failed to copy CSV file " + csvFile.getPath());
                }
                if (csvFile.renameTo(new File(basePath + newFilename))) continue;
                throw new FileSystemException("Failed to rename CSV file " + csvFile.getPath());
            }
        }
    }

    private IDatasets<IDatasetDTO> addPrefixToDatasets(IDatasets<IDatasetDTO> datasets, String prefix) {
        for (IDatasetDTO dataset : datasets) {
            String table;
            dataset.setName(prefix + dataset.getName());
            if (dataset.getRef() instanceof com.cleveranalytics.service.metadata.rest.dto.dataset.DatasetDwhTypeDTO) {
                table = ((com.cleveranalytics.service.metadata.rest.dto.dataset.DatasetDwhTypeDTO)dataset.getRef()).getTable();
                ((com.cleveranalytics.service.metadata.rest.dto.dataset.DatasetDwhTypeDTO)dataset.getRef()).setTable(prefix + table);
                continue;
            }
            if (!(dataset.getRef() instanceof DatasetDwhTypeDTO)) continue;
            table = ((DatasetDwhTypeDTO)dataset.getRef()).getTable();
            ((DatasetDwhTypeDTO)dataset.getRef()).setTable(prefix + table);
        }
        return datasets;
    }

    private IDatasetDTO setIDatasetType(IDatasetDTO dataset, AbstractShellClient shellClient) {
        if (shellClient instanceof MdShellClient) {
            MdObjectDTO.Type mdType = MdObjectDTO.Type.DATASET;
            ((DatasetDTO)dataset).setType(mdType);
        }
        return dataset;
    }

    private ShellContext createBackupContext() {
        ShellContext backup = new ShellContext();
        backup.setUserEmail(this.context.getUserEmail());
        backup.setUserPassword(this.context.getUserPassword());
        backup.setConnectedServer(this.context.getConnectedServer());
        backup.setDumpDirectory(this.context.getDumpDirectory());
        backup.setCurrentDump(this.context.getCurrentDump());
        backup.setCurrentProject(this.context.getCurrentProject());
        backup.setProjectTitle(this.context.getProjectTitle());
        backup.setExitOnError(this.context.isExitOnError());
        backup.setIncompatibleVersion(this.context.isIncompatibleVersion());
        backup.setCanRestClient(this.context.getCanRestClient());
        return backup;
    }

    private void restoreBackupContext(ShellContext backup) {
        this.context.setUserEmail(backup.getUserEmail());
        this.context.setUserPassword(backup.getUserPassword());
        this.context.setConnectedServer(backup.getConnectedServer());
        this.context.setDumpDirectory(backup.getDumpDirectory());
        this.context.setCurrentDump(backup.getCurrentDump());
        this.context.setCurrentProject(backup.getCurrentProject());
        this.context.setProjectTitle(backup.getProjectTitle());
        this.context.setExitOnError(backup.isExitOnError());
        this.context.setIncompatibleVersion(backup.isIncompatibleVersion());
        this.context.setCanRestClient(backup.getCanRestClient());
    }
}

