/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.connected;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.authn.client.AuthnClient;
import com.cleveranalytics.service.authn.client.UserCredentialsCanRestClient;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.ProjectDTO;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Component
public class OpenProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(OpenProjectCommand.class);
    @Value(value="${service.name}")
    private final String serviceName;
    @Value(value="${can.service.project.serverUrl:#{null}}")
    private final String projectServerUrl;
    @Value(value="${can.service.authn.serverUrl:#{null}}")
    private final String authnServerUrl;
    private ClientHttpRequestFactory requestFactory;
    protected ProjectClient projectClient;
    private ShellContext context;
    private String authnServer;
    private String projectServer;

    @Autowired
    public OpenProjectCommand(ShellContext context, @Qualifier(value="nonCachingHttpClientRequestFactory") ClientHttpRequestFactory requestFactory) {
        this.serviceName = null;
        this.projectServerUrl = null;
        this.authnServerUrl = null;
        this.context = context;
        this.requestFactory = requestFactory;
    }

    @CliAvailabilityIndicator(value={"openProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null;
    }

    @CliCommand(value={"openProject"}, help="Open a project and set as current.")
    public void openProjectCmd(@CliOption(key={"project"}, mandatory=true, help="ProjectId of CleverAnalytics project which will be opened to be managed.") String projectId) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (this.authnServerUrl != null) {
                this.authnServer = this.authnServerUrl;
                System.out.println("Obtaining refresh token from " + this.authnServerUrl);
            } else {
                this.authnServer = this.context.getConnectedServer();
            }
            if (this.projectServerUrl != null) {
                this.projectServer = this.projectServerUrl;
                System.out.println("Obtaining projects from " + this.projectServerUrl + "\n");
            } else {
                this.projectServer = this.context.getConnectedServer();
            }
            ProjectDTO projectDTO = this.openProject(projectId);
            System.out.println("Project " + projectId + " (" + projectDTO.getTitle() + ") successfully opened\n");
            if (this.context.getCurrentProject() != null) {
                this.context.setCurrentDump(null);
            }
            this.context.setCurrentProject(projectId);
            this.context.setProjectTitle(projectDTO.getTitle());
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (boolean)this.context.isExitOnError());
        }
    }

    protected ProjectDTO openProject(String projectId) throws HttpClientErrorException {
        ProjectDTO projectDTO;
        try {
            this.projectClient = new ProjectClient((CanRestClient)new UserCredentialsCanRestClient(new AuthnClient(this.serviceName, this.authnServer, this.requestFactory), this.serviceName, this.projectServer, this.context.getUserEmail(), this.context.getUserPassword(), this.requestFactory));
            projectDTO = this.projectClient.getProject(projectId);
        }
        catch (HttpClientErrorException ex) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND, "Project id=" + projectId + " not found on server=" + this.context.getConnectedServer());
        }
        return projectDTO;
    }
}

