/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.md.util.ETag;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.cleveranalytics.service.metadata.rest.dto.MetadataObjectType;
import com.cleveranalytics.service.metadata.util.CanPrettyPrinter;
import com.cleveranalytics.service.project.rest.dto.MetadataServiceType;
import com.cleveranalytics.shell.LocaleMessageInterpolator;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.MetadataShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DumpMetadataDTO;
import com.cleveranalytics.shell.exception.CleverAnalyticsShellException;
import com.cleveranalytics.shell.exception.DumpFileReadException;
import com.cleveranalytics.shell.exception.DumpFileWriteException;
import com.cleveranalytics.shell.exception.MetadataObjectSyntaxException;
import com.cleveranalytics.shell.exception.ValidationViolationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.hibernate.validator.HibernateValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpStatus;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.web.client.HttpClientErrorException;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileTools {
    private static final Logger logger = LoggerFactory.getLogger(FileTools.class);
    public static final DateFormat ISO_8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final DateFormat DUMP_ID_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    public static final Pattern DUMP_ID_PATTERN = Pattern.compile("\\d*-\\d*-\\d*_\\d*-\\d*-\\d*");
    public static final Pattern CSV_PATTERN = Pattern.compile("[a-z][a-z0-9_-]+\\.csv");
    public static final Pattern JSON_PATTERN = Pattern.compile("[a-z][a-z0-9_-]+\\.json");
    private static ObjectMapper mapper = new MdObjectMapper();
    private static Validator validator = FileTools.initValidator();

    public static Validator initValidator() {
        Configuration config = Validation.byProvider(HibernateValidator.class).configure();
        config = config.messageInterpolator((MessageInterpolator)new LocaleMessageInterpolator(config.getDefaultMessageInterpolator()));
        return config.buildValidatorFactory().getValidator();
    }

    public static boolean isMappableToMd(File file) {
        try {
            mapper.readValue(file, MdObjectDumpDTO.class);
            if (!FileTools.isValidMdObjectDump((File)file)) {
                return false;
            }
        }
        catch (IOException ex1) {
            logger.debug("Mapping of file={} to MdObjectDumpDTO failed, message={}", (Object)file.getName(), (Object)ex1.getMessage());
            try {
                mapper.readValue(file, MdObjectDTO.class);
            }
            catch (IOException ex2) {
                logger.debug("Mapping of file={} to MdObjectDTO failed, message={}", (Object)file.getName(), (Object)ex2.getMessage());
                return false;
            }
        }
        return true;
    }

    public static boolean isValidMdObjectDump(File file) {
        try {
            MdObjectDumpDTO mdObjectDump = (MdObjectDumpDTO)mapper.readValue(file, MdObjectDumpDTO.class);
            mdObjectDump.setContent(new MdObjectDTO());
            Set violations = validator.validate((Object)mdObjectDump, new Class[0]);
            if (violations.size() > 0) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static void validateMdObjectDump(File file) throws IOException {
        MdObjectDumpDTO mdObjectDump = (MdObjectDumpDTO)mapper.readValue(file, MdObjectDumpDTO.class);
        mdObjectDump.setContent(new MdObjectDTO());
        Set violations = validator.validate((Object)mdObjectDump, new Class[0]);
        if (violations.size() > 0) {
            throw new ValidationViolationException(violations, file.getName());
        }
    }

    public static <T> T loadFileAsClass(File file, Class<T> clazz) throws IOException {
        try {
            return (T)mapper.readValue(file, clazz);
        }
        catch (IOException ex) {
            if (ex instanceof JsonProcessingException) {
                throw new DumpFileReadException(file.getAbsolutePath(), clazz.getSimpleName(), ex.getMessage());
            }
            throw ex;
        }
    }

    public static MdObjectDumpDTO loadFileAsMdObjectDump(File file) throws IOException {
        try {
            return (MdObjectDumpDTO)mapper.readValue(file, MdObjectDumpDTO.class);
        }
        catch (IOException ex) {
            if (ex instanceof JsonProcessingException) {
                throw new DumpFileReadException(file.getAbsolutePath(), MdObjectDumpDTO.class.getSimpleName(), ex.getMessage());
            }
            throw ex;
        }
    }

    public static File getCsvFileFromPath(String path) throws FileNotFoundException {
        File csvFile = new FileSystemResource(path).getFile();
        if (csvFile == null || !csvFile.exists() || !csvFile.canRead()) {
            throw new FileNotFoundException("Cannot find CSV file on path=" + path + ".");
        }
        return csvFile;
    }

    public static String loadCsvLines(File csvFile, int lines) throws IOException {
        StringBuilder output = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            for (int i = 0; i < lines; ++i) {
                String line = br.readLine();
                if (line == null) continue;
                output.append(line);
                output.append(OsUtils.LINE_SEPARATOR);
            }
        }
        return output.toString();
    }

    public static DumpMetadataDTO loadFileAsDumpMetadataFile(File file) throws IOException {
        try {
            return (DumpMetadataDTO)mapper.readValue(file, DumpMetadataDTO.class);
        }
        catch (IOException ex) {
            if (ex instanceof JsonProcessingException) {
                throw new DumpFileReadException(file.getAbsolutePath(), DumpMetadataDTO.class.getSimpleName(), ex.getMessage());
            }
            throw ex;
        }
    }

    public static boolean modifiedSinceDate(File file, Date date) {
        Date lastModified = new Date(file.lastModified());
        return date.compareTo(lastModified) < 0;
    }

    public static boolean modifiedSinceDumpDate(File file) throws ParseException, IOException {
        Date lastModified;
        MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump((File)file);
        Date dumpTime = FileTools.parseTimeFromIso8601((String)mdObjectDump.getDumpTime());
        return dumpTime.compareTo(lastModified = new Date(file.lastModified())) < 0;
    }

    public static boolean modifiedSinceDumpMd5(File file, File dumpMetadataFile) throws IOException {
        DumpMetadataDTO dumpMetadata = FileTools.loadFileAsDumpMetadataFile((File)dumpMetadataFile);
        LinkedHashMap md5List = new LinkedHashMap();
        if (dumpMetadata.getMetadataContent() != null) {
            md5List.putAll(dumpMetadata.getMetadataContent());
        }
        if (dumpMetadata.getDataContent() != null) {
            md5List.putAll(dumpMetadata.getDataContent());
        }
        if (md5List.size() == 0) {
            return true;
        }
        if (!md5List.containsKey(file.getName())) {
            if (FileTools.isValidJsonFilename((File)file)) {
                return !FileTools.isValidMdObjectDump((File)file);
            }
            return true;
        }
        String currentMd5 = FileTools.calculateMD5((File)file);
        String dumpMd5 = (String)md5List.get(file.getName());
        return !dumpMd5.equals(currentMd5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String calculateMD5(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            String string = DigestUtils.md5Hex((InputStream)inputStream);
            return string;
        }
        catch (IOException ex) {
            throw new CleverAnalyticsShellException("Failed to calculate MD5 checksum of file=" + file.getAbsolutePath());
        }
    }

    public static List<File> findNewDataInDump(File dataDumpDirectory) throws IOException {
        File[] subdirectories;
        ArrayList<File> newData = new ArrayList<File>();
        if (!dataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + dataDumpDirectory.getAbsolutePath() + " not found.");
        }
        File dumpMetadataFile = Paths.get(dataDumpDirectory.getParent(), "dumpMetadata.json").toFile();
        DumpMetadataDTO dumpMetadata = FileTools.loadFileAsDumpMetadataFile((File)dumpMetadataFile);
        Map data = new LinkedHashMap();
        if (dumpMetadata.getDataContent() != null) {
            data = dumpMetadata.getDataContent();
        }
        if ((subdirectories = dataDumpDirectory.listFiles()) != null) {
            for (File dataFile : subdirectories) {
                if (!FileTools.isValidCsvFilename((File)dataFile)) continue;
                if (data.containsKey(dataFile.getName())) {
                    data.remove(dataFile.getName());
                    continue;
                }
                newData.add(dataFile);
            }
        }
        return newData;
    }

    public static List<File> findModifiedDataInDump(ShellContext context, File dataDumpDirectory) throws IOException {
        ArrayList<File> modifiedData = new ArrayList<File>();
        File dumpMetadataFile = context.getDumpMetadataFile();
        if (!dataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + dataDumpDirectory + " not found.");
        }
        if (!dumpMetadataFile.exists()) {
            throw new FileNotFoundException("File=" + dumpMetadataFile + " not found.");
        }
        File[] subdirectories = dataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File dataFile : subdirectories) {
                if (FileTools.isValidCsvFilename((File)dataFile)) {
                    if (!FileTools.modifiedSinceDumpMd5((File)dataFile, (File)dumpMetadataFile)) continue;
                    modifiedData.add(dataFile);
                    continue;
                }
                logger.error("File=" + dataFile.getName() + " has an invalid data filename. The filename must match [a-z0-9_-].csv.");
            }
        }
        return modifiedData;
    }

    public static File findMetadataInDump(ShellContext context, String objectName) throws FileNotFoundException {
        objectName = FileTools.appendExtension((String)objectName, (String)".json");
        Path metadataDumpDirectoryPath = context.getMetadataDumpPath();
        if (metadataDumpDirectoryPath != null) {
            File metadataDumpDirectory = metadataDumpDirectoryPath.toFile();
            List allMetadataFiles = FileTools.findAllMetadataInDump((File)metadataDumpDirectory);
            List mappableMetadataFiles = FileTools.filterUnmappableMetadataFiles((List)allMetadataFiles);
            List wrappedMetadataFiles = FileTools.filterUnwrappedMetadataFiles((List)mappableMetadataFiles);
            for (File searchedFile : wrappedMetadataFiles) {
                if (!searchedFile.getName().equals(objectName)) continue;
                return searchedFile;
            }
            List unmappableMetadataFiles = FileTools.filterMappableMetadataFiles((List)allMetadataFiles);
            for (File searchedFile : unmappableMetadataFiles) {
                if (!searchedFile.getName().equals(objectName)) continue;
                throw new MetadataObjectSyntaxException("Object " + objectName + " was found in dump " + context.getCurrentDump() + ", but contains syntax errors and/or constraint violations");
            }
        }
        return null;
    }

    public static File findDataInDump(ShellContext context, String csvName) {
        File[] allDataFiles;
        csvName = FileTools.appendExtension((String)csvName, (String)".csv");
        Path dataDumpDirectoryPath = context.getDataDumpPath();
        File foundFile = null;
        if (dataDumpDirectoryPath != null && (allDataFiles = dataDumpDirectoryPath.toFile().listFiles()) != null) {
            for (File searchedFile : allDataFiles) {
                if (!searchedFile.getName().equals(csvName)) continue;
                foundFile = searchedFile;
                break;
            }
        }
        return foundFile;
    }

    public static Map<File, Long> findModifiedMetadataOnServer(ShellContext context, File metadataDumpDirectory) throws IOException {
        HashMap<File, Long> modifiedOnServer = new HashMap<File, Long>();
        if (!metadataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + metadataDumpDirectory.getAbsolutePath() + " not found.");
        }
        File[] subdirectories = metadataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File metadataType : subdirectories) {
                File[] files;
                if (!metadataType.isDirectory() || (files = metadataType.listFiles()) == null) continue;
                for (File metadataObject : files) {
                    Long version;
                    if (!FileTools.isMappableToMd((File)metadataObject) || !FileTools.isValidMdObjectDump((File)metadataObject) || (version = FileTools.wasModifiedOnServer((ShellContext)context, (File)metadataObject)) == null) continue;
                    modifiedOnServer.put(metadataObject, version);
                }
            }
        }
        return modifiedOnServer;
    }

    protected static Long wasModifiedOnServer(ShellContext context, File metadataObject) throws IOException {
        ETag serverETag;
        MdObjectDumpDTO objectDump = FileTools.loadFileAsMdObjectDump((File)metadataObject);
        MdObjectDTO object = objectDump.getContent();
        object.setVersion(Long.valueOf(Long.parseLong(objectDump.getVersion())));
        ETag localETag = new ETag(object);
        try {
            MdObjectClient mdObjectClient = new MdObjectClient((CanRestClient)context.getCanRestClient());
            String etagValue = mdObjectClient.headETagValue(context.getCurrentProject(), object.getType().toStringPlural(), object.getId());
            serverETag = new ETag(etagValue);
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                return -1L;
            }
            throw ex;
        }
        if (!localETag.equals((Object)serverETag)) {
            return serverETag.getVersion();
        }
        return null;
    }

    public static List<File> findAllMetadataInDump(File metadataDumpDirectory) throws FileNotFoundException {
        ArrayList<File> metadataFiles = new ArrayList<File>();
        if (!metadataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + metadataDumpDirectory.getAbsolutePath() + " not found.");
        }
        File[] subdirectories = metadataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File metadataType : subdirectories) {
                File[] files = metadataType.listFiles();
                if (files == null) continue;
                for (File file : files) {
                    if (FileTools.isValidJsonFilename((File)file)) {
                        metadataFiles.add(file);
                        continue;
                    }
                    logger.error("File=" + file.getName() + " has an invalid metadata filename. The filename must match [a-z0-9_-].json.");
                }
            }
        }
        return metadataFiles;
    }

    public static List<File> findAllDataInDump(File dataDumpDirectory) throws IOException {
        ArrayList<File> dataFiles = new ArrayList<File>();
        if (!dataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + dataDumpDirectory.getAbsolutePath() + " not found.");
        }
        File[] files = dataDumpDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!FileTools.isValidCsvFilename((File)file)) continue;
                dataFiles.add(file);
            }
        }
        return dataFiles;
    }

    public static List<File> findModifiedMetadataInDump(ShellContext context, File metadataDumpDirectory) throws IOException {
        ArrayList<File> modifiedMetadata = new ArrayList<File>();
        File dumpMetadataFile = context.getDumpMetadataFile();
        if (!metadataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + metadataDumpDirectory + " not found.");
        }
        if (!dumpMetadataFile.exists()) {
            throw new FileNotFoundException("File=" + dumpMetadataFile + " not found.");
        }
        MetadataServiceType serviceType = null;
        AbstractShellClient shellClient = context.getShellClient();
        if (shellClient instanceof MetadataShellClient) {
            serviceType = MetadataServiceType.METADATA;
        } else if (shellClient instanceof MdShellClient) {
            serviceType = MetadataServiceType.MD;
        }
        File[] subdirectories = metadataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File metadataType : subdirectories) {
                File[] files;
                if (!metadataType.isDirectory() || !FileTools.isValidType((MetadataServiceType)serviceType, (String)metadataType.getName()) || (files = metadataType.listFiles()) == null) continue;
                for (File metadataFile : files) {
                    if (!FileTools.isMappableToMd((File)metadataFile) || !FileTools.modifiedSinceDumpMd5((File)metadataFile, (File)dumpMetadataFile) || !FileTools.isValidJsonFilename((File)metadataFile)) continue;
                    modifiedMetadata.add(metadataFile);
                }
            }
        }
        return modifiedMetadata;
    }

    public static File renameLocalObject(File oldFile, String newName) throws IOException {
        MdObjectDumpDTO localMdObjectDump = FileTools.loadFileAsMdObjectDump((File)oldFile);
        MdObjectDTO localMdObject = localMdObjectDump.getContent();
        String newObjectName = FilenameUtils.removeExtension((String)newName);
        localMdObject.setName(newObjectName);
        Map additionalProperties = localMdObject.getAdditionalProperties();
        additionalProperties.remove("links");
        localMdObject.setAdditionalProperties(additionalProperties);
        localMdObjectDump.setContent(localMdObject);
        String parentDir = FilenameUtils.getFullPath((String)oldFile.getAbsolutePath());
        File newFile = Paths.get(parentDir, newName).toFile();
        FileTools.saveObjectToJson((Object)localMdObjectDump, (String)newFile.getPath());
        return newFile;
    }

    public static List<File> filterWrappedMetadataFiles(List<File> metadataFiles) {
        return metadataFiles.stream().filter(file -> !FileTools.isValidMdObjectDump((File)file)).collect(Collectors.toList());
    }

    public static List<File> filterUnwrappedMetadataFiles(List<File> metadataFiles) {
        return metadataFiles.stream().filter(FileTools::isValidMdObjectDump).collect(Collectors.toList());
    }

    public static List<File> filterUnmappableMetadataFiles(List<File> metadataFiles) {
        return metadataFiles.stream().filter(FileTools::isMappableToMd).collect(Collectors.toList());
    }

    public static List<File> filterMappableMetadataFiles(List<File> metadataFiles) {
        return metadataFiles.stream().filter(file -> !FileTools.isMappableToMd((File)file)).collect(Collectors.toList());
    }

    public static List<File> filterFilesPresentInMd5List(ShellContext context, List<File> files) throws IOException {
        ArrayList<File> filesNotPresentInMd5List = new ArrayList<File>();
        DumpMetadataDTO dumpMetadataDTO = FileTools.loadFileAsDumpMetadataFile((File)context.getDumpMetadataFile());
        Map dumpContent = dumpMetadataDTO.getMetadataContent();
        if (dumpContent != null) {
            for (File file : files) {
                if (dumpContent.containsKey(file.getName())) continue;
                filesNotPresentInMd5List.add(file);
            }
            return filesNotPresentInMd5List;
        }
        return files;
    }

    public static HashMap<String, Integer> getMetadataObjectsDumpList(File dumpDirectory) throws FileNotFoundException {
        File metadataDumpDirectory = Paths.get(dumpDirectory.getAbsolutePath(), "metadata").toFile();
        HashMap<String, Integer> objects = new HashMap<String, Integer>();
        if (!metadataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + metadataDumpDirectory + " not found.");
        }
        File[] subdirectories = metadataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File metadataType : subdirectories) {
                File[] files = metadataType.listFiles();
                if (files == null || !metadataType.isDirectory()) continue;
                for (int i = 0; i < files.length; ++i) {
                    if (objects.containsKey(metadataType.getName())) {
                        Integer objectCount;
                        Integer n = objectCount = objects.get(metadataType.getName());
                        Integer n2 = objectCount = Integer.valueOf(objectCount + 1);
                        objects.put(metadataType.getName(), objectCount);
                        continue;
                    }
                    objects.put(metadataType.getName(), 1);
                }
            }
        }
        return objects;
    }

    public static LinkedHashMap<String, String> getMetadataObjectsMD5List(File dumpDirectory) throws FileNotFoundException {
        File metadataDumpDirectory = Paths.get(dumpDirectory.getAbsolutePath(), "metadata").toFile();
        LinkedHashMap<String, String> objects = new LinkedHashMap<String, String>();
        if (!metadataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + metadataDumpDirectory.getAbsolutePath() + " not found.");
        }
        File[] subdirectories = metadataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File metadataType : subdirectories) {
                File[] files = metadataType.listFiles();
                if (files == null || !metadataType.isDirectory()) continue;
                for (File object : files) {
                    String md5 = FileTools.calculateMD5((File)object);
                    objects.put(object.getName(), md5);
                }
            }
        }
        return objects;
    }

    public static LinkedHashMap<String, String> getDataFilesMD5List(File dumpDirectory) throws FileNotFoundException {
        File dataDumpDirectory = Paths.get(dumpDirectory.getAbsolutePath(), "data").toFile();
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        if (!dataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + dataDumpDirectory + " not found.");
        }
        File[] files = dataDumpDirectory.listFiles();
        if (files != null) {
            for (File csvFile : files) {
                String md5 = FileTools.calculateMD5((File)csvFile);
                data.put(csvFile.getName(), md5);
            }
        }
        return data;
    }

    public static HashMap<String, String> getDataDumpList(File dumpDirectory) throws FileNotFoundException {
        File dataDumpDirectory = Paths.get(dumpDirectory.getAbsolutePath(), "data").toFile();
        HashMap<String, String> csvFiles = new HashMap<String, String>();
        if (!dataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + dataDumpDirectory + " not found.");
        }
        File[] files = dataDumpDirectory.listFiles();
        if (files != null) {
            for (File csvFile : files) {
                String readableFileSize = FileUtils.byteCountToDisplaySize((long)csvFile.length());
                csvFiles.put(csvFile.getName(), readableFileSize);
            }
        }
        return csvFiles;
    }

    public static void saveObjectToJson(Object object, String path) throws IOException {
        path = FileTools.appendExtension((String)path, (String)".json");
        CanPrettyPrinter canPrettyPrinter = new CanPrettyPrinter();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));){
            ObjectWriter ow = mapper.writer().with((PrettyPrinter)canPrettyPrinter);
            writer.write(ow.writeValueAsString(object));
        }
        catch (IOException ex) {
            if (ex instanceof JsonProcessingException) {
                throw new DumpFileWriteException("Cannot write file to path=" + path);
            }
            throw ex;
        }
    }

    public static void saveStringToJson(String content, String path) throws IOException {
        path = FileTools.appendExtension((String)path, (String)".json");
        CanPrettyPrinter canPrettyPrinter = new CanPrettyPrinter();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));){
            Object json = mapper.readValue(content, Object.class);
            ObjectWriter ow = mapper.writer().with((PrettyPrinter)canPrettyPrinter);
            writer.write(ow.with((PrettyPrinter)canPrettyPrinter).writeValueAsString(json));
        }
        catch (IOException ex) {
            if (ex instanceof JsonProcessingException) {
                throw new DumpFileWriteException("Cannot write file to path=" + path);
            }
            throw ex;
        }
    }

    public static void saveStringToCsv(String content, String path, boolean append) {
        path = FileTools.appendExtension((String)path, (String)".csv");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path, append), "UTF-8"));){
            writer.write(content);
        }
        catch (IOException ex) {
            throw new DumpFileWriteException("Cannot write file to path=" + path);
        }
    }

    public static void saveInputStreamToCsv(InputStream csvInputStream, String path) throws IOException {
        path = FileTools.appendExtension((String)path, (String)".csv");
        File csvFile = new File(path);
        try (FileOutputStream outputStream = new FileOutputStream(csvFile);){
            byte[] buffer = new byte[8192];
            while (csvInputStream.read(buffer) != -1) {
                ((OutputStream)outputStream).write(buffer);
            }
        }
    }

    public static long getLineCount(File file) throws IOException {
        return Files.lines(file.toPath()).count();
    }

    protected static boolean isValidType(MetadataServiceType serviceType, String directoryName) {
        if (serviceType == MetadataServiceType.MD) {
            return MdObjectType.isValidMdType((String)directoryName);
        }
        return MetadataObjectType.isValidMetadataType((String)directoryName);
    }

    public static boolean isValidDumpDirectory(File directory) {
        return directory.isDirectory() && DUMP_ID_PATTERN.matcher(directory.getName()).matches();
    }

    public static boolean isValidCsvFilename(File file) {
        return CSV_PATTERN.matcher(file.getName()).matches();
    }

    public static boolean isValidJsonFilename(File file) {
        return JSON_PATTERN.matcher(file.getName()).matches();
    }

    public static String appendExtension(String name, String extension) {
        if (!name.endsWith(extension)) {
            name = name + extension;
        }
        return name;
    }

    public static String formatTimeToIso8601(Date date) {
        return ISO_8601_FORMAT.format(date);
    }

    public static Date parseTimeFromIso8601(String date) throws ParseException {
        return ISO_8601_FORMAT.parse(date);
    }

    public static Date parseTimeFromDumpId(String date) throws ParseException {
        return DUMP_ID_FORMAT.parse(date);
    }
}

