/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.connected;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.ProjectStatus;
import com.cleveranalytics.shell.config.BannerProvider;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class EditProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(EditProjectCommand.class);
    protected ProjectClient projectClient;
    private ShellContext context;

    @Autowired
    public EditProjectCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"editProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null;
    }

    @CliCommand(value={"editProject"}, help="Allows to edit project's properties.")
    public void editProjectCmd(@CliOption(key={"project"}, mandatory=true, help="ID of the project to edit.") String projectId, @CliOption(key={"newTitle"}, mandatory=false, help="New title of the project. Use quotes (\"sample project\") if the title contains spaces.") String newTitle, @CliOption(key={"newDescription"}, mandatory=false, help="New description of the project.") String newDescription, @CliOption(key={"newStatus"}, mandatory=false, help="New status of the project. Allowed values=[\"enabled\", \"disabled\"].") String newStatus) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (newTitle == null && newDescription == null && newStatus == null) {
                System.out.println(BannerProvider.ANSI_MAGENTA + "You should specify at least one option (--newTitle, --newDescription, --newStatus) for this command" + BannerProvider.ANSI_RESET);
                return;
            }
            this.projectClient = new ProjectClient((CanRestClient)this.context.getCanRestClient());
            ProjectStatus newProjectStatus = null;
            try {
                if (newStatus != null) {
                    newProjectStatus = ProjectStatus.valueOf((String)newStatus.toUpperCase());
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid project status=" + newStatus + ". Supported values are=" + Arrays.toString(ProjectStatus.values()).toLowerCase());
            }
            this.projectClient.updateProject(projectId, newTitle, newDescription, newProjectStatus);
            if (newTitle != null) {
                logger.error("Project title changed to \"{}\"", (Object)newTitle);
            }
            if (newDescription != null) {
                logger.error("Project description changed to \"{}\"", (Object)newDescription);
            }
            if (newStatus != null) {
                logger.error("Project status changed to \"{}\"", (Object)newStatus);
            }
            logger.error("");
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (boolean)this.context.isExitOnError());
        }
    }
}

