/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.exception;

import com.cleveranalytics.service.authn.rest.dto.HttpErrorDTO;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.JsonSyntaxException;
import com.cleveranalytics.shell.exception.ValidationViolationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShellExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(ShellExceptionHandler.class);
    private static ObjectMapper mapper = new MdObjectMapper();

    public static void handle(Exception ex, boolean exitOnError) {
        try {
            logger.warn("Handling exception={}", (Object)ex.getClass().getCanonicalName(), (Object)ex);
            logger.error("");
            if (ex instanceof HttpServerErrorException || ex instanceof HttpClientErrorException) {
                ShellExceptionHandler.handleHttpStatusCodeException((HttpStatusCodeException)((HttpStatusCodeException)((Object)ex)));
            } else if (ex instanceof JsonSyntaxException) {
                ShellExceptionHandler.handleJsonSyntaxException((JsonSyntaxException)((JsonSyntaxException)ex));
            } else if (ex instanceof ValidationViolationException) {
                ShellExceptionHandler.handleValidationViolationException((ValidationViolationException)((ValidationViolationException)ex));
            } else {
                logger.error("General error={}", (Object)ex.getMessage());
            }
        }
        catch (IOException exc) {
            logger.warn("Error parsing exception={}", (Throwable)exc);
        }
        logger.error("Execution failed. Please contact support for assistance with request_id={}\n", (Object)MDC.get((String)"requestId"));
        if (exitOnError) {
            System.exit(1);
        }
    }

    private static void handleHttpStatusCodeException(HttpStatusCodeException statusException) throws IOException {
        String responseBody = statusException.getResponseBodyAsString();
        String responseBodyMessage = "";
        try {
            responseBodyMessage = ((HttpErrorDTO)mapper.readValue(responseBody, HttpErrorDTO.class)).getMessage();
        }
        catch (JsonMappingException mappingException) {
            logger.warn("Error parsing status exception response body. Using empty body.");
        }
        if (statusException instanceof HttpServerErrorException) {
            logger.error("Server error={} - {}", (Object)statusException.getStatusCode(), (Object)statusException.getStatusCode().getReasonPhrase());
        } else {
            logger.error("Client error={} - {}", (Object)statusException.getStatusCode(), (Object)statusException.getStatusCode().getReasonPhrase());
        }
        if (responseBody.length() > 0) {
            logger.error("Error description={}", (Object)responseBodyMessage);
        }
    }

    private static void handleJsonSyntaxException(JsonSyntaxException syntaxException) {
        JsonProcessingException exception = syntaxException.getOriginalException();
        String errorFileName = syntaxException.getErrorFile().getName();
        if (syntaxException.getCausingCommand().equals("addMetadata")) {
            logger.error("Failed to add object {}\n", (Object)errorFileName);
        } else if (syntaxException.getCausingCommand().equals("pushProject")) {
            logger.error("Failed to push object {}\n", (Object)errorFileName);
        } else if (syntaxException.getCausingCommand().equals("diff")) {
            logger.error("Failed to create a diff of object {}\n", (Object)errorFileName);
        } else {
            throw new CleverMapsShellException("Unknown JsonSyntaxException causing command=" + syntaxException.getCausingCommand() + ".");
        }
        if (exception instanceof JsonParseException) {
            ShellExceptionHandler.handleJsonParseException((JsonParseException)((JsonParseException)exception));
        } else if (exception instanceof JsonMappingException) {
            if (exception.getCause() instanceof JsonParseException) {
                ShellExceptionHandler.handleJsonParseException((JsonParseException)((JsonParseException)exception.getCause()));
            } else {
                ShellExceptionHandler.handleJsonMappingException((JsonMappingException)((JsonMappingException)((Object)exception)));
            }
        } else {
            throw new CleverMapsShellException("Exception thrown is not a descendant of JsonProcessingException. Failed to create the error output.");
        }
    }

    private static void handleJsonParseException(JsonParseException exception) {
        int lineNumber = exception.getLocation().getLineNr();
        int columnNumber = exception.getLocation().getColumnNr();
        String detailMessage = exception.getMessage().split("\\r?\\n|\\r")[0];
        logger.error("General error=JSON syntax error at line: {}, column: {}", (Object)String.valueOf(lineNumber), (Object)String.valueOf(columnNumber));
        logger.error("Error description={}", (Object)ShellExceptionHandler.simplifyDetailMessage((String)detailMessage));
    }

    private static void handleJsonMappingException(JsonMappingException exception) {
        StringBuilder path = new StringBuilder("$");
        if (exception.getPath().size() == 0) {
            path.append(" (object root)");
        } else {
            path.append(".");
            for (int i = 0; i < exception.getPath().size(); ++i) {
                JsonMappingException.Reference reference = (JsonMappingException.Reference)exception.getPath().get(i);
                path.append(reference.getFieldName());
                if (i >= exception.getPath().size() - 1) continue;
                path.append(".");
            }
        }
        String detailMessage = exception.getMessage().split("\\r?\\n|\\r")[0];
        if (exception.getLocation() != null) {
            int lineNumber = exception.getLocation().getLineNr();
            int columnNumber = exception.getLocation().getColumnNr();
            logger.error("General error=JSON syntax error at line: {}, column: {}, path: {}", new Object[]{String.valueOf(lineNumber), String.valueOf(columnNumber), path});
        } else {
            logger.error("General error=JSON syntax error at path: {}", (Object)path);
        }
        logger.error("Error description={}", (Object)ShellExceptionHandler.simplifyDetailMessage((String)detailMessage));
    }

    private static String simplifyDetailMessage(String message) {
        message = message.replace("(for ARRAY starting at [Source: {", "");
        message = message.split("\\(for class")[0];
        message = message.split("\\(through")[0];
        return message;
    }

    private static void handleValidationViolationException(ValidationViolationException exception) {
        ConstraintViolation[] violationArray;
        Set violationSet = exception.violations;
        for (ConstraintViolation violation : violationArray = violationSet.toArray(new ConstraintViolation[violationSet.size()])) {
            logger.error("General error=Field '{}' of object name={} {}", new Object[]{violation.getPropertyPath(), exception.fileName, violation.getMessage()});
        }
    }
}

