/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.config;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.service.authn.client.UserCredentialsCanRestClient;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.service.metadata.client.IDatasetClient;
import com.cleveranalytics.service.metadata.client.MetadataDatasetClient;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.MetadataServiceType;
import com.cleveranalytics.service.project.rest.dto.ProjectServices;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.MetadataShellClient;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.stereotype.Component;

@Component(value="shellContext")
public class ShellContext {
    private String userEmail = null;
    private String userPassword = null;
    private String connectedServer = null;
    private String dumpDirectory = null;
    private String currentDump = null;
    private String currentProject = null;
    private String projectTitle = null;
    private boolean exitOnError = false;
    private boolean incompatibleVersion = false;
    private boolean runningInDocker = false;
    private UserCredentialsCanRestClient canRestClient = null;

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getUsername() {
        if (this.userEmail.contains("@")) {
            return this.userEmail.split("@")[0];
        }
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public String getConnectedServer() {
        return this.connectedServer;
    }

    public String getConnectedServerRelativeUrl() {
        String connectedServerRelativeUrl = this.connectedServer;
        if (connectedServerRelativeUrl.contains("https")) {
            return connectedServerRelativeUrl.replace("https://", "");
        }
        return connectedServerRelativeUrl.replace("http://", "");
    }

    public void setConnectedServer(String connectedServer) {
        this.connectedServer = connectedServer;
    }

    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public void setDumpDirectory(String dumpDirectory) {
        this.dumpDirectory = dumpDirectory;
    }

    public String getCurrentDump() {
        return this.currentDump;
    }

    public void setCurrentDump(String currentDump) {
        this.currentDump = currentDump;
    }

    public String getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(String currentProject) {
        this.currentProject = currentProject;
    }

    public String getProjectTitle() {
        return this.projectTitle;
    }

    public void setProjectTitle(String projectTitle) {
        this.projectTitle = projectTitle;
    }

    public boolean isExitOnError() {
        return this.exitOnError;
    }

    public void setExitOnError(boolean exitOnError) {
        this.exitOnError = exitOnError;
    }

    public boolean isIncompatibleVersion() {
        return this.incompatibleVersion;
    }

    public void setIncompatibleVersion(boolean incompatibleVersion) {
        this.incompatibleVersion = incompatibleVersion;
    }

    public boolean isRunningInDocker() {
        return this.runningInDocker;
    }

    public void setRunningInDocker(boolean runningInDocker) {
        this.runningInDocker = runningInDocker;
    }

    public AbstractShellClient getShellClient() {
        ProjectClient projectClient = new ProjectClient((CanRestClient)this.canRestClient);
        ProjectServices services = projectClient.getProject(this.currentProject).getServices();
        if (services.containsKey((Object)MetadataServiceType.MD.toString())) {
            return new MdShellClient((CanRestClient)this.canRestClient);
        }
        return new MetadataShellClient((CanRestClient)this.canRestClient);
    }

    public IDatasetClient getDatasetClient() {
        ProjectClient projectClient = new ProjectClient((CanRestClient)this.canRestClient);
        ProjectServices services = projectClient.getProject(this.currentProject).getServices();
        if (services.containsKey((Object)MetadataServiceType.MD.toString())) {
            return new MdDatasetClient((CanRestClient)this.canRestClient);
        }
        return new MetadataDatasetClient((CanRestClient)this.canRestClient);
    }

    public UserCredentialsCanRestClient getCanRestClient() {
        return this.canRestClient;
    }

    public void setCanRestClient(UserCredentialsCanRestClient canRestClient) {
        this.canRestClient = canRestClient;
    }

    public Path getProjectPath() {
        if (this.getDumpDirectory() == null || this.getCurrentProject() == null) {
            return null;
        }
        return Paths.get(this.getDumpDirectory(), this.getCurrentProject());
    }

    public Path getDumpPath() {
        if (this.getDumpDirectory() == null || this.getCurrentProject() == null || this.getCurrentDump() == null) {
            return null;
        }
        return Paths.get(this.getDumpDirectory(), this.getCurrentProject(), this.getCurrentDump());
    }

    public Path getDataDumpPath() {
        if (this.getDumpDirectory() == null || this.getCurrentProject() == null || this.getCurrentDump() == null) {
            return null;
        }
        return Paths.get(this.getDumpDirectory(), this.getCurrentProject(), this.getCurrentDump(), "data");
    }

    public Path getMetadataDumpPath() {
        if (this.getDumpDirectory() == null || this.getCurrentProject() == null || this.getCurrentDump() == null) {
            return null;
        }
        return Paths.get(this.getDumpDirectory(), this.getCurrentProject(), this.getCurrentDump(), "metadata");
    }

    public File getDumpMetadataFile() {
        if (this.getDumpDirectory() == null || this.getCurrentProject() == null || this.getCurrentDump() == null) {
            return null;
        }
        Path dumpMetadataFilePath = Paths.get(this.getDumpDirectory(), this.getCurrentProject(), this.getCurrentDump(), "dumpMetadata.json");
        return dumpMetadataFilePath.toFile();
    }

    public void clear() {
        this.userEmail = null;
        this.userPassword = null;
        this.connectedServer = null;
        this.dumpDirectory = null;
        this.currentDump = null;
        this.currentProject = null;
        this.projectTitle = null;
        this.canRestClient = null;
    }
}

