/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client.jdbc;

import com.cleveranalytics.shell.exception.JdbcShellClientException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.springframework.jdbc.core.ResultSetExtractor;

public class StreamingCsvResultSetExtractor
implements ResultSetExtractor<Void> {
    private final OutputStream outputStream;
    private final String newline = System.lineSeparator();

    public StreamingCsvResultSetExtractor(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public Void extractData(ResultSet resultSet) throws SQLException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.outputStream), Charset.forName("UTF-8"));){
            CSVFormat csvFormat = CSVFormat.RFC4180.withHeader(resultSet).withRecordSeparator(this.newline);
            CSVPrinter printer = new CSVPrinter((Appendable)writer, csvFormat);
            printer.printRecords(resultSet);
        }
        catch (IOException ex) {
            throw new JdbcShellClientException("Failed to stream result set to CSV file.");
        }
        return null;
    }
}

