/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.login;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.authn.client.AuthnClient;
import com.cleveranalytics.service.authn.client.UserCredentialsCanRestClient;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.sentry.Sentry;
import io.sentry.event.UserBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class LoginCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(LoginCommand.class);
    @Value(value="${service.name}")
    private final String serviceName;
    @Value(value="${can.service.authn.serverUrl:#{null}}")
    private final String authnServerUrl;
    private String authnServer;
    private ClientHttpRequestFactory requestFactory;
    protected UserCredentialsCanRestClient canRestClient;
    private ShellContext context;
    private String credentialsEmail;
    private String credentialsPassword;
    private String configServer;
    private String configDumpDirectory;
    private String envVariableEmail = System.getenv("email");
    private String envVariablePassword = System.getenv("password");
    private static final String DEFAULT_SERVER = "https://secure.clevermaps.io";
    private static final String CONFIG_TIP = "Tip: you can save your shell configuration in a file named \"config.txt\" in \".cleverMaps\"\nfolder located in your OS's home folder. The \"config\" file must have following syntax:\n\ndumpDirectory=/var/local/metadata\nserver=https://secure.clevermaps.io\n";
    private static final String CREDENTIALS_TIP = "Tip: you can save your user credentials in a file named \"credentials.txt\" in \".cleverMaps\"\nfolder located in your OS's home folder. The \"credentials\" file must have following syntax:\n\nemail=address@domain.com\npassword=MY_SECRET_PASSWORD\n";

    @Autowired
    public LoginCommand(ShellContext context, @Qualifier(value="nonCachingHttpClientRequestFactory") ClientHttpRequestFactory requestFactory) {
        this.serviceName = null;
        this.authnServerUrl = null;
        this.context = context;
        this.requestFactory = requestFactory;
    }

    @CliCommand(value={"login"}, help="Log in using correct CleverMaps credentials.")
    public void loginCmd(@CliOption(key={"email"}, mandatory=false, help="Email of a CleverMaps user.") String email, @CliOption(key={"password"}, mandatory=false, help="Valid password to the user account.") String password, @CliOption(key={"server"}, mandatory=false, help="Target hostname where to connect.") String server, @CliOption(key={"dumpDirectory"}, mandatory=false, help="Directory to store project dumps.") String dumpDirectory) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (this.context.isIncompatibleVersion()) {
                throw new CleverMapsShellException("It's forbidden to login if a change with 'FATAL' level has been introduced. Please download the latest version.");
            }
            Path canPath = Paths.get(System.getProperty("user.home"), ".cleverAnalytics");
            if (!canPath.toFile().exists()) {
                canPath = Paths.get(System.getProperty("user.home"), ".cleverMaps");
            }
            Path credentialsPath = Paths.get(canPath.toString(), "credentials");
            File credentialsFile = this.fetchPlainOrTxt(credentialsPath);
            Path configPath = Paths.get(canPath.toString(), "config");
            File configFile = this.fetchPlainOrTxt(configPath);
            if (credentialsFile != null && credentialsFile.exists()) {
                this.loadProperties(credentialsFile);
            }
            if (configFile != null && configFile.exists()) {
                this.loadProperties(configFile);
            }
            this.context.clear();
            boolean set = this.setContextProperties(email, password, server, dumpDirectory);
            if (!set) {
                return;
            }
            Sentry.getContext().setUser(new UserBuilder().setUsername(this.context.getUserEmail()).build());
            if (this.authnServerUrl != null) {
                this.authnServer = this.authnServerUrl;
                System.out.println("\nObtaining refresh token from " + this.authnServerUrl);
            } else {
                this.authnServer = this.context.getConnectedServer();
            }
            this.canRestClient = new UserCredentialsCanRestClient(new AuthnClient(this.serviceName, this.authnServer, this.requestFactory), this.serviceName, this.context.getConnectedServer(), this.context.getUserEmail(), this.context.getUserPassword(), this.requestFactory);
            System.out.println("\nSuccessfully logged in as " + this.context.getUserEmail() + "\n");
            ArrayList<Object> converters = new ArrayList<Object>();
            converters.add(new StringHttpMessageConverter(Charset.forName("UTF-8")));
            converters.add(new MappingJackson2HttpMessageConverter(new ObjectMapper()));
            converters.add(new FormHttpMessageConverter());
            this.canRestClient.setMessageConverters(converters);
            this.context.setCanRestClient(this.canRestClient);
            this.context.setCurrentProject(null);
            this.context.setCurrentDump(null);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
            this.context.clear();
        }
    }

    private boolean setContextProperties(String email, String password, String server, String dumpDirectory) {
        boolean emailSet = true;
        boolean passwordSet = true;
        if (email != null) {
            this.context.setUserEmail(email);
        } else if (this.envVariableEmail != null) {
            this.context.setUserEmail(this.envVariableEmail);
        } else if (this.credentialsEmail != null) {
            this.context.setUserEmail(this.credentialsEmail);
        } else {
            emailSet = false;
        }
        if (password != null) {
            this.context.setUserPassword(password);
        } else if (this.envVariablePassword != null) {
            this.context.setUserPassword(this.envVariablePassword);
        } else if (this.credentialsPassword != null) {
            this.context.setUserPassword(this.credentialsPassword);
        } else {
            passwordSet = false;
        }
        if (!emailSet || !passwordSet) {
            System.out.println("\nPlease specify both options (--email, --password) for this command\n");
            System.out.println(CREDENTIALS_TIP);
            return false;
        }
        boolean showConfigTip = false;
        if (server != null) {
            this.context.setConnectedServer(server);
        } else if (this.configServer != null) {
            System.out.println("\t* setting " + this.configServer + " as default server");
            this.context.setConnectedServer(this.configServer);
        } else {
            System.out.println("\t* setting https://secure.clevermaps.io as default server");
            this.context.setConnectedServer(DEFAULT_SERVER);
            showConfigTip = true;
        }
        if (dumpDirectory != null) {
            this.context.setDumpDirectory(dumpDirectory);
        } else if (this.configDumpDirectory != null) {
            System.out.println("\t* setting " + this.configDumpDirectory + " as default dump directory");
            this.context.setDumpDirectory(this.configDumpDirectory);
        } else {
            System.out.println("\t* setting " + System.getProperty("user.dir") + " as default dump directory");
            this.context.setDumpDirectory(System.getProperty("user.dir"));
            showConfigTip = true;
        }
        if (showConfigTip) {
            System.out.println("\nTip: you can save your shell configuration in a file named \"config.txt\" in \".cleverMaps\"\nfolder located in your OS's home folder. The \"config\" file must have following syntax:\n\ndumpDirectory=/var/local/metadata\nserver=https://secure.clevermaps.io\n");
        }
        return true;
    }

    private File fetchPlainOrTxt(Path path) {
        Path txtPath = Paths.get(FileTools.appendExtension((String)path.toString(), (String)".txt"), new String[0]);
        String fileType = path.getFileName().toString().contains("config") ? "config" : "credentials";
        if (path.toFile().exists()) {
            System.out.println("Found " + fileType + " file: " + path.toString());
            return path.toFile();
        }
        if (txtPath.toFile().exists()) {
            System.out.println("Found " + fileType + " file: " + txtPath.toString());
            return txtPath.toFile();
        }
        return null;
    }

    private void loadProperties(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file.getAbsolutePath());){
            Properties properties = new Properties();
            String content = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            properties.load(new StringReader(content.replace("\\", "\\\\")));
            if (properties.getProperty("email") != null) {
                this.credentialsEmail = properties.getProperty("email");
            }
            if (properties.getProperty("password") != null) {
                this.credentialsPassword = properties.getProperty("password");
            }
            if (properties.getProperty("server") != null) {
                this.configServer = properties.getProperty("server");
            }
            if (properties.getProperty("dumpDirectory") != null) {
                this.configDumpDirectory = properties.getProperty("dumpDirectory");
            }
        }
    }

    private void setReadWriteForOwnerOnly(Path path) throws IOException {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("mac")) {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(path, permissions);
        } else if (osName.contains("win")) {
            File file = new File(path.toString());
            file.setExecutable(false, true);
            file.setReadable(false, true);
            file.setWritable(false, true);
        }
    }
}

