/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.service.metadata.rest.dto.FileList;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasetDTO;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasets;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DumpMetadataDTO;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.DumpFileWriteException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractShellClient {
    public abstract FileList getObjectsList(ShellContext var1) throws IOException;

    public abstract void dumpObjectsLocal(ShellContext var1) throws IOException;

    public void createMetadataDumpFile(ShellContext context) throws Exception {
        ProjectClient projectClient = new ProjectClient((CanRestClient)context.getCanRestClient());
        String projectTitle = projectClient.getProject(context.getCurrentProject()).getTitle();
        String dumpTime = FileTools.parseTimeFromDumpId((String)context.getCurrentDump()).toString();
        DumpMetadataDTO dumpMetadataDTO = new DumpMetadataDTO();
        dumpMetadataDTO.setDumpId(context.getCurrentDump());
        dumpMetadataDTO.setServer(context.getConnectedServer());
        dumpMetadataDTO.setProjectId(context.getCurrentProject());
        dumpMetadataDTO.setProjectTitle(projectTitle);
        dumpMetadataDTO.setDumpTime(dumpTime);
        dumpMetadataDTO.setUser(context.getUserEmail());
        File metadataDumpFile = context.getDumpMetadataFile();
        FileTools.saveObjectToJson((Object)dumpMetadataDTO, (String)metadataDumpFile.getAbsolutePath());
        if (!metadataDumpFile.exists()) {
            throw new DumpFileWriteException("Failed to to create dumpMetadata.json file=" + metadataDumpFile.getAbsolutePath());
        }
    }

    public void putMetadataChecksumListElement(ShellContext context, File mdObjectFile) throws IOException {
        File dumpMetadataFile = context.getDumpMetadataFile();
        if (dumpMetadataFile != null) {
            DumpMetadataDTO dumpMetadataDTO = FileTools.loadFileAsDumpMetadataFile((File)dumpMetadataFile);
            LinkedHashMap<String, String> content = dumpMetadataDTO.getMetadataContent() == null ? new LinkedHashMap<String, String>() : dumpMetadataDTO.getMetadataContent();
            content.put(mdObjectFile.getName(), FileTools.calculateMD5((File)mdObjectFile));
            dumpMetadataDTO.setMetadataContent(content);
            FileTools.saveObjectToJson((Object)dumpMetadataDTO, (String)dumpMetadataFile.getAbsolutePath());
        }
    }

    public void removeMetadataChecksumListElement(ShellContext context, File mdObjectFile) throws IOException {
        File dumpMetadataFile = context.getDumpMetadataFile();
        if (dumpMetadataFile != null) {
            DumpMetadataDTO dumpMetadataDTO = FileTools.loadFileAsDumpMetadataFile((File)dumpMetadataFile);
            Map content = dumpMetadataDTO.getMetadataContent();
            if (dumpMetadataDTO.getMetadataContent() != null) {
                content.remove(mdObjectFile.getName());
                dumpMetadataDTO.setMetadataContent(content);
                FileTools.saveObjectToJson((Object)dumpMetadataDTO, (String)dumpMetadataFile.getAbsolutePath());
            }
        }
    }

    public void putDataChecksumListElement(ShellContext context, File csvFile) throws IOException {
        File dumpMetadataFile = context.getDumpMetadataFile();
        if (dumpMetadataFile != null) {
            DumpMetadataDTO dumpMetadataDTO = FileTools.loadFileAsDumpMetadataFile((File)dumpMetadataFile);
            LinkedHashMap<String, String> content = dumpMetadataDTO.getDataContent() == null ? new LinkedHashMap<String, String>() : dumpMetadataDTO.getDataContent();
            content.put(csvFile.getName(), FileTools.calculateMD5((File)csvFile));
            dumpMetadataDTO.setDataContent(content);
            FileTools.saveObjectToJson((Object)dumpMetadataDTO, (String)dumpMetadataFile.getAbsolutePath());
        }
    }

    public File createMetadataSubfolder(File metadataDumpDirectory, String objectType) {
        File directory = Paths.get(metadataDumpDirectory.getAbsolutePath(), objectType).toFile();
        if (directory.mkdirs() || directory.isDirectory()) {
            return directory;
        }
        return null;
    }

    public abstract void addObject(String var1, File var2, boolean var3) throws IOException;

    public abstract void pushObject(String var1, File var2) throws IOException;

    public abstract void removeObject(String var1, String var2, String var3) throws IOException;

    public abstract IDatasets<IDatasetDTO> loadDatasetsFromPath(File var1) throws IOException;

    public abstract void saveDatasetsToPath(IDatasets<IDatasetDTO> var1, File var2) throws IOException;

    public abstract File getCurrentDatasetsPath(ShellContext var1);

    public void mdObjectNameCheck(String name) {
        Pattern namePattern = Pattern.compile("^[a-z][a-z0-9_-]*$");
        Matcher matcher = namePattern.matcher(name);
        if (!matcher.matches()) {
            throw new CleverMapsShellException("Object name=" + name + " does not match the regular expression=" + namePattern.pattern());
        }
    }
}

