/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.dwh.rest.dto.DwhValidateResponse;
import com.cleveranalytics.service.dwh.rest.dto.DwhValidateViolation;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class ValidateCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(ValidateCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public ValidateCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"validate"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"validate"}, help="Validate project's DWH data integrity.")
    public void validateCmd(@CliOption(key={"project"}, mandatory=false, help="ProjectId of CleverMaps project which will be validated.") String projectId, @CliOption(key={"skipModel"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip DWH model validation.") boolean skipModel, @CliOption(key={"skipData"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip DWH data validation.") boolean skipData) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            String project = projectId;
            if (project == null) {
                project = this.context.getCurrentProject();
            }
            logger.error("Validating DWH model/data integrity of project {}...\n", (Object)project);
            DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)this.context.getCanRestClient());
            if (!skipModel) {
                this.printModelViolations(project, dwhShellClient);
            }
            if (!skipData) {
                this.printDataViolations(project, dwhShellClient);
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected void printModelViolations(String projectId, DwhShellClient dwhShellClient) throws IOException {
        DwhValidateResponse validateResponse = dwhShellClient.validateProjectIntegrity(this.context.getCanRestClient(), this.context.getCurrentProject(), false, true);
        List modelViolations = validateResponse.getViolations();
        if (modelViolations.size() > 0) {
            logger.error("There are following DWH model violations in project {}:", (Object)projectId);
            for (DwhValidateViolation violation : modelViolations) {
                logger.error(violation.getMessage());
            }
            logger.error("");
        } else {
            logger.error("There are no DWH model violations in project {}\n", (Object)projectId);
        }
    }

    protected void printDataViolations(String projectId, DwhShellClient dwhShellClient) throws IOException {
        DwhValidateResponse validateResponse = dwhShellClient.validateProjectIntegrity(this.context.getCanRestClient(), this.context.getCurrentProject(), true, false);
        List dataViolations = validateResponse.getViolations();
        if (dataViolations.size() > 0) {
            logger.error("There are following DWH data violations in project {}:", (Object)projectId);
            for (DwhValidateViolation violation : dataViolations) {
                logger.error(violation.getMessage());
            }
            logger.error("");
        } else {
            logger.error("There are no DWH data violations in project {}\n", (Object)projectId);
        }
    }
}

