/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.service.metadata.client.MetadataClient;
import com.cleveranalytics.service.metadata.rest.dto.MetadataFileList;
import com.cleveranalytics.service.metadata.rest.dto.MetadataObjectType;
import com.cleveranalytics.service.metadata.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.metadata.rest.dto.dataset.Datasets;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasetDTO;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasets;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DumpMetadataDTO;
import com.cleveranalytics.shell.exception.DumpFileWriteException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;

public class MetadataShellClient
extends AbstractShellClient {
    static final Logger logger = LoggerFactory.getLogger(MetadataShellClient.class);
    private static final String DATASETS_NAME = "datasets.json";
    private static final String MAP_OPTIONS_NAME = "mapOptions.json";
    private static final String NO_FILE = "[no files]";
    private MetadataClient metadataClient;

    public MetadataShellClient(CanRestClient canRestClient) {
        this.metadataClient = new MetadataClient(canRestClient);
    }

    public MetadataFileList getObjectsList(ShellContext context) {
        ResponseEntity fcNameList = this.metadataClient.getFeatureCollectionsList(context.getCurrentProject());
        ResponseEntity uicNameList = this.metadataClient.getUicomponentsList(context.getCurrentProject());
        ResponseEntity detailNameList = this.metadataClient.getDetailsList(context.getCurrentProject());
        String datasetResponse = (String)this.metadataClient.getDatasets(context.getCurrentProject()).getBody();
        String mapOptionsResponse = (String)this.metadataClient.getMapOptions(context.getCurrentProject()).getBody();
        ArrayList<String> fcNames = ((MetadataFileList)fcNameList.getBody()).getFeatureCollections();
        ArrayList<String> uiNames = ((MetadataFileList)uicNameList.getBody()).getUicomponents();
        ArrayList<String> detailNames = ((MetadataFileList)detailNameList.getBody()).getDetails();
        ArrayList<String> emptyResponse = new ArrayList<String>(Collections.singletonList(NO_FILE));
        return new MetadataFileList().withFeatureCollections(fcNames != null ? fcNames : emptyResponse).withUicomponents(uiNames != null ? uiNames : emptyResponse).withDetails(detailNames != null ? detailNames : emptyResponse).withDatasets(datasetResponse != null ? Collections.singletonList(DATASETS_NAME) : emptyResponse).withMapOptions(mapOptionsResponse != null ? Collections.singletonList(MAP_OPTIONS_NAME) : emptyResponse);
    }

    public void dumpObjectsLocal(ShellContext context) throws IOException {
        String projectId = context.getCurrentProject();
        File metadataDumpDirectory = context.getMetadataDumpPath().toFile();
        File datasets = this.createMetadataSubfolder(metadataDumpDirectory, "datasets");
        this.dumpDatasets(projectId, datasets.toString());
        File featureCollections = this.createMetadataSubfolder(metadataDumpDirectory, "featureCollections");
        this.dumpFeatureCollections(projectId, featureCollections.toString());
        File mapOptions = this.createMetadataSubfolder(metadataDumpDirectory, "mapOptions");
        this.dumpMapOptions(projectId, mapOptions.toString());
        File uiComponents = this.createMetadataSubfolder(metadataDumpDirectory, "uicomponents");
        this.dumpUiComponents(projectId, uiComponents.toString());
        File details = this.createMetadataSubfolder(metadataDumpDirectory, "details");
        this.dumpDetails(projectId, details.toString());
        this.createDumpMetadataFile(context);
    }

    public void createDumpMetadataFile(ShellContext context) throws IOException {
        File dumpMetadataFile = context.getDumpMetadataFile();
        DumpMetadataDTO dumpMetadata = FileTools.loadFileAsDumpMetadataFile((File)dumpMetadataFile);
        LinkedHashMap metadataContent = new LinkedHashMap();
        metadataContent.putAll(FileTools.getMetadataObjectsMD5List((File)context.getDumpPath().toFile()));
        dumpMetadata.setMetadataContent(metadataContent);
        FileTools.saveObjectToJson((Object)dumpMetadata, (String)dumpMetadataFile.getAbsolutePath());
    }

    public void dumpDatasets(String projectId, String directory) throws IOException {
        Assert.hasText((String)projectId);
        Assert.hasText((String)directory);
        String datasetResponse = (String)this.metadataClient.getDatasets(projectId).getBody();
        FileTools.saveStringToJson((String)datasetResponse, (String)Paths.get(directory, DATASETS_NAME).toString());
    }

    public void dumpFeatureCollections(String projectId, String directory) throws IOException {
        Assert.hasText((String)projectId);
        Assert.hasText((String)directory);
        ResponseEntity fcNameList = this.metadataClient.getFeatureCollectionsList(projectId);
        if (((MetadataFileList)fcNameList.getBody()).getFeatureCollections() == null) {
            FileTools.saveStringToJson((String)"[]", (String)Paths.get(directory, "index.json").toString());
        } else {
            for (String fcName : ((MetadataFileList)fcNameList.getBody()).getFeatureCollections()) {
                ResponseEntity featureCollection = this.metadataClient.getFeatureCollection(projectId, fcName);
                FileTools.saveStringToJson((String)((String)featureCollection.getBody()), (String)Paths.get(directory, fcName).toString());
            }
        }
    }

    public void dumpMapOptions(String projectId, String directory) throws IOException {
        Assert.hasText((String)projectId);
        Assert.hasText((String)directory);
        String mapOptions = (String)this.metadataClient.getMapOptions(projectId).getBody();
        FileTools.saveStringToJson((String)mapOptions, (String)(directory + File.separator + MAP_OPTIONS_NAME));
        logger.info("action=save_map_option_dump location=" + directory + "mapOptions.json status=success");
    }

    public void dumpUiComponents(String projectId, String directory) throws IOException {
        Assert.hasText((String)projectId);
        Assert.hasText((String)directory);
        ResponseEntity uicNameList = this.metadataClient.getUicomponentsList(projectId);
        if (((MetadataFileList)uicNameList.getBody()).getUicomponents() == null) {
            FileTools.saveStringToJson((String)"[]", (String)Paths.get(directory, "views.json").toString());
        } else {
            for (String uicName : ((MetadataFileList)uicNameList.getBody()).getUicomponents()) {
                if (uicName.equals("details")) continue;
                ResponseEntity uiComponent = this.metadataClient.getUicomponent(projectId, uicName);
                FileTools.saveStringToJson((String)((String)uiComponent.getBody()), (String)(directory + File.separator + uicName));
            }
        }
    }

    public void dumpDetails(String projectId, String directory) throws IOException {
        Assert.hasText((String)projectId);
        Assert.hasText((String)directory);
        ResponseEntity detailNameList = this.metadataClient.getDetailsList(projectId);
        if (((MetadataFileList)detailNameList.getBody()).getDetails() == null) {
            FileTools.saveStringToJson((String)"[]", (String)Paths.get(directory, "detail.json").toString());
        } else {
            for (String detailName : ((MetadataFileList)detailNameList.getBody()).getDetails()) {
                ResponseEntity detail = this.metadataClient.getDetail(projectId, detailName);
                FileTools.saveStringToJson((String)((String)detail.getBody()), (String)(directory + File.separator + detailName));
            }
        }
    }

    public void addObject(String projectId, File file, boolean silent) throws IOException {
        logger.info("action=add_metadata_object file=" + file.getName() + " status=begin");
        String objectType = MetadataObjectType.contains((String)file.getPath());
        String name = FilenameUtils.removeExtension((String)file.getName());
        String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
        this.metadataClient.addObject(objectType, name, content, projectId);
        logger.info("action=add_metadata_object location=" + file.getPath() + " status=success");
    }

    public void pushObject(String projectId, File file) throws IOException {
        logger.info("action=update_metadata_object file=" + file.getName() + " status=begin");
        String objectType = MetadataObjectType.contains((String)file.getPath());
        String name = FilenameUtils.removeExtension((String)file.getName());
        String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
        this.metadataClient.pushObject(objectType, name, content, projectId);
        logger.info("action=update_metadata_object location=" + file.getPath() + " status=success");
    }

    public void removeObject(String projectId, String objectType, String filename) {
        logger.info("action=remove_metadata_object file=" + filename + " status=begin");
        String objectName = FilenameUtils.removeExtension((String)filename);
        this.metadataClient.removeObject(objectType, objectName, projectId);
        logger.info("action=remove_metadata_object file=" + filename + " status=success");
    }

    public IDatasets<IDatasetDTO> loadDatasetsFromPath(File path) throws IOException {
        Datasets allDatasets = (Datasets)FileTools.loadFileAsClass((File)path, Datasets.class);
        IDatasets datasets = new IDatasets();
        datasets.addAll((Collection)allDatasets);
        return datasets;
    }

    public void saveDatasetsToPath(IDatasets<IDatasetDTO> datasets, File path) throws IOException {
        if (!path.exists() && !path.mkdirs()) {
            throw new DumpFileWriteException("Failed to create directory=" + path.getAbsolutePath());
        }
        Datasets existingDatasets = (Datasets)FileTools.loadFileAsClass((File)path, Datasets.class);
        for (IDatasetDTO dataset : datasets) {
            existingDatasets.add((Object)((DatasetDTO)dataset));
        }
        FileTools.saveObjectToJson((Object)existingDatasets, (String)path.getAbsolutePath());
    }

    public File getCurrentDatasetsPath(ShellContext context) {
        return Paths.get(context.getMetadataDumpPath().toString(), "datasets", DATASETS_NAME).toFile();
    }
}

