/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.dwh.rest.dto.CsvOptions;
import com.cleveranalytics.service.dwh.rest.dto.DataPullMode;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class LoadCsvCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(LoadCsvCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public LoadCsvCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"loadCsv"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"loadCsv"}, help="Load CSV file into existing CleverMaps dataset.")
    public void loadCsvCmd(@CliOption(key={"dataset"}, mandatory=true, help="Name of the dataset where the data will be loaded.") String datasetName, @CliOption(key={"file"}, mandatory=true, help="Path to a CSV file to be loaded. If a dump is opened and contains some CSV files, file can be specified by using just the filename ('restaurants.csv') instead of full path") String file, @CliOption(key={"mode"}, mandatory=true, help="Data load mode. Allowed values=[\"full\", \"incremental\"].") String mode, @CliOption(key={"csvHeader"}, mandatory=false, help="Specifies if the CSV file has a header.") Boolean csvHeader, @CliOption(key={"csvSeparator"}, mandatory=false, help="Specifies the CSV column separator character.") Character csvSeparator, @CliOption(key={"csvQuote"}, mandatory=false, help="Specifies the CSV quote character.") Character csvQuote, @CliOption(key={"csvEscape"}, mandatory=false, help="Specifies the CSV escape character.") Character csvEscape, @CliOption(key={"csvNull"}, mandatory=false, help="Specifies the replacement of custom CSV null values.") String csvNull, @CliOption(key={"csvForceNull"}, mandatory=false, help="Specifies which CSV columns should enforce the null replacement.") String[] csvForceNull, @CliOption(key={"verbose"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Verbose option for more detailed output.") boolean verbose) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            logger.error("Asynchronous data upload started...\n");
            CsvOptions csvOptions = this.parseCsvOptions(csvHeader, csvSeparator, csvQuote, csvEscape, csvNull, csvForceNull);
            this.loadData(file, datasetName, this.convertDataPullRequestMode(mode), csvOptions, verbose);
            logger.error("");
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    private CsvOptions parseCsvOptions(Boolean csvHeader, Character csvSeparator, Character csvQuote, Character csvEscape, String csvNull, String[] csvForceNull) {
        CsvOptions csvOptions = new CsvOptions();
        csvOptions.setHeader(csvHeader);
        csvOptions.setSeparator(csvSeparator);
        csvOptions.setQuote(csvQuote);
        csvOptions.setEscape(csvEscape);
        csvOptions.setNull(csvNull);
        if (csvForceNull == null) {
            csvOptions.setForceNull(null);
        } else {
            csvOptions.setForceNull(Arrays.asList(csvForceNull));
        }
        return csvOptions;
    }

    public void loadData(String csvName, String datasetName, DataPullMode mode, CsvOptions csvOptions, boolean verbose) throws IOException {
        File datasetFile;
        File csvFile = null;
        if (this.context.getCurrentDump() == null) {
            csvFile = FileTools.getCsvFileFromPath((String)csvName);
        }
        if ((datasetFile = FileTools.findMetadataInDump((ShellContext)this.context, (String)datasetName)) == null || !datasetFile.exists() || !datasetFile.canRead()) {
            logger.error("Cannot find DWH dataset name=" + datasetName + " corresponding to CSV file=" + csvName + " in dump=" + this.context.getCurrentDump() + ", skipping the upload");
        } else {
            csvFile = FileTools.findDataInDump((ShellContext)this.context, (String)csvName);
            if (csvFile == null || !csvFile.exists() || !csvFile.canRead()) {
                csvFile = FileTools.getCsvFileFromPath((String)csvName);
            }
        }
        if (csvFile == null) {
            throw new CleverMapsShellException("Cannot find CSV file=" + csvName + " in dump or the filesystem.");
        }
        if (csvFile.length() > 3500000000L) {
            logger.error("WARNING: File size of file {} exceeds 3,5GB. In case the upload fails, we recommend you to split the CSV file into multiple smaller files and upload them sequentially using the '--mode incremental' parameter. Upload of bigger files will be supported in the future.\n", (Object)csvFile.getName());
        }
        DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)this.context.getCanRestClient());
        dwhShellClient.performLoad(this.context, csvFile, datasetName, mode, csvOptions, verbose);
    }

    private void fetchUpdatedDataset(String datasetName) {
        AbstractShellClient shellClient = this.context.getShellClient();
        try {
            if (shellClient instanceof MdShellClient) {
                MdDatasetClient datasetClient = (MdDatasetClient)this.context.getDatasetClient();
                DatasetDTO fetchDataset = datasetClient.getDatasetByName(this.context.getCurrentProject(), datasetName);
                ((MdShellClient)shellClient).wrapAndSaveMdObject(this.context, (MdObjectDTO)fetchDataset);
            }
        }
        catch (IOException ex) {
            logger.error("Failed to fetch a new version of dataset name={}.", (Object)datasetName);
        }
    }

    protected DataPullMode convertDataPullRequestMode(String mode) throws IllegalArgumentException {
        try {
            return DataPullMode.fromValue((String)mode);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid 'mode' parameter=" + mode + ". Supported values are=" + Arrays.toString(DataPullMode.values()) + ".");
        }
    }
}

