/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.login;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.authn.client.AuthnClient;
import com.cleveranalytics.service.authn.client.UserCredentialsCanRestClient;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.config.ShellConfig;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class LoginCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(LoginCommand.class);
    @Value(value="${service.name}")
    private final String serviceName;
    @Value(value="${can.service.authn.serverUrl:#{null}}")
    private final String authnServerUrl;
    private String authnServer;
    private ShellContext context;
    private String envVariableEmail = System.getenv("email");
    private String envVariablePassword = System.getenv("password");
    private static final String DEFAULT_SERVER = "https://secure.clevermaps.io";
    private static final String CONFIG_TIP = "Tip: you can save your shell configuration in a file named \"config.txt\" in \".cleverMaps\"\nfolder located in your OS's home folder. The \"config\" file must have following syntax:\n\ndumpDirectory=/var/local/metadata\nserver=https://secure.clevermaps.io\n";
    private static final String CREDENTIALS_TIP = "Tip: you can save your user credentials in a file named \"credentials.txt\" in \".cleverMaps\"\nfolder located in your OS's home folder. The \"credentials\" file must have following syntax:\n\nemail=address@domain.com\npassword=MY_SECRET_PASSWORD\n";

    @Autowired
    public LoginCommand(ShellContext context) {
        this.serviceName = null;
        this.authnServerUrl = null;
        this.context = context;
    }

    @CliCommand(value={"login"}, help="Log in to CleverMaps.")
    public void loginCmd(@CliOption(key={"email"}, mandatory=false, help="Your email account.") String email, @CliOption(key={"password"}, mandatory=false, help="Your password.") String password, @CliOption(key={"server"}, mandatory=false, help="Server to connect to.") String server, @CliOption(key={"proxyHost"}, mandatory=false, help="Hostname of the proxy server.") String proxyHost, @CliOption(key={"proxyPort"}, mandatory=false, help="Proxy server port number.") Integer proxyPort, @CliOption(key={"dumpDirectory"}, mandatory=false, help="Directory to store project dumps.") String dumpDirectory) {
        try {
            File configFile;
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (this.context.isIncompatibleVersion()) {
                throw new CleverMapsShellException("It's forbidden to login if a change with 'FATAL' level has been introduced. Please download the latest version.");
            }
            ShellConfig config = new ShellConfig();
            File credentialsFile = FileTools.fetchCredentialsFile();
            if (credentialsFile != null) {
                System.out.println("Found credentials file: " + credentialsFile.getAbsolutePath());
                FileTools.loadProperties((ShellConfig)config, (File)credentialsFile);
            }
            if ((configFile = FileTools.fetchConfigFile()) != null) {
                System.out.println("Found config file: " + configFile.getAbsolutePath());
                FileTools.loadProperties((ShellConfig)config, (File)configFile);
            }
            this.context.clear();
            boolean set = this.setContextProperties(config, email, password, server, proxyHost, proxyPort, dumpDirectory);
            if (!set) {
                return;
            }
            if (this.authnServerUrl != null) {
                this.authnServer = this.authnServerUrl;
                System.out.println("\nObtaining refresh token from " + this.authnServerUrl);
            } else {
                this.authnServer = this.context.getConnectedServer();
            }
            UserCredentialsCanRestClient canRestClient = this.initClient(this.context, (ClientHttpRequestFactory)this.initRequestFactory(this.context));
            System.out.println("\nSuccessfully logged in as " + this.context.getUserEmail() + "\n");
            this.context.setCanRestClient(canRestClient);
            this.context.setCurrentProject(null);
            this.context.setCurrentDump(null);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
            this.context.clear();
        }
    }

    private boolean setContextProperties(ShellConfig config, String email, String password, String server, String proxyHost, Integer proxyPort, String dumpDirectory) {
        boolean emailSet = true;
        boolean passwordSet = true;
        if (email != null) {
            this.context.setUserEmail(email);
        } else if (this.envVariableEmail != null) {
            this.context.setUserEmail(this.envVariableEmail);
        } else if (config.getEmail() != null) {
            this.context.setUserEmail(config.getEmail());
        } else {
            emailSet = false;
        }
        if (password != null) {
            this.context.setUserPassword(password);
        } else if (this.envVariablePassword != null) {
            this.context.setUserPassword(this.envVariablePassword);
        } else if (config.getPassword() != null) {
            this.context.setUserPassword(config.getPassword());
        } else {
            passwordSet = false;
        }
        if (!emailSet || !passwordSet) {
            System.out.println("\nPlease specify both options (--email, --password) for this command\n");
            System.out.println(CREDENTIALS_TIP);
            return false;
        }
        boolean showConfigTip = false;
        if (server != null) {
            this.context.setConnectedServer(server);
        } else if (config.getServer() != null) {
            System.out.println("\t* setting " + config.getServer() + " as default server");
            this.context.setConnectedServer(config.getServer());
        } else {
            System.out.println("\t* setting https://secure.clevermaps.io as default server");
            this.context.setConnectedServer(DEFAULT_SERVER);
            showConfigTip = true;
        }
        if (dumpDirectory != null) {
            this.context.setDumpDirectory(dumpDirectory);
        } else if (config.getDumpDirectory() != null) {
            System.out.println("\t* setting " + config.getDumpDirectory() + " as default dump directory");
            this.context.setDumpDirectory(config.getDumpDirectory());
        } else {
            System.out.println("\t* setting " + System.getProperty("user.dir") + " as default dump directory");
            this.context.setDumpDirectory(System.getProperty("user.dir"));
            showConfigTip = true;
        }
        if (proxyHost != null) {
            this.context.setProxyHost(proxyHost);
        } else if (config.getProxyHost() != null) {
            System.out.println("\t* setting " + config.getProxyHost() + " as default proxy server hostname");
            this.context.setProxyHost(config.getProxyHost());
        }
        if (proxyPort != null) {
            this.context.setProxyPort(proxyPort);
        } else if (config.getProxyPort() != null) {
            System.out.println("\t* setting " + config.getProxyPort() + " as default proxy server port number");
            this.context.setProxyPort(config.getProxyPort());
        }
        if (showConfigTip) {
            System.out.println("\nTip: you can save your shell configuration in a file named \"config.txt\" in \".cleverMaps\"\nfolder located in your OS's home folder. The \"config\" file must have following syntax:\n\ndumpDirectory=/var/local/metadata\nserver=https://secure.clevermaps.io\n");
        }
        return true;
    }

    private UserCredentialsCanRestClient initClient(ShellContext context, ClientHttpRequestFactory requestFactory) {
        UserCredentialsCanRestClient canRestClient = new UserCredentialsCanRestClient(new AuthnClient(this.serviceName, this.authnServer, requestFactory), this.serviceName, context.getConnectedServer(), context.getUserEmail(), context.getUserPassword(), requestFactory);
        List<HttpMessageConverter> converters = Arrays.asList(new StringHttpMessageConverter(Charset.forName("UTF-8")), new MappingJackson2HttpMessageConverter(new ObjectMapper()), new FormHttpMessageConverter());
        canRestClient.setMessageConverters(converters);
        return canRestClient;
    }

    public SimpleClientHttpRequestFactory initRequestFactory(ShellContext context) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setBufferRequestBody(false);
        requestFactory.setOutputStreaming(false);
        requestFactory.setConnectTimeout(30000);
        requestFactory.setReadTimeout(30000);
        if (context.getProxyHost() != null) {
            if (context.getProxyPort() != null) {
                InetSocketAddress address = new InetSocketAddress(context.getProxyHost(), (int)context.getProxyPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                requestFactory.setProxy(proxy);
            } else {
                throw new CleverMapsShellException("No proxy port number specified. Check config file or provide the --proxyPort parameter");
            }
        }
        return requestFactory;
    }
}

