/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.connected;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.MembershipDTO;
import com.cleveranalytics.service.project.rest.dto.ProjectDTO;
import com.cleveranalytics.service.project.rest.dto.ProjectShare;
import com.cleveranalytics.shell.commands.connected.ListProjectsCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.inamik.text.tables.GridTable;
import com.inamik.text.tables.SimpleTable;
import com.inamik.text.tables.grid.Border;
import com.inamik.text.tables.grid.Util;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class ListProjectsCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(ListProjectsCommand.class);
    @Value(value="${service.name}")
    private final String serviceName;
    @Value(value="${can.service.project.serverUrl:#{null}}")
    private final String projectServerUrl;
    @Value(value="${can.service.authn.serverUrl:#{null}}")
    private final String authnServerUrl;
    protected ProjectClient projectClient;
    private ShellContext context;
    private String authnServer;
    private String projectServer;

    @Autowired
    public ListProjectsCommand(ShellContext context) {
        this.serviceName = null;
        this.projectServerUrl = null;
        this.authnServerUrl = null;
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"listProjects"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null;
    }

    @CliCommand(value={"listProjects"}, help="List all projects available to a current user.")
    public void listProjectsCmd(@CliOption(key={"verbose"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Verbose option for more detailed output.") boolean verbose, @CliOption(key={"share"}, mandatory=false, help="Project share attribute. Allowed values=[\"demo\", \"dimension\", \"template\"].") String share) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (this.authnServerUrl != null) {
                this.authnServer = this.authnServerUrl;
                System.out.println("\nObtaining refresh token from " + this.authnServerUrl);
            } else {
                this.authnServer = this.context.getConnectedServer();
            }
            if (this.projectServerUrl != null) {
                this.projectServer = this.projectServerUrl;
                System.out.println("Obtaining projects from " + this.projectServerUrl + "\n");
            } else {
                this.projectServer = this.context.getConnectedServer();
            }
            if (share != null) {
                try {
                    ProjectShare.fromValue((String)share);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("Invalid 'share' parameter=" + share + ". Supported values are: [\"demo\", \"dimension\", \"template\"]");
                }
            }
            this.projectClient = new ProjectClient(this.context.getCanRestClient());
            this.listProjects(this.projectClient, Boolean.valueOf(verbose), share);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    public String listProjects(ProjectClient projectClient, Boolean verbose, String share) throws IOException {
        GridTable gridTable = null;
        String stringTable = null;
        List projects = share == null ? projectClient.getProjects() : projectClient.getProjectsByShare(ProjectShare.fromValue((String)share));
        if (projects.size() == 0) {
            System.out.println("There are no" + (share != null ? " " + share : "") + " projects available to " + this.context.getUserEmail() + "\n");
        } else {
            System.out.println("Listing available" + (share != null ? " " + share : "") + " projects for " + this.context.getUserEmail() + "...\n");
            projects.sort(new ProjectTitleComparator(this));
            gridTable = verbose != false ? this.formatVerboseProjectsGridTable(projectClient, projects) : this.formatProjectsGridTable(projectClient, projects);
            stringTable = Util.asString((GridTable)gridTable);
            System.out.println(stringTable);
        }
        return gridTable == null ? "" : stringTable;
    }

    public GridTable formatProjectsGridTable(ProjectClient projectClient, List<ProjectDTO> projects) throws IOException {
        SimpleTable projectsTable = SimpleTable.of().nextRow().nextCell().addLine(this.whitespaceWrap("Project ID")).nextCell().addLine(this.whitespaceWrap("Project title")).nextCell().addLine(this.whitespaceWrap("Role")).nextCell().addLine(this.whitespaceWrap("Share"));
        for (ProjectDTO project : projects) {
            MembershipDTO membership = projectClient.getMembershipInProject(project.getId());
            projectsTable.nextRow().nextCell().addLine(this.whitespaceWrap(project.getId())).nextCell().addLine(this.whitespaceWrap(project.getTitle())).nextCell().addLine(this.whitespaceWrap(membership.getRole().toString().toLowerCase())).nextCell().addLine(this.whitespaceWrap(project.getShare().toString()).toLowerCase());
        }
        GridTable gridTable = projectsTable.toGrid();
        gridTable = Border.of((Border.Chars)Border.Chars.SINGLE_LINE).apply(gridTable);
        return gridTable;
    }

    public GridTable formatVerboseProjectsGridTable(ProjectClient projectClient, List<ProjectDTO> projects) throws IOException {
        SimpleTable projectsTable = SimpleTable.of().nextRow().nextCell().addLine(this.whitespaceWrap("Project ID")).nextCell().addLine(this.whitespaceWrap("Project title")).nextCell().addLine(this.whitespaceWrap("Role")).nextCell().addLine(this.whitespaceWrap("Description")).nextCell().addLine(this.whitespaceWrap("Status")).nextCell().addLine(this.whitespaceWrap("Created at")).nextCell().addLine(this.whitespaceWrap("Modified at")).nextCell().addLine(this.whitespaceWrap("Share"));
        for (ProjectDTO project : projects) {
            MembershipDTO membership = projectClient.getMembershipInProject(project.getId());
            String description = this.processDescription(project);
            projectsTable.nextRow().nextCell().addLine(this.whitespaceWrap(project.getId())).nextCell().addLine(this.whitespaceWrap(project.getTitle())).nextCell().addLine(this.whitespaceWrap(membership.getRole().toString().toLowerCase())).nextCell().addLine(this.whitespaceWrap(description)).nextCell().addLine(this.whitespaceWrap(project.getStatus().toString().toLowerCase())).nextCell().addLine(this.whitespaceWrap(new ISO8601DateFormat().format(project.getCreatedAt()))).nextCell().addLine(this.whitespaceWrap(new ISO8601DateFormat().format(project.getModifiedAt()))).nextCell().addLine(this.whitespaceWrap(project.getShare().toString().toLowerCase()));
        }
        GridTable gridTable = projectsTable.toGrid();
        gridTable = Border.of((Border.Chars)Border.Chars.SINGLE_LINE).apply(gridTable);
        return gridTable;
    }

    private String whitespaceWrap(String text) {
        return " " + text + " ";
    }

    private String processDescription(ProjectDTO project) {
        String desc = project.getDescription() == null ? "" : project.getDescription();
        int lengthLimit = 64;
        if (desc.length() > lengthLimit) {
            desc = desc.substring(0, lengthLimit);
            desc = desc + "...";
        }
        return desc;
    }
}

