/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.config;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.stereotype.Component;

@Component(value="shellContext")
public class ShellContext {
    private String userEmail = null;
    private String userPassword = null;
    private String connectedServer = null;
    private String proxyHost = null;
    private Integer proxyPort = null;
    private String dumpDirectory = null;
    private String currentDump = null;
    private String currentProject = null;
    private String projectTitle = null;
    private boolean exitOnError = false;
    private boolean rethrowExceptions = false;
    private boolean incompatibleVersion = false;
    private boolean runningInDocker = false;
    private CanRestClient canRestClient = null;
    private String bearerToken = null;

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getUsername() {
        if (this.userEmail.contains("@")) {
            return this.userEmail.split("@")[0];
        }
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public String getConnectedServer() {
        return this.connectedServer;
    }

    public String getConnectedServerRelativeUrl() {
        String connectedServerRelativeUrl = this.connectedServer;
        if (connectedServerRelativeUrl.contains("https")) {
            return connectedServerRelativeUrl.replace("https://", "");
        }
        return connectedServerRelativeUrl.replace("http://", "");
    }

    public void setConnectedServer(String connectedServer) {
        this.connectedServer = connectedServer;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public void setDumpDirectory(String dumpDirectory) {
        this.dumpDirectory = dumpDirectory;
    }

    public String getCurrentDump() {
        return this.currentDump;
    }

    public void setCurrentDump(String currentDump) {
        this.currentDump = currentDump;
    }

    public String getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(String currentProject) {
        this.currentProject = currentProject;
    }

    public String getProjectTitle() {
        return this.projectTitle;
    }

    public void setProjectTitle(String projectTitle) {
        this.projectTitle = projectTitle;
    }

    public boolean isExitOnError() {
        return this.exitOnError;
    }

    public void setExitOnError(boolean exitOnError) {
        this.exitOnError = exitOnError;
    }

    public boolean isRethrowExceptions() {
        return this.rethrowExceptions;
    }

    public void setRethrowExceptions(boolean rethrowExceptions) {
        this.rethrowExceptions = rethrowExceptions;
    }

    public boolean isIncompatibleVersion() {
        return this.incompatibleVersion;
    }

    public void setIncompatibleVersion(boolean incompatibleVersion) {
        this.incompatibleVersion = incompatibleVersion;
    }

    public boolean isRunningInDocker() {
        return this.runningInDocker;
    }

    public void setRunningInDocker(boolean runningInDocker) {
        this.runningInDocker = runningInDocker;
    }

    public AbstractShellClient getShellClient() {
        return new MdShellClient(this.canRestClient);
    }

    public MdDatasetClient getDatasetClient() {
        return new MdDatasetClient(this.canRestClient);
    }

    public CanRestClient getCanRestClient() {
        return this.canRestClient;
    }

    public void setCanRestClient(CanRestClient canRestClient) {
        this.canRestClient = canRestClient;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public Path getProjectPath() {
        if (this.getDumpDirectory() == null || this.getCurrentProject() == null) {
            return null;
        }
        return Paths.get(this.getDumpDirectory(), this.getCurrentProject());
    }

    public Path getDumpPath() {
        if (this.getDumpDirectory() == null || this.getCurrentProject() == null || this.getCurrentDump() == null) {
            return null;
        }
        return Paths.get(this.getDumpDirectory(), this.getCurrentProject(), this.getCurrentDump());
    }

    public Path getDataDumpPath() {
        if (this.getDumpDirectory() == null || this.getCurrentProject() == null || this.getCurrentDump() == null) {
            return null;
        }
        return Paths.get(this.getDumpDirectory(), this.getCurrentProject(), this.getCurrentDump(), "data");
    }

    public Path getMetadataDumpPath() {
        if (this.getDumpDirectory() == null || this.getCurrentProject() == null || this.getCurrentDump() == null) {
            return null;
        }
        return Paths.get(this.getDumpDirectory(), this.getCurrentProject(), this.getCurrentDump(), "metadata");
    }

    public File getDumpMetadataFile() {
        if (this.getDumpDirectory() == null || this.getCurrentProject() == null || this.getCurrentDump() == null) {
            return null;
        }
        Path dumpMetadataFilePath = Paths.get(this.getDumpDirectory(), this.getCurrentProject(), this.getCurrentDump(), "dumpMetadata.json");
        return dumpMetadataFilePath.toFile();
    }

    public void clear() {
        this.userEmail = null;
        this.userPassword = null;
        this.connectedServer = null;
        this.proxyHost = null;
        this.proxyPort = null;
        this.dumpDirectory = null;
        this.currentDump = null;
        this.currentProject = null;
        this.projectTitle = null;
        this.canRestClient = null;
    }
}

