/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.rest.dto.MdFileList;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.md.rest.dto.MdObjectTypeEnum;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.ProjectDTO;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.LinkPlaceholderReplacer;
import com.cleveranalytics.shell.client.LinkReplacer;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DiffDTO;
import com.cleveranalytics.shell.dto.DiffListDTO;
import com.cleveranalytics.shell.exception.JsonSyntaxException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.JsonDiff;
import com.flipkart.zjsonpatch.JsonPatch;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;

public class DiffProjectClient {
    static final Logger logger = LoggerFactory.getLogger(DiffProjectClient.class);
    private final ObjectMapper mapper = new MdObjectMapper();
    private ShellContext context;

    public DiffProjectClient(ShellContext context) {
        this.context = context;
    }

    public DiffListDTO createDiff(String sourceProject, String destinationProject) throws IOException {
        ProjectClient projectClient = new ProjectClient(this.context.getCanRestClient());
        ProjectDTO sourceProjectDTO = this.getProjectById(projectClient, sourceProject);
        ProjectDTO destinationProjectDTO = this.getProjectById(projectClient, destinationProject);
        System.out.println("Generating diff between projects \"" + sourceProjectDTO.getTitle() + "\" and \"" + destinationProjectDTO.getTitle() + "\"...\n");
        MdShellClient mdShellClient = (MdShellClient)this.context.getShellClient();
        this.context.setCurrentProject(sourceProject);
        MdFileList sourceFileList = mdShellClient.getObjectsList(this.context);
        this.context.setCurrentProject(destinationProject);
        MdFileList destinationFileList = mdShellClient.getObjectsList(this.context);
        MdFileList addedObjects = sourceFileList.getAddedObjects(destinationFileList);
        List addDiffs = this.generateDiffs(sourceProject, destinationProject, addedObjects, DiffDTO.Operation.ADD);
        System.out.println("Added objects: " + addDiffs.size());
        MdFileList commonObjects = sourceFileList.getCommonObjects(destinationFileList);
        List modifyDiffs = this.generateDiffs(sourceProject, destinationProject, commonObjects, DiffDTO.Operation.MODIFY);
        System.out.println("Modified objects: " + modifyDiffs.size());
        MdFileList deletedObjects = sourceFileList.getDeletedObjects(destinationFileList);
        List deleteDiffs = this.generateDiffs(sourceProject, destinationProject, deletedObjects, DiffDTO.Operation.DELETE);
        System.out.println("Deleted objects: " + deleteDiffs.size());
        return new DiffListDTO().withAdded(addDiffs).withModified(modifyDiffs).withDeleted(deleteDiffs);
    }

    private List<DiffDTO> generateDiffs(String sourceProject, String destinationProject, MdFileList fileList, DiffDTO.Operation operation) throws IOException {
        MdShellClient shellClient = (MdShellClient)this.context.getShellClient();
        ArrayList<DiffDTO> diffs = new ArrayList<DiffDTO>();
        for (String objectType : MdObjectType.getList()) {
            List objectTypeList = fileList.getObjectsList(objectType);
            for (String objectName : objectTypeList) {
                MdObjectDTO destinationObject;
                MdObjectDTO sourceObject;
                if (operation != DiffDTO.Operation.DELETE) {
                    sourceObject = this.fetchRemoteObjectByName(sourceProject, objectType, objectName);
                    sourceObject = shellClient.replaceURILinks(sourceObject, (LinkReplacer)new LinkPlaceholderReplacer(sourceProject));
                } else {
                    sourceObject = new MdObjectDTO();
                }
                if (operation != DiffDTO.Operation.ADD) {
                    destinationObject = this.fetchRemoteObjectByName(destinationProject, objectType, objectName);
                    destinationObject = shellClient.replaceURILinks(destinationObject, (LinkReplacer)new LinkPlaceholderReplacer(destinationProject));
                } else {
                    destinationObject = new MdObjectDTO();
                }
                this.removeGeneratedFields(sourceObject);
                JsonNode sourceNode = this.createJsonNode(sourceObject);
                this.removeGeneratedFields(destinationObject);
                JsonNode destinationNode = this.createJsonNode(destinationObject);
                JsonNode diffNode = JsonDiff.asJson((JsonNode)destinationNode, (JsonNode)sourceNode);
                if (diffNode.size() <= 0) continue;
                diffs.add(new DiffDTO().withObjectName(objectName).withObjectType(objectType).withOperation(operation).withDiff(diffNode));
            }
        }
        return diffs;
    }

    private JsonNode createJsonNode(MdObjectDTO mdObject) {
        try {
            return (JsonNode)this.mapper.readValue(this.mapper.writeValueAsString((Object)mdObject), JsonNode.class);
        }
        catch (JsonProcessingException ex) {
            throw new JsonSyntaxException(mdObject.getName(), (Object)"diff", ex);
        }
    }

    private void removeGeneratedFields(MdObjectDTO mdObject) {
        mdObject.setId(null);
        mdObject.setAccessInfo(null);
        Map additionalProperties = mdObject.getAdditionalProperties();
        additionalProperties.remove("links");
        mdObject.setAdditionalProperties(additionalProperties);
    }

    private MdObjectDTO fetchRemoteObjectByName(String projectId, String objectType, String name) {
        MdObjectDTO remoteObject;
        MdObjectClient mdObjectClient = new MdObjectClient(this.context.getCanRestClient());
        try {
            if (objectType.equals(MdObjectTypeEnum.SHARE.toStringPlural())) {
                String[] nameFragments = name.split("_");
                String shareId = nameFragments[nameFragments.length - 1];
                String objectName = name.replaceAll("_" + shareId, "");
                MdObjectDTO sharedObject = mdObjectClient.getMdObjectByName(projectId, objectName);
                remoteObject = mdObjectClient.getMdObjectByName(projectId, objectType, name, sharedObject.getId());
            } else {
                remoteObject = mdObjectClient.getMdObjectByName(projectId, objectType, name);
                this.removeGeneratedFields(remoteObject);
            }
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw ex;
        }
        return remoteObject;
    }

    private ProjectDTO getProjectById(ProjectClient projectClient, String projectId) {
        try {
            return projectClient.getProject(projectId);
        }
        catch (HttpClientErrorException ex) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND, "Project id=" + projectId + " not found on server=" + this.context.getConnectedServer());
        }
    }

    public String applyDiff(DiffListDTO diffs) throws Exception {
        Path path;
        StringBuilder removeMetadataOutput = new StringBuilder();
        for (DiffDTO diff : diffs.getAdded()) {
            path = this.createObjectPath(diff.getObjectName(), diff.getObjectType());
            JsonNode emptyMdObjectNode = this.createJsonNode(new MdObjectDTO());
            JsonNode appliedMdObjectNode = JsonPatch.apply((JsonNode)diff.getDiff(), (JsonNode)emptyMdObjectNode);
            FileTools.saveObjectToJson((Object)appliedMdObjectNode, (String)path.toString());
        }
        for (DiffDTO diff : diffs.getModified()) {
            path = this.createObjectPath(diff.getObjectName(), diff.getObjectType());
            if (!path.toFile().exists()) {
                throw new IOException("Cannot find object=" + path.toFile().getName() + " in dump=" + this.context.getCurrentDump() + " to apply the diff on. Please make a dump first using 'dumpProject --skipData'.");
            }
            MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump((File)path.toFile());
            JsonNode mdObjectNode = this.createJsonNode(mdObjectDump.getContent());
            JsonNode appliedMdObjectNode = JsonPatch.apply((JsonNode)diff.getDiff(), (JsonNode)mdObjectNode);
            MdObjectDTO appliedObject = (MdObjectDTO)this.mapper.readValue(appliedMdObjectNode.toString(), MdObjectDTO.class);
            mdObjectDump.setContent(appliedObject);
            FileTools.saveObjectToJson((Object)mdObjectDump, (String)path.toString());
        }
        for (DiffDTO diff : diffs.getDeleted()) {
            removeMetadataOutput.append("removeMetadata --objectName ");
            removeMetadataOutput.append(diff.getObjectName());
            removeMetadataOutput.append("\n");
        }
        return removeMetadataOutput.toString();
    }

    private Path createObjectPath(String objectName, String objectType) {
        String fileName = FileTools.appendExtension((String)objectName, (String)".json");
        return Paths.get(this.context.getMetadataDumpPath().toString(), objectType, fileName);
    }
}

