/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.DiffProjectClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DiffListDTO;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class ApplyDiffCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(ApplyDiffCommand.class);
    private final ShellContext context;
    private final DiffProjectClient diffProjectClient;

    @Autowired
    public ApplyDiffCommand(ShellContext context) {
        this.context = context;
        this.diffProjectClient = new DiffProjectClient(context);
    }

    @CliAvailabilityIndicator(value={"applyDiff"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"applyDiff"}, help="Create and apply metadata diff between two live projects.")
    public void diffCmd(@CliOption(key={"sourceProject"}, mandatory=true, help="ID of the source project to create the diff from.") String sourceProject, @CliOption(key={"objectTypes"}, mandatory=false, help="Compare only specified object types. Accepts values separated by comma.") String[] objects) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            String destinationProject = this.context.getCurrentProject();
            if (sourceProject != null || destinationProject != null) {
                this.checkModifiedFilesInDump();
                List<String> objectTypes = objects == null ? MdObjectType.getList() : Arrays.asList(objects);
                DiffListDTO diffs = this.diffProjectClient.createDiff(sourceProject, destinationProject, objectTypes);
                String output = this.diffProjectClient.applyDiff(diffs);
                System.out.println("\nDiff successfully applied to dump " + this.context.getCurrentDump() + "\n");
                if (diffs.getAdded().size() > 0) {
                    System.out.println("Run addMetadata to add new objects");
                }
                if (diffs.getModified().size() > 0) {
                    System.out.println("Run pushProject to push the changes in modified objects");
                }
                if (diffs.getDeleted().size() > 0) {
                    System.out.println("Run these " + diffs.getDeleted().size() + " commands to remove the deleted objects:\n");
                    System.out.println(output);
                } else {
                    System.out.println("");
                }
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    private void checkModifiedFilesInDump() throws IOException {
        File metadataDumpPath = this.context.getMetadataDumpPath().toFile();
        List locallyModifiedMetadata = FileTools.findModifiedMetadataInDump((ShellContext)this.context, (File)metadataDumpPath);
        if (locallyModifiedMetadata.size() > 0) {
            throw new CleverMapsShellException("Currently opened dump=" + this.context.getCurrentDump() + " contains " + locallyModifiedMetadata.size() + " locally modified files. Applying a diff will most likely fail. Please sync this dump with the project on the server (using pushProject).");
        }
    }
}

