/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.connected;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.shell.client.JobShellClient;
import com.cleveranalytics.shell.commands.connected.CreateProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class CloneProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(CreateProjectCommand.class);
    private final ShellContext context;
    private final CreateProjectCommand createProjectCommand;

    @Autowired
    public CloneProjectCommand(ShellContext context) {
        this.context = context;
        this.createProjectCommand = new CreateProjectCommand(context);
    }

    @CliAvailabilityIndicator(value={"cloneProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null;
    }

    @CliCommand(value={"cloneProject"}, help="Clones project from source and opens it.")
    public void cloneProjectCmd(@CliOption(key={"project"}, mandatory=true, help="Project ID of the project from which new project will be cloned.") String sourceProject, @CliOption(key={"organization"}, mandatory=true, help="ID of the organization which will become the owner of the project.") String organization, @CliOption(key={"title"}, mandatory=false, unspecifiedDefaultValue="", help="Title of the cloned project. Use quotes (\"sample project\") if the title contains spaces. If this param is not used, names the cloned project: Clone of [projectName]") String title, @CliOption(key={"description"}, mandatory=false, unspecifiedDefaultValue="", help="Description of the project. Use quotes (\"sample description\") if the description contains spaces. A description can be formatted by markdown syntax. Description will be empty if this param is not used.") String description) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (title.isEmpty()) {
                title = "Clone of " + this.getSourceTitle(sourceProject);
            }
            this.createProjectCommand.createProjectCmd(title, description, organization);
            JobShellClient jobShellClient = new JobShellClient();
            jobShellClient.cloneProject(this.context, sourceProject);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    private String getSourceTitle(String sourceProject) {
        ProjectClient projectClient = new ProjectClient(this.context.getCanRestClient());
        return projectClient.getProject(sourceProject).getTitle();
    }
}

