/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.shell.client.DiffClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.IOException;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class DiffCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(DiffCommand.class);
    private final ShellContext context;
    private final DiffClient diffClient;

    @Autowired
    public DiffCommand(ShellContext context) {
        this.context = context;
        this.diffClient = new DiffClient(context);
    }

    @CliAvailabilityIndicator(value={"diff"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"diff"}, help="Compare local metadata objects with those in project line by line. If the --objectName parameter is not specified, all wrapped modifed objects are compared.")
    public void diffCmd(@CliOption(key={"objectName"}, mandatory=false, help="Name of a single object to compare (with or without .json extension)") String objectName) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            AnsiConsole.systemInstall();
            System.out.println(this.diffClient.formatDiff(objectName));
            AnsiConsole.systemUninstall();
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    public String formatDiff(String inputName) throws IOException {
        return this.diffClient.formatDiff(inputName);
    }
}

