/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.exception.MdException;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.util.CanPrettyPrinter;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.DiffClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.JsonSyntaxException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.shell.support.util.OsUtils;

public class DiffClient {
    static final Logger logger = LoggerFactory.getLogger(DiffClient.class);
    private ShellContext context;
    private final ObjectMapper mapper = new MdObjectMapper();
    private CanPrettyPrinter canPrettyPrinter = new CanPrettyPrinter();
    private ObjectWriter objectWriter = this.mapper.writer().with((PrettyPrinter)this.canPrettyPrinter);
    public static final Ansi ANSI_RED = Ansi.ansi().fg(Ansi.Color.RED);
    public static final Ansi ANSI_GREEN = Ansi.ansi().fg(Ansi.Color.GREEN);
    public static final Ansi ANSI_CYAN = Ansi.ansi().fg(Ansi.Color.CYAN);
    public static final Ansi ANSI_RESET = Ansi.ansi().reset();
    public static final int WRAPPER_LINES = 4;

    public DiffClient(ShellContext context) {
        this.context = context;
    }

    public String formatDiff(String inputName) throws IOException {
        File metadataDumpDirectory = this.context.getMetadataDumpPath().toFile();
        List allMetadataFiles = FileTools.findAllMetadataInDump((File)metadataDumpDirectory);
        List unmappableMetadataFiles = FileTools.filterMappableMetadataFiles((List)allMetadataFiles);
        List mappableMetadataFiles = FileTools.filterUnmappableMetadataFiles((List)allMetadataFiles);
        List unwrappedMetadataFiles = FileTools.filterWrappedMetadataFiles((List)mappableMetadataFiles);
        List newMetadataFiles = FileTools.filterFilesPresentInMd5List((ShellContext)this.context, (List)unwrappedMetadataFiles);
        List localModifiedMetadata = FileTools.findModifiedMetadataInDump((ShellContext)this.context, (File)metadataDumpDirectory);
        List localModifiedWrappedMetadata = FileTools.filterUnwrappedMetadataFiles((List)localModifiedMetadata);
        Map modifiedOnServer = FileTools.findModifiedMetadataOnServer((ShellContext)this.context, (File)metadataDumpDirectory);
        ArrayList remoteModifiedMetadata = new ArrayList(modifiedOnServer.keySet());
        StringBuilder completeDiff = new StringBuilder();
        String objectName = inputName;
        File foundFile = null;
        if (objectName == null) {
            MdObjectDTO mdObject;
            if (localModifiedWrappedMetadata.isEmpty() && newMetadataFiles.isEmpty() && remoteModifiedMetadata.isEmpty() && unmappableMetadataFiles.isEmpty()) {
                return "Local dump " + this.context.getCurrentDump() + " and project " + this.context.getCurrentProject() + " are identical\n";
            }
            localModifiedWrappedMetadata.sort(new FileNameComparator(null));
            newMetadataFiles.sort(new FileNameComparator(null));
            remoteModifiedMetadata.sort(new FileNameComparator(null));
            for (File localModifiedFile : localModifiedWrappedMetadata) {
                if (remoteModifiedMetadata.contains(localModifiedFile)) continue;
                mdObject = FileTools.loadFileAsMdObjectDump((File)localModifiedFile).getContent();
                completeDiff.append(this.formatFileDiff(localModifiedFile, mdObject.getName(), false, false));
            }
            for (File newFile : newMetadataFiles) {
                mdObject = (MdObjectDTO)FileTools.loadFileAsClass((File)newFile, MdObjectDTO.class);
                completeDiff.append(this.formatFileDiff(newFile, mdObject.getName(), true, false));
            }
            for (File remoteModifiedFile : remoteModifiedMetadata) {
                mdObject = FileTools.loadFileAsMdObjectDump((File)remoteModifiedFile).getContent();
                completeDiff.append(this.formatFileDiff(remoteModifiedFile, mdObject.getName(), false, true));
            }
            for (File unmappableMetadataFile : unmappableMetadataFiles) {
                this.diffSyntaxErrorFile(unmappableMetadataFile);
            }
        } else {
            objectName = FileTools.appendExtension((String)objectName, (String)".json");
            for (File searchedFile : allMetadataFiles) {
                if (!searchedFile.getName().equals(objectName)) continue;
                foundFile = searchedFile;
            }
            if (foundFile == null) {
                logger.error("Object {} not found in dump {}\n", (Object)FilenameUtils.removeExtension((String)objectName), (Object)this.context.getCurrentDump());
                return null;
            }
            if (unmappableMetadataFiles.contains(foundFile)) {
                this.diffSyntaxErrorFile(foundFile);
            } else if (newMetadataFiles.contains(foundFile)) {
                completeDiff.append(this.formatFileDiff(foundFile, objectName, true, false));
            } else if (remoteModifiedMetadata.contains(foundFile)) {
                completeDiff.append(this.formatFileDiff(foundFile, objectName, false, true));
            } else {
                completeDiff.append(this.formatFileDiff(foundFile, objectName, false, false));
            }
        }
        return completeDiff.toString();
    }

    private String formatFileDiff(File localFile, String objectName, boolean isNewObject, boolean wasModifiedOnServer) throws IOException {
        MdObjectDTO remoteObject;
        MdObjectDTO localObject = isNewObject ? this.fetchLocalUnwrappedObject(localFile) : this.fetchLocalWrappedObject(localFile);
        String localObjectType = localObject.getType().toStringPlural();
        ArrayList localObjectLines = this.processStringInput(this.objectWriter.writeValueAsString((Object)localObject));
        ArrayList remoteObjectLines = isNewObject ? new ArrayList() : ((remoteObject = this.fetchRemoteObjectByName(localObjectType, localObject.getName())) == null ? new ArrayList() : this.processStringInput(this.objectWriter.writeValueAsString((Object)remoteObject)));
        StringBuilder objectDiff = new StringBuilder();
        Patch patch = DiffUtils.diff((List)localObjectLines, remoteObjectLines);
        List deltas = patch.getDeltas();
        if (deltas.isEmpty()) {
            return "Local object " + objectName + " and its project version are identical\n";
        }
        objectDiff.append(OsUtils.LINE_SEPARATOR);
        objectDiff.append(this.formatFileHeader(localFile));
        for (Delta delta : deltas) {
            objectDiff.append(this.formatDeltaOutput(delta, (List)localObjectLines, isNewObject, wasModifiedOnServer));
        }
        return objectDiff.toString();
    }

    private MdObjectDTO fetchLocalWrappedObject(File file) throws IOException {
        MdObjectDTO localMdObject = FileTools.loadFileAsMdObjectDump((File)file).getContent();
        this.removeAdditionalProperties(localMdObject);
        return localMdObject;
    }

    private MdObjectDTO fetchLocalUnwrappedObject(File file) throws IOException {
        MdObjectDTO localMdObject = (MdObjectDTO)FileTools.loadFileAsClass((File)file, MdObjectDTO.class);
        this.removeAdditionalProperties(localMdObject);
        return localMdObject;
    }

    private MdObjectDTO fetchRemoteObjectByName(String type, String name) {
        MdObjectClient mdObjectClient = new MdObjectClient(this.context.getCanRestClient());
        try {
            MdObjectDTO remoteObject = mdObjectClient.getMdObjectByName(this.context.getCurrentProject(), type, name);
            this.removeAdditionalProperties(remoteObject);
            return remoteObject;
        }
        catch (MdException ex) {
            if (HttpStatus.NOT_FOUND.equals((Object)ex.getStatus())) {
                return null;
            }
            throw ex;
        }
    }

    private String formatDeltaOutput(Delta delta, List<String> localObjectLines, boolean isNewObject, boolean wasModifiedOnServer) {
        StringBuilder output = new StringBuilder();
        output.append(OsUtils.LINE_SEPARATOR);
        int originalDeltaStart = delta.getOriginal().getPosition();
        int originalDeltaStartMinus1 = originalDeltaStart - 1;
        int originalDeltaStartMinus2 = originalDeltaStart - 2;
        if (originalDeltaStartMinus2 >= 1) {
            output.append("  ");
            output.append(localObjectLines.get(originalDeltaStartMinus2 - 1));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        if (originalDeltaStartMinus1 >= 1) {
            output.append("  ");
            output.append(localObjectLines.get(originalDeltaStartMinus1 - 1));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        if (originalDeltaStart >= 1) {
            output.append("  ");
            output.append(localObjectLines.get(originalDeltaStart - 1));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        int originalDeltaSize = delta.getOriginal().getLines().size();
        for (int i = 0; i < originalDeltaSize; ++i) {
            if (!wasModifiedOnServer) {
                output.append(ANSI_GREEN);
                output.append("+ ");
            } else {
                output.append(ANSI_RED);
                output.append("- ");
            }
            output.append(delta.getOriginal().getLines().get(i));
            output.append(ANSI_RESET);
            output.append(OsUtils.LINE_SEPARATOR);
        }
        int revisedDeltaSize = delta.getRevised().getLines().size();
        for (int i = 0; i < revisedDeltaSize; ++i) {
            if (!wasModifiedOnServer) {
                output.append(ANSI_RED);
                output.append("- ");
            } else {
                output.append(ANSI_GREEN);
                output.append("+ ");
            }
            output.append(delta.getRevised().getLines().get(i));
            output.append(ANSI_RESET);
            output.append(OsUtils.LINE_SEPARATOR);
        }
        int originalDeltaEnd = originalDeltaStart + originalDeltaSize;
        int originalDeltaEndPlus1 = originalDeltaStart + originalDeltaSize + 1;
        int originalDeltaEndPlus2 = originalDeltaStart + originalDeltaSize + 2;
        if (originalDeltaEnd < localObjectLines.size()) {
            output.append("  ");
            output.append(localObjectLines.get(originalDeltaEnd));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        if (originalDeltaEndPlus1 < localObjectLines.size()) {
            output.append("  ");
            output.append(localObjectLines.get(originalDeltaEndPlus1));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        if (originalDeltaEndPlus2 < localObjectLines.size()) {
            output.append("  ");
            output.append(localObjectLines.get(originalDeltaEndPlus2));
            output.append(OsUtils.LINE_SEPARATOR);
        }
        int revisedDeltaStart = delta.getRevised().getPosition();
        int revisedDeltaEnd = revisedDeltaStart + revisedDeltaSize - 1;
        String deltaHeader = this.formatDeltaHeader(originalDeltaStart, originalDeltaEnd - 1, revisedDeltaStart, revisedDeltaEnd, isNewObject, wasModifiedOnServer);
        output.insert(0, deltaHeader);
        return output.toString();
    }

    private String formatDeltaHeader(int originalDeltaStart, int originalDeltaEnd, int revisedDeltaStart, int revisedDeltaEnd, boolean isNewObject, boolean wasModifiedOnServer) {
        ++originalDeltaStart;
        ++originalDeltaEnd;
        ++revisedDeltaStart;
        ++revisedDeltaEnd;
        if (!isNewObject) {
            originalDeltaStart += 4;
            originalDeltaEnd += 4;
            revisedDeltaStart += 4;
            revisedDeltaEnd += 4;
        }
        StringBuilder deltaHeader = new StringBuilder();
        deltaHeader.append(ANSI_CYAN);
        deltaHeader.append("[ ");
        String originalSign = "+";
        String revisedSign = "-";
        if (wasModifiedOnServer) {
            originalSign = "-";
            revisedSign = "+";
        }
        if (originalDeltaStart == originalDeltaEnd) {
            deltaHeader.append(originalSign);
            deltaHeader.append(originalDeltaStart);
        } else if (originalDeltaStart < originalDeltaEnd) {
            deltaHeader.append(originalSign);
            deltaHeader.append(originalDeltaStart);
            deltaHeader.append(" ");
            deltaHeader.append(originalSign);
            deltaHeader.append(originalDeltaEnd);
        }
        if (originalDeltaStart <= originalDeltaEnd && revisedDeltaStart <= revisedDeltaEnd) {
            deltaHeader.append(" | ");
        }
        if (revisedDeltaStart == revisedDeltaEnd) {
            deltaHeader.append(revisedSign);
            deltaHeader.append(revisedDeltaStart);
        } else if (revisedDeltaStart < revisedDeltaEnd) {
            deltaHeader.append(revisedSign);
            deltaHeader.append(revisedDeltaStart);
            deltaHeader.append(" ");
            deltaHeader.append(revisedSign);
            deltaHeader.append(revisedDeltaEnd);
        }
        deltaHeader.append(" ]");
        deltaHeader.append(ANSI_RESET);
        return deltaHeader.toString();
    }

    private String formatFileHeader(File file) {
        StringBuilder fileHeader = new StringBuilder();
        fileHeader.append(ANSI_CYAN);
        fileHeader.append("/");
        fileHeader.append(Paths.get(file.getParent(), new String[0]).toFile().getName());
        fileHeader.append("/");
        fileHeader.append(file.getName());
        fileHeader.append(ANSI_RESET);
        fileHeader.append(OsUtils.LINE_SEPARATOR);
        return fileHeader.toString();
    }

    private ArrayList<String> processStringInput(String input) {
        String[] linesArray = input.split("\\r?\\n|\\r");
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : linesArray) {
            line = line.replace("\r", "");
            line = line.replace("/" + this.context.getCurrentProject() + "/", "/$projectId/");
            lines.add(line);
        }
        return lines;
    }

    public void removeAdditionalProperties(MdObjectDTO mdObject) {
        mdObject.setAccessInfo(null);
        mdObject.setVersion(null);
        mdObject.getAdditionalProperties().remove("links");
    }

    private void diffSyntaxErrorFile(File file) throws IOException {
        try {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            this.mapper.readValue(content, MdObjectDTO.class);
        }
        catch (JsonProcessingException exception) {
            throw new JsonSyntaxException(file, (Object)"diff", exception);
        }
    }
}

