/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.stepfunctions.machines.dto.ImportProjectRequest;
import com.cleveranalytics.service.job.JobDetailResponse;
import com.cleveranalytics.service.job.client.JobClient;
import com.cleveranalytics.service.job.rest.dto.GeneralJobRequest;
import com.cleveranalytics.service.job.type.ImportProjectJobRequest;
import com.cleveranalytics.service.job.type.TruncateJobRequest;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobShellClient {
    private static final Logger logger = LoggerFactory.getLogger(JobShellClient.class);

    public void truncateProject(ShellContext context) throws IOException, InterruptedException {
        logger.error("Truncation of project started...\n");
        TruncateJobRequest truncateJobRequest = new TruncateJobRequest();
        truncateJobRequest.setType("truncate");
        truncateJobRequest.setProjectId(context.getCurrentProject());
        JobClient jobClient = new JobClient(context.getCanRestClient());
        JobDetailResponse jobResponse = jobClient.executeJob((GeneralJobRequest)truncateJobRequest);
        if (!jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            throw new CleverMapsShellException("Project truncate operation failed with status=" + jobResponse.getStatus() + "\nmessage=" + jobResponse.getMessage() + "\njob_id=" + jobResponse.getId() + "\n");
        }
        logger.error("Project was successfully truncated.\n");
    }

    public void cloneProject(ShellContext context, String sourceProject) {
        ImportProjectRequest importProjectRequest = this.createImportProjectRequest(sourceProject);
        ImportProjectJobRequest importProjectJobRequest = this.createImportProjectJobRequest(importProjectRequest, context.getCurrentProject());
        logger.error("Starting cloning of project {}...", (Object)sourceProject);
        JobDetailResponse jobResponse = this.startImportProjectJob(context, importProjectJobRequest);
        if (jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            this.handleImportProjectResponse(sourceProject);
        } else {
            this.handleImportProjectFailedResponse(jobResponse, sourceProject);
        }
    }

    private ImportProjectRequest createImportProjectRequest(String sourceProject) {
        return new ImportProjectRequest().withSourceProjectId(sourceProject).withForce(Boolean.valueOf(true));
    }

    private ImportProjectJobRequest createImportProjectJobRequest(ImportProjectRequest request, String targetProject) {
        return new ImportProjectJobRequest().withType("importProject").withProjectId(targetProject).withContent(request);
    }

    private JobDetailResponse startImportProjectJob(ShellContext context, ImportProjectJobRequest request) {
        JobClient jobClient = new JobClient(context.getCanRestClient());
        try {
            return jobClient.executeJob((GeneralJobRequest)request);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sleep thread interrupted.");
        }
    }

    private void handleImportProjectResponse(String sourceProject) {
        logger.error("Cloning of project {} was successful.", (Object)sourceProject);
    }

    private void handleImportProjectFailedResponse(JobDetailResponse jobResponse, String sourceProject) {
        String message = "Cloning of project " + sourceProject + " failed with status=" + jobResponse.getStatus() + "\nmessage=" + jobResponse.getMessage() + "\njob_id=" + jobResponse.getId();
        throw new CleverMapsShellException(message);
    }
}

