/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.md.rest.dto.MdObjectsList;
import com.cleveranalytics.service.md.util.AdditionalPropsAllowingMdObjectMapper;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.ProjectDTO;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.ReferenceReplaceUtils;
import com.cleveranalytics.shell.client.ReferenceReplacer;
import com.cleveranalytics.shell.client.SpecificProjectIdLinkReplacer;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DiffDTO;
import com.cleveranalytics.shell.dto.DiffListDTO;
import com.cleveranalytics.shell.exception.JsonSyntaxException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.JsonDiff;
import com.flipkart.zjsonpatch.JsonPatch;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.client.HttpClientErrorException;

public class DiffProjectClient {
    static final Logger logger = LoggerFactory.getLogger(DiffProjectClient.class);
    private final ObjectMapper mapper = new AdditionalPropsAllowingMdObjectMapper();
    private final ShellContext context;

    public DiffProjectClient(ShellContext context) {
        this.context = context;
    }

    public DiffListDTO createDiff(String sourceProject, String destinationProject, List<String> objectTypes) throws IOException {
        ProjectClient projectClient = new ProjectClient(this.context.getCanRestClient());
        ProjectDTO sourceProjectDTO = this.getProjectById(projectClient, sourceProject);
        ProjectDTO destinationProjectDTO = this.getProjectById(projectClient, destinationProject);
        logger.error("Generating diff between projects \"" + sourceProjectDTO.getTitle() + "\" and \"" + destinationProjectDTO.getTitle() + "\"...\n");
        MdShellClient mdShellClient = (MdShellClient)this.context.getShellClient();
        this.context.setCurrentProject(sourceProject);
        MdObjectsList sourceFileList = mdShellClient.getObjectsList(this.context);
        logger.error("Fetched " + sourceFileList.size() + " objects from source project (" + sourceProjectDTO.getTitle() + ")");
        this.context.setCurrentProject(destinationProject);
        MdObjectsList destinationFileList = mdShellClient.getObjectsList(this.context);
        logger.error("Fetched " + destinationFileList.size() + " objects from destination project (" + destinationProjectDTO.getTitle() + ")\n");
        MdObjectsList addedObjects = sourceFileList.getAddedObjects(destinationFileList);
        MdObjectsList commonObjects = sourceFileList.getCommonObjects(destinationFileList);
        MdObjectsList deletedObjects = sourceFileList.getDeletedObjects(destinationFileList);
        List addDiffs = this.generateDiffs(sourceProject, destinationProject, objectTypes, addedObjects, sourceFileList, destinationFileList, DiffDTO.Operation.ADD);
        logger.error("Added objects: " + addDiffs.size());
        List modifyDiffs = this.generateDiffs(sourceProject, destinationProject, objectTypes, commonObjects, sourceFileList, destinationFileList, DiffDTO.Operation.MODIFY);
        logger.error("Modified objects: " + modifyDiffs.size());
        List deleteDiffs = this.generateDiffs(sourceProject, destinationProject, objectTypes, deletedObjects, sourceFileList, destinationFileList, DiffDTO.Operation.DELETE);
        logger.error("Deleted objects: " + deleteDiffs.size());
        return new DiffListDTO().withAdded(addDiffs).withModified(modifyDiffs).withDeleted(deleteDiffs);
    }

    private List<DiffDTO> generateDiffs(String sourceProject, String destinationProject, List<String> objectTypes, MdObjectsList modifiedList, MdObjectsList sourceList, MdObjectsList destinationList, DiffDTO.Operation operation) throws IOException {
        MdShellClient shellClient = (MdShellClient)this.context.getShellClient();
        ArrayList<DiffDTO> diffs = new ArrayList<DiffDTO>();
        for (String objectType : MdObjectType.getList()) {
            if (!objectTypes.contains(objectType)) continue;
            for (MdObjectDTO mdObject : modifiedList.getObjectsList(objectType)) {
                MdObjectDTO destinationObject;
                MdObjectDTO sourceObject;
                if (operation != DiffDTO.Operation.DELETE) {
                    sourceObject = sourceList.getObjectOfType(objectType, mdObject.getName());
                    sourceObject = ReferenceReplaceUtils.replaceReferencesInMdObject((MdObjectDTO)sourceObject, (ReferenceReplacer)new SpecificProjectIdLinkReplacer(sourceProject));
                } else {
                    sourceObject = new MdObjectDTO();
                }
                if (operation != DiffDTO.Operation.ADD) {
                    destinationObject = destinationList.getObjectOfType(objectType, mdObject.getName());
                    destinationObject = ReferenceReplaceUtils.replaceReferencesInMdObject((MdObjectDTO)destinationObject, (ReferenceReplacer)new SpecificProjectIdLinkReplacer(destinationProject));
                } else {
                    destinationObject = new MdObjectDTO();
                }
                this.removeGeneratedFields(sourceObject);
                JsonNode sourceNode = this.createJsonNode(sourceObject);
                this.removeGeneratedFields(destinationObject);
                JsonNode destinationNode = this.createJsonNode(destinationObject);
                JsonNode diffNode = JsonDiff.asJson((JsonNode)destinationNode, (JsonNode)sourceNode);
                if (diffNode.size() <= 0) continue;
                diffs.add(new DiffDTO().withObjectName(mdObject.getName()).withObjectType(objectType).withOperation(operation).withDiff(diffNode));
            }
        }
        return diffs;
    }

    private JsonNode createJsonNode(MdObjectDTO mdObject) {
        try {
            return (JsonNode)this.mapper.readValue(this.mapper.writeValueAsString((Object)mdObject), JsonNode.class);
        }
        catch (JsonProcessingException ex) {
            throw new JsonSyntaxException(mdObject.getName(), (Object)"diff", ex);
        }
    }

    private void removeGeneratedFields(MdObjectDTO mdObject) {
        mdObject.setId(null);
        mdObject.setVersion(null);
        mdObject.setAccessInfo(null);
        Map additionalProperties = mdObject.getAdditionalProperties();
        additionalProperties.remove("links");
        mdObject.setAdditionalProperties(additionalProperties);
    }

    private ProjectDTO getProjectById(ProjectClient projectClient, String projectId) {
        try {
            return projectClient.getProject(projectId);
        }
        catch (HttpClientErrorException ex) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.NOT_FOUND, "Project id=" + projectId + " not found on server=" + this.context.getConnectedServer());
        }
    }

    public String applyDiff(DiffListDTO diffs) throws IOException {
        Path path;
        StringBuilder removeMetadataOutput = new StringBuilder();
        for (DiffDTO diff : diffs.getAdded()) {
            path = this.createObjectPath(diff.getObjectName(), diff.getObjectType());
            JsonNode emptyMdObjectNode = this.createJsonNode(new MdObjectDTO());
            JsonNode appliedMdObjectNode = JsonPatch.apply((JsonNode)diff.getDiff(), (JsonNode)emptyMdObjectNode);
            DumpUtils.saveObjectToJson((Object)appliedMdObjectNode, (String)path.toString());
        }
        for (DiffDTO diff : diffs.getModified()) {
            path = this.createObjectPath(diff.getObjectName(), diff.getObjectType());
            if (!path.toFile().exists()) {
                throw new IOException("Cannot find object=" + path.toFile().getName() + " in dump to apply the diff on. Please make a dump first using 'dumpProject --skipData'.");
            }
            MdObjectDumpDTO mdObjectDump = DumpUtils.loadFileAsMdObjectDump((File)path.toFile());
            JsonNode mdObjectNode = this.createJsonNode(mdObjectDump.getContent());
            JsonNode appliedMdObjectNode = JsonPatch.apply((JsonNode)diff.getDiff(), (JsonNode)mdObjectNode);
            MdObjectDTO appliedObject = (MdObjectDTO)this.mapper.readValue(appliedMdObjectNode.toString(), MdObjectDTO.class);
            mdObjectDump.setContent(appliedObject);
            DumpUtils.saveObjectToJson((Object)mdObjectDump, (String)path.toString());
        }
        for (DiffDTO diff : diffs.getDeleted()) {
            removeMetadataOutput.append("removeMetadata --objectName ");
            removeMetadataOutput.append(diff.getObjectName());
            removeMetadataOutput.append("\n");
        }
        return removeMetadataOutput.toString();
    }

    private Path createObjectPath(String objectName, String objectType) {
        String fileName = DumpUtils.appendExtension((String)objectName, (String)".json");
        return Paths.get(this.context.getMetadataDumpPath().toString(), objectType, fileName);
    }
}

