/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectTypeEnum;
import com.cleveranalytics.service.md.util.AdditionalPropsAllowingMdObjectMapper;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.NameLinkReplacer;
import com.cleveranalytics.shell.client.NamePropertyIdentifierReplacer;
import com.cleveranalytics.shell.client.PrefixPropertyIdentifierReplacer;
import com.cleveranalytics.shell.client.ReferenceReplacer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReferenceReplaceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceReplaceUtils.class);
    private static final List<MdObjectTypeEnum> mdObjectTypesWithReferences = List.of(MdObjectTypeEnum.ATTRIBUTE_STYLE, MdObjectTypeEnum.DASHBOARD, MdObjectTypeEnum.DATA_PERMISSION, MdObjectTypeEnum.DATASET, MdObjectTypeEnum.EXPORT, MdObjectTypeEnum.INDICATOR, MdObjectTypeEnum.INDICATOR_DRILL, MdObjectTypeEnum.MAP, MdObjectTypeEnum.MARKER_SELECTOR, MdObjectTypeEnum.METRIC, MdObjectTypeEnum.PROJECT_SETTINGS, MdObjectTypeEnum.VIEW);
    private static final Pattern linkPattern = Pattern.compile("^/rest/projects/(\\$projectId|[a-z0-9]{16})/md/([a-zA-Z]+)(\\?name=([a-z][a-z0-9_-]*)|/([a-z0-9]{16}))$");
    private static final Pattern propertyIdentifierPattern = Pattern.compile("^[a-z][a-z0-9_-]*\\.[a-z][a-z0-9_-]*$");
    private static final ObjectMapper mapper = new AdditionalPropsAllowingMdObjectMapper();

    public static boolean isLink(String input) {
        return StringUtils.hasText((String)input) && linkPattern.matcher(input).matches();
    }

    public static boolean isPropertyIdentifier(String input) {
        return StringUtils.hasText((String)input) && propertyIdentifierPattern.matcher(input).matches();
    }

    public static MdObjectDTO replaceReferencesInMdObject(MdObjectDTO mdObject, ReferenceReplacer referenceReplacer) throws IOException {
        JsonNode replacedJsonNode = ReferenceReplaceUtils.traverseJsonNode((JsonNode)ReferenceReplaceUtils.createJsonNode((MdObjectDTO)mdObject), (ReferenceReplacer)referenceReplacer);
        return (MdObjectDTO)mapper.readValue(replacedJsonNode.toString(), MdObjectDTO.class);
    }

    public static List<MdObjectDumpDTO> replaceNameReferencesInReferencingDumpedMdObjects(File metadataDumpPath, MdObjectTypeEnum referencedMdObjectType, String oldName, String newName) throws IOException {
        ArrayList<MdObjectTypeEnum> objectsToLoad = new ArrayList<MdObjectTypeEnum>();
        for (MdObjectTypeEnum type : mdObjectTypesWithReferences) {
            if (referencedMdObjectType.equals((Object)type) && referencedMdObjectType != MdObjectTypeEnum.DATASET) continue;
            objectsToLoad.add(type);
        }
        List allObjectTypes = DumpUtils.loadMdObjectTypeDumps((File)metadataDumpPath, objectsToLoad);
        ArrayList<MdObjectDumpDTO> renamedReferences = new ArrayList<MdObjectDumpDTO>();
        for (MdObjectDumpDTO mdObjectDump : allObjectTypes) {
            JsonNode replacedJsonNode;
            NameLinkReplacer nameLinkReplacer = new NameLinkReplacer(oldName, newName);
            MdObjectDTO replaced = ReferenceReplaceUtils.replaceReferencesInMdObject((MdObjectDTO)mdObjectDump.getContent(), (ReferenceReplacer)nameLinkReplacer);
            NamePropertyIdentifierReplacer namePropertyIdentifierReplacer = new NamePropertyIdentifierReplacer(oldName, newName);
            replaced = ReferenceReplaceUtils.replaceReferencesInMdObject((MdObjectDTO)replaced, (ReferenceReplacer)namePropertyIdentifierReplacer);
            JsonNode original = ReferenceReplaceUtils.createJsonNode((MdObjectDTO)mdObjectDump.getContent());
            if (original.equals((Object)(replacedJsonNode = ReferenceReplaceUtils.createJsonNode((MdObjectDTO)replaced)))) continue;
            mdObjectDump.setContent(replaced);
            renamedReferences.add(mdObjectDump);
        }
        return renamedReferences;
    }

    private static JsonNode createJsonNode(MdObjectDTO mdObject) throws IOException {
        try {
            return (JsonNode)mapper.readValue(mapper.writeValueAsString((Object)mdObject), JsonNode.class);
        }
        catch (Exception ex) {
            logger.warn("Failed to create JsonNode from object={}.", (Object)mdObject, (Object)ex);
            throw new IOException("Failed to create JsonNode from object=" + mdObject.getId() + ".");
        }
    }

    private static JsonNode traverseJsonNode(JsonNode input, ReferenceReplacer referenceReplacer) {
        Iterator fields = input.fields();
        if (input.isObject()) {
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode value = (JsonNode)field.getValue();
                if (value.isContainerNode()) {
                    ReferenceReplaceUtils.traverseJsonNode((JsonNode)value, (ReferenceReplacer)referenceReplacer);
                    continue;
                }
                if (ReferenceReplaceUtils.isLink((String)value.asText())) {
                    if (((String)field.getKey()).equals("href")) continue;
                    field.setValue(new TextNode(referenceReplacer.replace(value.asText())));
                    continue;
                }
                if (referenceReplacer instanceof NameLinkReplacer) {
                    NameLinkReplacer nameLinkReplacer = (NameLinkReplacer)referenceReplacer;
                    if (!nameLinkReplacer.getOldName().equals(((JsonNode)field.getValue()).textValue())) continue;
                    field.setValue(new TextNode(nameLinkReplacer.getNewName()));
                    continue;
                }
                if (!(referenceReplacer instanceof PrefixPropertyIdentifierReplacer) && !(referenceReplacer instanceof NamePropertyIdentifierReplacer) || ((JsonNode)field.getValue()).textValue() == null || !ReferenceReplaceUtils.isPropertyIdentifier((String)((JsonNode)field.getValue()).textValue())) continue;
                field.setValue(new TextNode(referenceReplacer.replace(value.asText())));
            }
        }
        if (input.isArray()) {
            ArrayNode array = (ArrayNode)input;
            for (int i = 0; i < array.size(); ++i) {
                JsonNode element = array.get(i);
                if (element.isContainerNode()) {
                    ReferenceReplaceUtils.traverseJsonNode((JsonNode)element, (ReferenceReplacer)referenceReplacer);
                    continue;
                }
                if (ReferenceReplaceUtils.isLink((String)element.asText())) {
                    array.set(i, (JsonNode)new TextNode(referenceReplacer.replace(element.asText())));
                    continue;
                }
                if (referenceReplacer instanceof NameLinkReplacer) {
                    NameLinkReplacer nameLinkReplacer = (NameLinkReplacer)referenceReplacer;
                    if (!nameLinkReplacer.getOldName().equals(element.textValue())) continue;
                    array.set(i, (JsonNode)new TextNode(nameLinkReplacer.getNewName()));
                    continue;
                }
                if (!(referenceReplacer instanceof PrefixPropertyIdentifierReplacer) && !(referenceReplacer instanceof NamePropertyIdentifierReplacer) || !(element instanceof TextNode) || !ReferenceReplaceUtils.isPropertyIdentifier((String)element.textValue())) continue;
                array.set(i, (JsonNode)new TextNode(referenceReplacer.replace(element.asText())));
            }
        }
        return input;
    }
}

