/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.DataPullRequest;
import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DumpFileList;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.commands.project.LoadCsvCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class PushProjectCommand
implements CommandMarker {
    private static final Logger logger = LoggerFactory.getLogger(PushProjectCommand.class);
    private final ShellContext context;

    public PushProjectCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"pushProject"})
    public boolean isCommandAvailable() {
        return this.context.isOpenDump();
    }

    @CliCommand(value={"pushProject"}, help="Upload all modified files (data & metadata) to the project.It collects all modified metadata to upload, and performs full load of CSV files.")
    public void pushProjectCmd(@CliOption(key={"skipData"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip data push.") boolean skipData, @CliOption(key={"skipMetadata"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip metadata push.") boolean skipMetadata, @CliOption(key={"skipValidate"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip the run of validate after push") boolean skipValidate, @CliOption(key={"verbose"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Enables more verbose output.") boolean verbose, @CliOption(key={"multipart"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Enables multipart file upload (recommended for files larger than 2 GB)") boolean multipart, @CliOption(key={"gzip"}, mandatory=false, unspecifiedDefaultValue="true", help="Enables gzip compression.") boolean gzip) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            File dataDumpDirectory = this.context.getDataDumpPath().toFile();
            File metadataDumpDirectory = this.context.getMetadataDumpPath().toFile();
            if (!skipMetadata) {
                List allMetadataFiles = DumpUtils.findAllMetadataInDump((File)metadataDumpDirectory);
                List unmappableMetadataFiles = DumpUtils.filterMappableMetadataFiles((List)allMetadataFiles);
                List modifiedMetadata = DumpUtils.findModifiedMetadataInDump((ShellContext)this.context, (File)metadataDumpDirectory);
                List modifiedMetadataToPush = this.context.getShellClient() instanceof MdShellClient ? DumpUtils.filterUnwrappedMetadataFiles((List)modifiedMetadata) : modifiedMetadata;
                if (modifiedMetadataToPush.size() > 0 || unmappableMetadataFiles.size() > 0) {
                    this.pushMetadata(modifiedMetadataToPush, unmappableMetadataFiles);
                } else {
                    logger.error("No metadata objects were modified - nothing to push\n");
                }
            }
            if (!skipData) {
                List modifiedData = DumpUtils.findModifiedDataInDump((ShellContext)this.context, (File)dataDumpDirectory);
                if (modifiedData.size() > 0) {
                    this.pushData(modifiedData, verbose, multipart, gzip);
                } else {
                    logger.error("No data files were modified - nothing to push\n");
                }
            }
            if (!skipValidate) {
                DwhShellClient dwhShellClient = new DwhShellClient(this.context.getCanRestClient(), this.context.getProxyHost(), this.context.getProxyPort());
                Map violationTypes = dwhShellClient.simpleProjectIntegrityCheck(this.context.getCanRestClient(), this.context.getCurrentProject());
                this.printValidationCheck(violationTypes);
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    public void printValidationCheck(Map<String, Integer> violationTypes) {
        if (violationTypes.size() > 0) {
            logger.error("FAIL\n");
            logger.error("There are following DWH model/data integrity violations in the project:");
            logger.error(violationTypes + "\n");
            logger.error("Run \"validate\" command to see more details.");
        } else {
            logger.error("OK\n");
        }
    }

    protected void pushMetadata(List<File> metadataFiles, List<File> unmappableMetadataFiles) throws IOException {
        logger.error("Uploading modified metadata objects to the project...\n");
        AbstractShellClient shellClient = this.context.getShellClient();
        if (metadataFiles.size() > 0) {
            DumpFileList fileList = new DumpFileList();
            fileList.create(metadataFiles);
            for (List objectType : fileList.getOrder()) {
                for (File file : objectType) {
                    shellClient.pushObject(this.context.getCurrentProject(), file);
                    shellClient.putMetadataChecksumListElement(this.context, file);
                    logger.error("Uploaded object {}", (Object)file.getName());
                }
            }
            logger.error("");
        }
        if (unmappableMetadataFiles.size() > 0) {
            for (File errorFile : unmappableMetadataFiles) {
                shellClient.pushObject(this.context.getCurrentProject(), errorFile);
            }
        } else {
            logger.error("Metadata of project {} successfully updated from dump\n", (Object)this.context.getCurrentProject());
        }
    }

    protected void pushData(List<File> dataFiles, boolean verbose, boolean multipart, boolean gzip) throws IOException {
        LoadCsvCommand loadCsvCommand = new LoadCsvCommand(this.context);
        logger.error("Asynchronous data upload started...\n");
        for (int i = 0; i < dataFiles.size(); ++i) {
            File file = dataFiles.get(i);
            String datasetName = FilenameUtils.removeExtension((String)file.getName());
            loadCsvCommand.loadData(file.getName(), datasetName, DataPullRequest.Mode.FULL, null, verbose, multipart, gzip);
            if (!verbose || i >= dataFiles.size() - 1) continue;
            logger.error("");
        }
        logger.error("\nDWH data of project {} successfully updated from dump\n", (Object)this.context.getCurrentProject());
    }
}

