/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.commands.project.DumpProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DumpMetadataDTO;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.stereotype.Component;

@Component
public class OpenDumpCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(OpenDumpCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private final ShellContext context;

    @Autowired
    public OpenDumpCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"openDump"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"openDump"}, help="Open project dump.")
    public void openDumpCmd() throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            File shellDirectory = DumpProjectCommand.createShellDirectory((ShellContext)this.context);
            this.openMetadataDump(shellDirectory);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected void openMetadataDump(File shellDirectory) throws Exception {
        File projectDirectory = Paths.get(shellDirectory.getAbsolutePath(), this.context.getCurrentProject()).toFile();
        if (!projectDirectory.exists() || !this.context.hasDumpMetadataFile()) {
            throw new FileNotFoundException("Dump of project=" + this.context.getCurrentProject() + " not found in directory " + this.context.getDumpDirectory() + ".");
        }
        this.context.setOpenDump(true);
        DumpMetadataDTO dumpMetadata = DumpUtils.loadFileAsDumpMetadataFile((File)this.context.getDumpMetadataFile());
        logger.error("Dump of project " + this.context.getCurrentProject() + " opened.");
        logger.error("Last update to dump was " + dumpMetadata.getDumpTime());
        logger.error("Full path: " + this.context.getProjectPath());
    }
}

