/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.exception;

import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.config.ShellConfig;
import io.sentry.DefaultSentryClientFactory;
import io.sentry.SentryClient;
import io.sentry.connection.Connection;
import io.sentry.dsn.Dsn;
import io.sentry.event.helper.ContextBuilderHelper;
import io.sentry.event.helper.EventBuilderHelper;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryProxyClientFactory
extends DefaultSentryClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(SentryProxyClientFactory.class);
    private String dsnUri = "https://e55258244c0c4d9f964274a3497bfb8f@o99157.ingest.sentry.io/5414550";

    public SentryClient createSentryClient(Dsn dsn) {
        String proxySettings = this.getDsnProxySettings();
        dsn = proxySettings != null ? new Dsn(this.dsnUri + proxySettings) : new Dsn(this.dsnUri);
        Connection connection = this.createConnection(dsn);
        SentryClient sentryClient = new SentryClient(connection, this.getContextManager(dsn));
        sentryClient.addBuilderHelper((EventBuilderHelper)new ContextBuilderHelper(sentryClient));
        return this.configureSentryClient(sentryClient, dsn);
    }

    private String getDsnProxySettings() {
        try {
            ShellConfig config = new ShellConfig();
            File configFile = DumpUtils.fetchConfigFile();
            DumpUtils.loadProperties((ShellConfig)config, (File)configFile);
            if (config.getProxyHost() != null && config.getProxyPort() != null) {
                return "?http.proxy.host=" + config.getProxyHost() + "&http.proxy.port=" + config.getProxyPort();
            }
        }
        catch (IOException ex) {
            logger.warn("Failed to load proxy settings from config file.", (Throwable)ex);
        }
        return null;
    }
}

