/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client.factory;

import com.cleveranalytics.common.client.BearerTokenCanRestClient;
import com.cleveranalytics.common.client.CanRestClient;
import com.cleveranalytics.service.authn.client.AuthnPkceClient;
import com.cleveranalytics.service.authn.client.GeneratedTokenClient;
import com.cleveranalytics.shell.client.factory.ShellClientType;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class ShellAuthnClientFactory {
    private final ShellContext context;

    public ShellAuthnClientFactory(ShellContext context) {
        this.context = context;
    }

    public CanRestClient getClient(ShellClientType type) {
        if (type.equals((Object)ShellClientType.ACCESS_TOKEN)) {
            return this.initGeneratedTokenClient(this.context, (ClientHttpRequestFactory)this.initRequestFactory());
        }
        if (type.equals((Object)ShellClientType.BEARER_TOKEN)) {
            return this.initBearerTokenClient(this.context, (ClientHttpRequestFactory)this.initRequestFactory());
        }
        throw new CleverMapsShellException("Unknown Shell client type=" + type);
    }

    private GeneratedTokenClient initGeneratedTokenClient(ShellContext context, ClientHttpRequestFactory requestFactory) {
        GeneratedTokenClient client = new GeneratedTokenClient(new AuthnPkceClient(context.getServiceName(), context.getAuthnServer(), requestFactory), context.getServiceName(), context.getConnectedServer(), context.getAccessToken(), requestFactory);
        client.setMessageConverters(this.initMessageConverters());
        return client;
    }

    private BearerTokenCanRestClient initBearerTokenClient(ShellContext context, ClientHttpRequestFactory requestFactory) {
        BearerTokenCanRestClient client = new BearerTokenCanRestClient(context.getServiceName(), context.getConnectedServer(), context.getBearerToken(), requestFactory);
        client.setMessageConverters(this.initMessageConverters());
        return client;
    }

    private List<HttpMessageConverter<?>> initMessageConverters() {
        return Arrays.asList(new StringHttpMessageConverter(StandardCharsets.UTF_8), new MappingJackson2HttpMessageConverter(new ObjectMapper()), new FormHttpMessageConverter());
    }

    public SimpleClientHttpRequestFactory initRequestFactory() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setBufferRequestBody(false);
        requestFactory.setOutputStreaming(false);
        requestFactory.setConnectTimeout(30000);
        requestFactory.setReadTimeout(30000);
        if (this.context.getProxyHost() != null) {
            if (this.context.getProxyPort() != null) {
                InetSocketAddress address = new InetSocketAddress(this.context.getProxyHost(), (int)this.context.getProxyPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                requestFactory.setProxy(proxy);
            } else {
                throw new CleverMapsShellException("No proxy port number specified. Check config file or provide the --proxyPort parameter");
            }
        }
        return requestFactory;
    }
}

