/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdReferenceTree;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.commands.dump.RemoveMetadataCommand;
import com.cleveranalytics.shell.config.BannerProvider;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StringUtils;

@Component
public class RemoveMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(RemoveMetadataCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private final ShellContext context;

    @Autowired
    public RemoveMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"removeMetadata"})
    public boolean isCommandAvailable() {
        return this.context.isOpenDump();
    }

    @CliCommand(value={"removeMetadata"}, help="Remove a metadata object from the project and from the dump. The file must be located in a currently opened dump, and must not be new.")
    public void removeMetadataCmd(@CliOption(key={"objectName"}, mandatory=false, help="Name of the object (with or without \".json\" extension).") String objectName, @CliOption(key={"objectId"}, mandatory=false, help="ID of the object.") String objectId, @CliOption(key={"orphanObjects"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Prints a sequence of removeMetadata commands to delete orphan metadata objects.") Boolean orphanObjects) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            int argsUsed = 0;
            argsUsed = StringUtils.hasText((String)objectName) ? argsUsed + 1 : argsUsed;
            argsUsed = StringUtils.hasText((String)objectId) ? argsUsed + 1 : argsUsed;
            int n = argsUsed = orphanObjects != false ? argsUsed + 1 : argsUsed;
            if (argsUsed > 1) {
                logger.error(BannerProvider.ANSI_MAGENTA + "You can specify only one of --objectName, --objectId and --orphanObjects options" + BannerProvider.ANSI_RESET);
                return;
            }
            if (StringUtils.hasText((String)objectName)) {
                this.removeObjectByName(objectName);
            } else if (StringUtils.hasText((String)objectId)) {
                this.removeObjectById(objectId);
            } else if (orphanObjects.booleanValue()) {
                this.createRemoveOrphansList();
            } else {
                logger.error(BannerProvider.ANSI_MAGENTA + "You must specify at least one of --objectName, --objectId and --orphanObjects options" + BannerProvider.ANSI_RESET);
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    private void removeObjectByName(String objectName) throws IOException {
        logger.error("Removing object {} from project {}...\n", (Object)objectName, (Object)this.context.getCurrentProject());
        String nameWithExt = DumpUtils.appendExtension((String)objectName, (String)".json");
        String nameWithoutExt = FilenameUtils.removeExtension((String)objectName);
        MdShellClient shellClient = (MdShellClient)this.context.getShellClient();
        MdObjectClient mdObjectClient = new MdObjectClient(this.context.getCanRestClient());
        MdObjectDTO remoteObject = mdObjectClient.getMdObjectByName(this.context.getCurrentProject(), nameWithoutExt);
        if (remoteObject != null) {
            String objectType = remoteObject.getType().toStringPlural();
            shellClient.removeObjectByName(this.context, objectType, nameWithoutExt);
            logger.error("Remote object {} successfully deleted from the project", (Object)nameWithoutExt);
            this.removeObjectLocally(nameWithoutExt);
            File file = Paths.get(this.context.getMetadataDumpPath().toString(), objectType, nameWithExt).toFile();
            shellClient.removeMetadataChecksumListElement(this.context, file);
        } else {
            logger.error("Object {} not found in the project, no local files were deleted\n", (Object)objectName);
        }
    }

    private void removeObjectById(String objectId) throws IOException {
        logger.error("Removing object {} from project {}...\n", (Object)objectId, (Object)this.context.getCurrentProject());
        ArrayList<MdObjectDTO> objectsToDelete = new ArrayList<MdObjectDTO>();
        List metadataFiles = DumpUtils.findAllMetadataInDump((File)this.context.getMetadataDumpPath().toFile());
        for (File metadataFile : metadataFiles) {
            MdObjectDumpDTO mdObjectDump = DumpUtils.loadFileAsMdObjectDump((File)metadataFile);
            if (!mdObjectDump.getContent().getId().equals(objectId)) continue;
            objectsToDelete.add(mdObjectDump.getContent());
        }
        if (objectsToDelete.isEmpty()) {
            logger.error("Object {} not found in the project, no local files were deleted\n", (Object)objectId);
            return;
        }
        AbstractShellClient shellClient = this.context.getShellClient();
        for (MdObjectDTO mdObject : objectsToDelete) {
            shellClient.removeObjectById(this.context.getCurrentProject(), mdObject.getType().toStringPlural(), objectId);
            logger.error("Remote object with id {} successfully deleted from the project", (Object)objectId);
            this.removeObjectLocally(mdObject.getName());
            File file = Paths.get(this.context.getMetadataDumpPath().toString(), mdObject.getType().toStringPlural(), mdObject.getName()).toFile();
            shellClient.removeMetadataChecksumListElement(this.context, file);
        }
    }

    private void removeObjectLocally(String objectName) throws IOException {
        File fileToDelete = DumpUtils.findMetadataInDump((ShellContext)this.context, (String)objectName);
        if (fileToDelete != null && fileToDelete.exists()) {
            FileSystemUtils.deleteRecursively((File)fileToDelete);
            if (!fileToDelete.exists()) {
                logger.error("Local file {} successfully deleted\n", (Object)fileToDelete.getName());
            } else {
                logger.error("Failed to delete local file {}\n", (Object)fileToDelete.getName());
            }
        } else {
            logger.error("File {} was not found in dump.\n", (Object)objectName);
        }
    }

    private void createRemoveOrphansList() {
        MdShellClient shellClient = (MdShellClient)this.context.getShellClient();
        List orphanObjects = shellClient.getOrphanObjects(this.context);
        if (orphanObjects.isEmpty()) {
            logger.error("\nThere are no orphan objects in project {}\n", (Object)this.context.getCurrentProject());
            return;
        }
        orphanObjects.sort(new MdReferenceTreeComparator());
        StringBuilder removeMetadataOutput = new StringBuilder();
        for (MdReferenceTree orphanObject : orphanObjects) {
            removeMetadataOutput.append("removeMetadata --objectName ");
            removeMetadataOutput.append(orphanObject.getName());
            removeMetadataOutput.append("\n");
        }
        logger.error("\nRun these {} commands to remove all orphan objects:\n", (Object)orphanObjects.size());
        logger.error("{}\n", (Object)removeMetadataOutput);
    }
}

