/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.client.BearerTokenCanRestClient;
import com.cleveranalytics.common.client.CanRestClient;
import com.cleveranalytics.common.libs.aws.s3.S3UriSigner;
import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.CsvOptions;
import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.DataDumpRequest;
import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.DataPullRequest;
import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.DataValidator;
import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.HttpsUpload;
import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.ModelValidator;
import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.S3Upload;
import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.ValidateRequest;
import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.ValidateResponse;
import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.Violation;
import com.cleveranalytics.service.authn.client.GeneratedTokenClient;
import com.cleveranalytics.service.dwh.client.DwhFileClient;
import com.cleveranalytics.service.dwh.client.MultipartUploadAsyncTask;
import com.cleveranalytics.service.dwh.exception.DwhException;
import com.cleveranalytics.service.dwh.rest.dto.DataCreateMultipartUploadResponse;
import com.cleveranalytics.service.dwh.rest.dto.DataCreateUploadResponse;
import com.cleveranalytics.service.dwh.rest.dto.PartETag;
import com.cleveranalytics.service.job.JobDetailResponse;
import com.cleveranalytics.service.job.client.JobClient;
import com.cleveranalytics.service.job.rest.dto.GeneralJobRequest;
import com.cleveranalytics.service.job.type.DataDumpJobRequest;
import com.cleveranalytics.service.job.type.DataDumpJobResponse;
import com.cleveranalytics.service.job.type.DataPullJobRequest;
import com.cleveranalytics.service.job.type.DataPullJobResponse;
import com.cleveranalytics.service.job.type.ValidateJobRequest;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.md.util.AdditionalPropsAllowingMdObjectMapper;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.regions.Region;

public class DwhShellClient {
    private static final Logger logger = LoggerFactory.getLogger(DwhShellClient.class);
    private final ObjectMapper mapper = new AdditionalPropsAllowingMdObjectMapper();
    private final DwhFileClient dwhFileClient;
    public static final long PART_SIZE = 0x3200000L;
    private static final long MINIMUM_PART_SIZE = 0x500000L;
    private static final int THREAD_POOL_SIZE = 5;
    private static final Region S3_REGION = Region.EU_WEST_1;

    public DwhShellClient(CanRestClient canRestClient, String proxyHost, Integer proxyPort) {
        this.dwhFileClient = new DwhFileClient(canRestClient, proxyHost, proxyPort);
    }

    public void dumpData(ShellContext context, List<DatasetDTO> datasets, boolean skipErrors) throws IOException {
        List dumpResponses;
        try {
            dumpResponses = this.performDump(context, datasets, skipErrors);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sleep thread interrupted.");
        }
        for (DataDumpJobResponse dumpDatasetResponse : dumpResponses) {
            String bearerToken;
            if (!((Link)dumpDatasetResponse.getLinks().get(0)).getRel().value().equals("self")) {
                throw new IOException("Failed to obtain CSV dump link.");
            }
            String csvDumpLink = ((Link)dumpDatasetResponse.getLinks().get(0)).getHref();
            String datasetName = dumpDatasetResponse.getDataset();
            String csvFilePath = Paths.get(context.getDataDumpPath().toString(), datasetName).toString();
            String md5hash = this.dwhFileClient.getCsv(csvDumpLink, csvFilePath = DumpUtils.appendExtension((String)csvFilePath, (String)".csv"), bearerToken = this.getBearerToken(context.getCanRestClient()));
            if (md5hash == null) continue;
            this.checkDumpedFile(context, new File(csvFilePath), datasetName, dumpDatasetResponse.getNumberOfRows(), md5hash);
        }
    }

    private String getBearerToken(CanRestClient client) {
        if (client instanceof GeneratedTokenClient) {
            return ((GeneratedTokenClient)client).getAccessToken();
        }
        return ((BearerTokenCanRestClient)client).getBearerToken();
    }

    private List<DataDumpJobResponse> performDump(ShellContext context, List<DatasetDTO> datasets, boolean skipErrors) throws InterruptedException {
        ArrayList<DataDumpJobResponse> dumpResponses = new ArrayList<DataDumpJobResponse>();
        JobClient jobClient = new JobClient(context.getCanRestClient());
        logger.error("Asynchronous data dump started...\n");
        for (DatasetDTO dwhDataset : datasets) {
            DataDumpRequest dumpDatasetRequest = new DataDumpRequest().withDataset(dwhDataset.getName());
            DataDumpJobRequest dataDumpJobRequest = new DataDumpJobRequest().withType("dataDump").withProjectId(context.getCurrentProject()).withContent(dumpDatasetRequest);
            JobDetailResponse jobResponse = jobClient.executeJob((GeneralJobRequest)dataDumpJobRequest);
            if (jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
                DataDumpJobResponse asyncResponse = (DataDumpJobResponse)this.mapper.convertValue(jobResponse.getResult(), DataDumpJobResponse.class);
                dumpResponses.add(asyncResponse);
                continue;
            }
            if (!skipErrors) {
                throw new CleverMapsShellException("Data dump failed with status=" + String.valueOf(jobResponse.getStatus()) + "\nmessage=" + jobResponse.getMessage() + "\njob_id=" + jobResponse.getId());
            }
            logger.error(jobResponse.getMessage().split("\n")[0]);
        }
        return dumpResponses;
    }

    public void checkDumpedFile(ShellContext context, File csvFile, String datasetName, Long numberOfRows, String md5Hash) throws IOException {
        if (csvFile.exists()) {
            String dumpedMd5Hash = DumpUtils.calculateMD5((File)csvFile);
            if (!md5Hash.equals(dumpedMd5Hash)) {
                throw new CleverMapsShellException("MD5 checksum of dumped CSV file " + csvFile.getName() + " differs from the server file checksum.");
            }
        } else {
            throw new FileNotFoundException("Dumped CSV file=" + csvFile.getAbsolutePath() + " not found.");
        }
        AbstractShellClient shellClient = context.getShellClient();
        shellClient.putDataChecksumListElement(context, csvFile);
        logger.error("DWH data of dataset {} successfully dumped to {} ({} rows dumped)", new Object[]{datasetName, csvFile.getName(), numberOfRows});
    }

    public void performLoad(ShellContext context, File csvFile, String datasetName, DataPullRequest.Mode mode, CsvOptions csvOptions, boolean verbose, boolean gzip, Boolean skipRefreshingMaterializedViews) throws IOException {
        long startTime = System.nanoTime();
        if (verbose) {
            logger.error("[{}] Started upload of CSV file {}", (Object)DwhFileClient.formatCurrentTime(), (Object)csvFile.getName());
        }
        String projectId = context.getCurrentProject();
        DataCreateUploadResponse dataCreateUploadResponse = this.dwhFileClient.createFileUpload(projectId);
        if (verbose) {
            logger.error("[{}] Created file upload URL", (Object)DwhFileClient.formatCurrentTime());
        }
        if (gzip) {
            this.dwhFileClient.uploadGzippedCsv(projectId, csvFile, dataCreateUploadResponse.getUploadUrlEncoded(), Boolean.valueOf(verbose));
        } else {
            this.dwhFileClient.uploadCsv(projectId, csvFile, dataCreateUploadResponse.getUploadUrlEncoded(), Boolean.valueOf(verbose));
        }
        String uploadLink = this.dwhFileClient.findSelfLink(dataCreateUploadResponse.getLinks());
        DataPullRequest dataPullRequest = this.createDataPullRequest(datasetName, mode, uploadLink, csvOptions, skipRefreshingMaterializedViews);
        this.executeDataPullJob(context, csvFile, datasetName, dataPullRequest, verbose, startTime);
    }

    public void performS3Load(ShellContext context, String s3Uri, String datasetName, DataPullRequest.Mode mode, CsvOptions csvOptions, boolean verbose, Boolean skipRefreshingMaterializedViews) throws IOException, URISyntaxException {
        DataPullRequest dataPullRequest;
        long startTime = System.nanoTime();
        if (verbose) {
            logger.error("[{}] Started upload from S3 URI {}", (Object)DwhFileClient.formatCurrentTime(), (Object)s3Uri);
        }
        if (StringUtils.hasText((String)context.getAccessKeyId()) && StringUtils.hasText((String)context.getSecretAccessKey())) {
            URI signedUrl = S3UriSigner.signS3Download((String)s3Uri, (Region)S3_REGION, (String)context.getAccessKeyId(), (String)context.getSecretAccessKey());
            if (verbose) {
                logger.error("[{}] Created file upload URL", (Object)DwhFileClient.formatCurrentTime());
            }
            dataPullRequest = this.createHttpsDataPullRequest(datasetName, mode, signedUrl, csvOptions, skipRefreshingMaterializedViews);
        } else {
            dataPullRequest = this.createS3DataPullRequest(datasetName, mode, s3Uri, null, null, csvOptions, skipRefreshingMaterializedViews);
        }
        this.executeDataPullJob(context, null, datasetName, dataPullRequest, verbose, startTime);
    }

    public void performHttpsLoad(ShellContext context, URI httpsUrl, String datasetName, DataPullRequest.Mode mode, CsvOptions csvOptions, boolean verbose, Boolean skipRefreshingMaterializedViews) throws IOException {
        long startTime = System.nanoTime();
        if (verbose) {
            logger.error("[{}] Started upload from URL {}", (Object)DwhFileClient.formatCurrentTime(), (Object)httpsUrl);
        }
        DataPullRequest dataPullRequest = this.createHttpsDataPullRequest(datasetName, mode, httpsUrl, csvOptions, skipRefreshingMaterializedViews);
        this.executeDataPullJob(context, null, datasetName, dataPullRequest, verbose, startTime);
    }

    public void performMultipartLoad(ShellContext context, File csvFile, String datasetName, DataPullRequest.Mode mode, CsvOptions csvOptions, boolean verbose, boolean gzip, Boolean skipRefreshingMaterializedViews) throws IOException {
        if (verbose) {
            logger.error("[{}] Started multipart upload of CSV file {}", (Object)DwhFileClient.formatCurrentTime(), (Object)csvFile.getName());
        }
        long parts = csvFile.length() / 0x3200000L + 1L;
        String projectId = context.getCurrentProject();
        DataCreateMultipartUploadResponse response = this.dwhFileClient.createMultipartFileUpload(projectId, parts);
        if (verbose) {
            logger.error("[{}] Splitting the file of size {} into {} parts", new Object[]{DwhFileClient.formatCurrentTime(), DwhFileClient.getSize((File)csvFile), parts});
        }
        List fileParts = this.splitFile(csvFile, 0x3200000L, Boolean.valueOf(verbose));
        for (int i = 0; i < fileParts.size() - 1; ++i) {
            if (((File)fileParts.get(i)).length() >= 0x500000L) continue;
            logger.error("[{}] WARNING: Some compressed files are smaller than 5 MB, using regular upload\n", (Object)DwhFileClient.formatCurrentTime());
            this.performLoad(context, csvFile, datasetName, mode, csvOptions, verbose, gzip, skipRefreshingMaterializedViews);
            return;
        }
        List uploadUrls = response.getUploadUrlsEncoded();
        if (fileParts.size() != uploadUrls.size()) {
            throw new CleverMapsShellException("The number of multipart upload file parts (" + fileParts.size() + ") differs from the number of signed URLs (" + uploadUrls.size() + ").");
        }
        List partETags = this.performAsyncPartUpload(projectId, fileParts, uploadUrls, verbose);
        this.dwhFileClient.completeMultipartFileUpload(projectId, response.getId(), response.getUploadId(), partETags);
        if (verbose) {
            logger.error("[{}] Completed the multipart file upload", (Object)DwhFileClient.formatCurrentTime());
        }
        for (File filePart : fileParts) {
            this.dwhFileClient.deleteFile(filePart, Boolean.valueOf(verbose));
        }
        long startTime = System.nanoTime();
        String uploadLink = this.dwhFileClient.findSelfLink(response.getLinks());
        DataPullRequest dataPullRequest = this.createDataPullRequest(datasetName, mode, uploadLink, csvOptions, skipRefreshingMaterializedViews);
        this.executeDataPullJob(context, csvFile, datasetName, dataPullRequest, verbose, startTime);
    }

    /*
     * WARNING - void declaration
     */
    private List<PartETag> performAsyncPartUpload(String projectId, List<File> fileParts, List<String> uploadUrls, boolean verbose) {
        void var9_12;
        ArrayList<MultipartUploadAsyncTask> callableList = new ArrayList<MultipartUploadAsyncTask>();
        for (int i = 0; i < fileParts.size(); ++i) {
            MultipartUploadAsyncTask callable = new MultipartUploadAsyncTask(this.dwhFileClient, projectId, fileParts.get(i), uploadUrls.get(i), Boolean.valueOf(verbose));
            callableList.add(callable);
        }
        ExecutorService executor = Executors.newFixedThreadPool(5);
        ArrayList futureList = new ArrayList();
        for (Callable callable : callableList) {
            Future future = executor.submit(callable);
            futureList.add(future);
        }
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        boolean bl = false;
        while (var9_12 < futureList.size()) {
            try {
                partETags.add(new PartETag().withPartNumber(Integer.valueOf((int)(var9_12 + true))).witheTag((String)((Future)futureList.get((int)var9_12)).get()));
            }
            catch (InterruptedException | ExecutionException ex) {
                logger.error("Failed to extract future ETag=" + ex.getMessage(), (Throwable)ex);
                throw new CleverMapsShellException("Failed to extract future ETag=" + ex.getMessage());
            }
            ++var9_12;
        }
        executor.shutdown();
        return partETags;
    }

    private void executeDataPullJob(ShellContext context, File csvFile, String datasetName, DataPullRequest pullRequest, boolean verbose, long startTime) throws IOException {
        DataPullJobRequest pullJobRequest = new DataPullJobRequest().withType("dataPull").withProjectId(context.getCurrentProject()).withContent(pullRequest);
        JobDetailResponse jobResponse = this.startDataPullJob(pullJobRequest, context, verbose);
        if (jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            if (verbose) {
                logger.error("[{}] Data pull job finished", (Object)DwhFileClient.formatCurrentTime());
            }
            DataPullJobResponse dataPullResponse = this.convertJobDetailResponse(jobResponse);
            if (pullRequest.getUpload() != null) {
                this.handlePullResponse(context, csvFile, dataPullResponse, datasetName, verbose, startTime);
            } else if (pullRequest.getS3Upload() != null) {
                String s3Uri = pullRequest.getS3Upload().getUri();
                this.handleS3PullResponse(dataPullResponse, s3Uri, datasetName, verbose, startTime);
            } else if (pullRequest.getHttpsUpload() != null) {
                URI httpsUrl = pullRequest.getHttpsUpload().getUrl();
                this.handleHttpsPullResponse(dataPullResponse, httpsUrl, datasetName, verbose, startTime);
            }
        } else {
            this.handleDataPullFailedResponse(jobResponse, datasetName, verbose);
        }
    }

    private void handlePullResponse(ShellContext context, File csvFile, DataPullJobResponse dataPullResponse, String datasetName, boolean verbose, long startTime) throws IOException {
        AbstractShellClient shellClient = context.getShellClient();
        shellClient.putDataChecksumListElement(context, csvFile);
        if (verbose) {
            logger.error("[{}] CSV file {} successfully loaded into dataset {} ({} rows loaded)", new Object[]{DwhFileClient.formatCurrentTime(), csvFile.getName(), datasetName, dataPullResponse.getNumberOfRowsLoaded()});
            logger.error("[{}] Upload took {} ms", (Object)DwhFileClient.formatCurrentTime(), (Object)((System.nanoTime() - startTime) / 1000000L));
        } else {
            logger.error("CSV file {} successfully loaded into dataset {} ({} rows loaded)", new Object[]{csvFile.getName(), datasetName, dataPullResponse.getNumberOfRowsLoaded()});
        }
    }

    private void handleS3PullResponse(DataPullJobResponse dataPullResponse, String s3Uri, String datasetName, boolean verbose, long startTime) {
        if (verbose) {
            logger.error("[{}] S3 file from URI {} successfully loaded into dataset {} ({} rows loaded)", new Object[]{DwhFileClient.formatCurrentTime(), s3Uri, datasetName, dataPullResponse.getNumberOfRowsLoaded()});
            logger.error("[{}] Upload took {} ms", (Object)DwhFileClient.formatCurrentTime(), (Object)((System.nanoTime() - startTime) / 1000000L));
        } else {
            logger.error("S3 file from URI {} successfully loaded into dataset {} ({} rows loaded)", new Object[]{s3Uri, datasetName, dataPullResponse.getNumberOfRowsLoaded()});
        }
    }

    private void handleHttpsPullResponse(DataPullJobResponse dataPullResponse, URI s3Uri, String datasetName, boolean verbose, long startTime) {
        if (verbose) {
            logger.error("[{}] File from URL {} successfully loaded into dataset {} ({} rows loaded)", new Object[]{DwhFileClient.formatCurrentTime(), s3Uri, datasetName, dataPullResponse.getNumberOfRowsLoaded()});
            logger.error("[{}] Upload took {} ms", (Object)DwhFileClient.formatCurrentTime(), (Object)((System.nanoTime() - startTime) / 1000000L));
        } else {
            logger.error("File from URL {} successfully loaded into dataset {} ({} rows loaded)", new Object[]{s3Uri, datasetName, dataPullResponse.getNumberOfRowsLoaded()});
        }
    }

    private JobDetailResponse startDataPullJob(DataPullJobRequest request, ShellContext context, boolean verbose) {
        JobClient jobClient = new JobClient(context.getCanRestClient());
        try {
            if (verbose) {
                logger.error("[{}] Data pull job started", (Object)DwhFileClient.formatCurrentTime());
            }
            return jobClient.executeJob((GeneralJobRequest)request);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sleep thread interrupted.");
        }
    }

    private void handleDataPullFailedResponse(JobDetailResponse jobResponse, String datasetName, boolean verbose) {
        Object messagePrefix = verbose ? "[" + DwhFileClient.formatCurrentTime() + "]: " : "";
        String message = "Data upload of dataset=" + datasetName + " failed with status=" + String.valueOf(jobResponse.getStatus()) + "\nmessage=" + jobResponse.getMessage() + "\njob_id=" + jobResponse.getId();
        throw new CleverMapsShellException((String)messagePrefix + message);
    }

    public List<File> splitFile(File file, long partSize, Boolean verbose) {
        ArrayList<File> fileParts = new ArrayList<File>();
        int index = 1;
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line = br.readLine();
            while (line != null) {
                File filePart = new File(file.getParent(), file.getName() + "." + String.format("%03d", index++));
                try (GZIPOutputStream gos = new GZIPOutputStream(new FileOutputStream(filePart));){
                    int fileSize = 0;
                    while (line != null) {
                        byte[] bytes = (line + System.lineSeparator()).getBytes(Charset.defaultCharset());
                        if ((long)(fileSize + bytes.length) > partSize) {
                            break;
                        }
                        gos.write(bytes);
                        fileSize += bytes.length;
                        line = br.readLine();
                    }
                }
                fileParts.add(filePart);
                if (!verbose.booleanValue()) continue;
                logger.error("[{}] Created compressed file {} of size {}", new Object[]{DwhFileClient.formatCurrentTime(), filePart.getName(), DwhFileClient.getSize((File)filePart)});
            }
        }
        catch (IOException ex) {
            throw new DwhException("[" + DwhFileClient.formatCurrentTime() + "] Failed to split file=" + file.getName() + " into parts.");
        }
        return fileParts;
    }

    protected DataPullRequest createDataPullRequest(String datasetName, DataPullRequest.Mode mode, String uploadUri, CsvOptions csvOptions, Boolean skipRefreshingMaterializedViews) throws IOException {
        try {
            return new DataPullRequest().withDataset(datasetName).withMode(mode).withUpload(new URI(uploadUri)).withType(DataPullRequest.Type.CSV).withCsvOptions(csvOptions).withSkipRefreshingMaterializedViews(skipRefreshingMaterializedViews);
        }
        catch (URISyntaxException ex) {
            throw new IOException("Failed to parse self link=" + uploadUri);
        }
    }

    protected DataPullRequest createS3DataPullRequest(String datasetName, DataPullRequest.Mode mode, String s3Uri, String s3AccessKeyId, String s3SecretAccessKey, CsvOptions csvOptions, Boolean skipRefreshingMaterializedViews) {
        return new DataPullRequest().withDataset(datasetName).withMode(mode).withS3Upload(new S3Upload().withUri(s3Uri).withAccessKeyId(s3AccessKeyId).withSecretAccessKey(s3SecretAccessKey)).withType(DataPullRequest.Type.CSV).withCsvOptions(csvOptions).withSkipRefreshingMaterializedViews(skipRefreshingMaterializedViews);
    }

    protected DataPullRequest createHttpsDataPullRequest(String datasetName, DataPullRequest.Mode mode, URI httpsUrl, CsvOptions csvOptions, Boolean skipRefreshingMaterializedViews) {
        return new DataPullRequest().withDataset(datasetName).withMode(mode).withHttpsUpload(new HttpsUpload().withUrl(httpsUrl)).withType(DataPullRequest.Type.CSV).withCsvOptions(csvOptions).withSkipRefreshingMaterializedViews(skipRefreshingMaterializedViews);
    }

    protected DataPullJobResponse convertJobDetailResponse(JobDetailResponse jobDetailResponse) {
        try {
            String dwhDataPullJobResponseResultString = this.mapper.writeValueAsString(jobDetailResponse.getResult());
            return (DataPullJobResponse)this.mapper.readValue(dwhDataPullJobResponseResultString, DataPullJobResponse.class);
        }
        catch (IOException ex) {
            throw new CleverMapsShellException("Failed to convert JobDetailResponse to the DataPullJobResponse object.");
        }
    }

    public Map<String, Integer> simpleProjectIntegrityCheck(CanRestClient canRestClient, String projectId) throws IOException {
        logger.error("Validating DWH model/data integrity of project " + projectId + "... ");
        ValidateResponse validateResponse = this.validateProjectIntegrity(canRestClient, projectId, false, false);
        HashMap<String, Integer> violationTypes = new HashMap<String, Integer>();
        for (Violation violation : validateResponse.getViolations()) {
            if (violationTypes.containsKey(violation.getViolationType())) {
                Integer violationCount;
                Integer n = violationCount = (Integer)violationTypes.get(violation.getViolationType());
                violationCount = violationCount + 1;
                violationTypes.put(violation.getViolationType(), violationCount);
                continue;
            }
            violationTypes.put(violation.getViolationType(), 1);
        }
        return violationTypes;
    }

    public ValidateResponse validateProjectIntegrity(CanRestClient canRestClient, String projectId, boolean skipModel, boolean skipData) throws IOException {
        ValidateRequest validateRequest = new ValidateRequest();
        if (!skipModel) {
            validateRequest.setModelValidator(new ModelValidator());
        }
        if (!skipData) {
            validateRequest.setDataValidator(new DataValidator());
        }
        try {
            return this.performValidation(canRestClient, projectId, validateRequest);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sleep thread interrupted.");
        }
    }

    protected ValidateResponse performValidation(CanRestClient canRestClient, String projectId, ValidateRequest validateRequest) throws IOException, InterruptedException {
        JobClient jobClient = new JobClient(canRestClient);
        ValidateJobRequest validateJobRequest = new ValidateJobRequest().withType("validate").withProjectId(projectId).withContent(validateRequest);
        JobDetailResponse jobResponse = jobClient.executeJob((GeneralJobRequest)validateJobRequest);
        if (jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            String dwhValidateResponseResult = this.mapper.writeValueAsString(jobResponse.getResult());
            return (ValidateResponse)this.mapper.readValue(dwhValidateResponseResult, ValidateResponse.class);
        }
        throw new CleverMapsShellException("Project validation job failed with status=" + String.valueOf(jobResponse.getStatus()) + " message=" + jobResponse.getMessage() + "\n");
    }
}

