/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.shell.client.ReferenceReplacer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificProjectIdLinkReplacer
implements ReferenceReplacer {
    static final Logger logger = LoggerFactory.getLogger(SpecificProjectIdLinkReplacer.class);
    private final Pattern projectIdPattern;

    public SpecificProjectIdLinkReplacer(String projectId) {
        this.projectIdPattern = Pattern.compile(projectId);
    }

    public String replace(String input) {
        Matcher matcher;
        String replaced = null;
        if (input != null && input.equals(replaced = (matcher = this.projectIdPattern.matcher(input)).replaceFirst("\\$projectId"))) {
            logger.error("\nWarning: Failed to replace project ID in URL=" + input);
            logger.error("Check if the project ID in the url matches correct project ID syntax=[a-z0-9]{16}");
        }
        return replaced;
    }
}

