/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.shell.client.ReferenceReplacer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixNameLinkReplacer
implements ReferenceReplacer {
    static final Logger logger = LoggerFactory.getLogger(PrefixNameLinkReplacer.class);
    private final Pattern namePattern = Pattern.compile("\\?name=");
    private final String prefix;
    private final String objectName;

    public PrefixNameLinkReplacer(String prefix, String objectName) {
        this.prefix = prefix;
        this.objectName = objectName;
    }

    public String replace(String input) {
        Matcher matcher;
        String replaced = null;
        if (input != null && input.equals(replaced = (matcher = this.namePattern.matcher(input)).replaceFirst(this.namePattern.pattern() + this.prefix))) {
            logger.error("\nWarning: Failed to prefix the name attribute in URL=" + input + " of object=" + this.objectName);
        }
        return replaced;
    }
}

