/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetTypeEnum;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.commands.project.DumpProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class DumpCsvCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(DumpCsvCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private final ShellContext context;

    @Autowired
    public DumpCsvCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"dumpCsv"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"dumpCsv"}, help="Dump data from a specified dataset into a CSV file. Creates new dump with dumped data.")
    public void dumpCsvCmd(@CliOption(key={"dataset"}, mandatory=true, help="Name of the dataset to dump.") String datasetName, @CliOption(key={"force"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Overwrites current data.") boolean force) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (!this.context.isOpenDump() || !this.context.hasDumpMetadataFile()) {
                File shellDirectory = DumpProjectCommand.createShellDirectory((ShellContext)this.context);
                File dumpDirectory = DumpProjectCommand.createProjectDirectory((File)shellDirectory, (ShellContext)this.context);
                DumpProjectCommand.createDataDumpDirectory((File)dumpDirectory, (ShellContext)this.context);
                DumpProjectCommand.createMetadataDumpDirectory((File)dumpDirectory, (ShellContext)this.context);
                logger.error("");
                if (!this.context.hasDumpMetadataFile()) {
                    AbstractShellClient shellClient = this.context.getShellClient();
                    shellClient.createMetadataDumpFile(this.context);
                }
                logger.error("Dump opened and set as current\n");
            }
            this.dumpDataset(datasetName, force);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    private void dumpDataset(String datasetName, boolean force) throws IOException {
        MdDatasetClient datasetClient = this.context.getDatasetClient();
        DatasetDTO dataset = datasetClient.getDatasetByName(this.context.getCurrentProject(), datasetName);
        if (!dataset.getRef().getType().equals(DatasetTypeEnum.DWH_TYPE.toString())) {
            throw new IllegalArgumentException("Dataset " + datasetName + " is not of DWH type, it's data cannot be dumped.");
        }
        File dumpCsvFile = DumpUtils.findDataInDump((ShellContext)this.context, (String)datasetName);
        if (dumpCsvFile != null && !force) {
            logger.error("DWH data of dataset {} exist in current dump. Use --force to overwrite existing data.\n", (Object)datasetName);
            return;
        }
        ArrayList<DatasetDTO> oneDataset = new ArrayList<DatasetDTO>();
        oneDataset.add(dataset);
        DwhShellClient dwhShellClient = new DwhShellClient(this.context.getCanRestClient(), this.context.getProxyHost(), this.context.getProxyPort());
        dwhShellClient.dumpData(this.context, oneDataset, false);
    }
}

