/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.md.rest.dto.MdObjectsList;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class StatusCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(StatusCommand.class);
    private final ShellContext context;
    private static final String LOCALLY_MODIFIED = "modified locally";
    private static final String MODIFIED_ON_SERVER = "modified on the server";

    @Autowired
    public StatusCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"status"})
    public boolean isCommandAvailable() {
        return this.context.isOpenDump();
    }

    @CliCommand(value={"status"}, help="Check the status of a currently opened dump against the project on the server. This command detects files which have been locally or remotely changed, and also detects files which have a syntax error or constraint violations.")
    public void statusCmd(@CliOption(key={"remote"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="List metadata content on the server.") boolean remote) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            StringBuilder output = !remote ? this.formatLocalStatus() : this.formatRemoteStatus();
            logger.error(output.toString());
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    public StringBuilder formatLocalStatus() throws IOException {
        logger.error(this.printFirstLineStatus().toString());
        File metadataDumpDirectory = this.context.getMetadataDumpPath().toFile();
        List allMetadataFiles = DumpUtils.findAllMetadataInDump((File)metadataDumpDirectory);
        List unmappableMetadataFiles = DumpUtils.filterMappableMetadataFiles((List)allMetadataFiles);
        List mappableMetadataFiles = DumpUtils.filterUnmappableMetadataFiles((List)allMetadataFiles);
        List unwrappedMetadataFiles = DumpUtils.filterWrappedMetadataFiles((List)mappableMetadataFiles);
        List newMetadataFiles = DumpUtils.filterFilesPresentInMd5List((ShellContext)this.context, (List)unwrappedMetadataFiles);
        List locallyModifiedMetadata = DumpUtils.findModifiedMetadataInDump((ShellContext)this.context, (File)metadataDumpDirectory);
        TreeMap modifiedOnServer = DumpUtils.findModifiedMetadataOnServer((ShellContext)this.context, (File)metadataDumpDirectory);
        List missingMetadataInDump = DumpUtils.findAllMissingFilesInDump((ShellContext)this.context, (List)allMetadataFiles);
        File dataDumpDirectory = this.context.getDataDumpPath().toFile();
        List newDataFiles = DumpUtils.findNewDataInDump((File)dataDumpDirectory);
        List locallyModifiedData = DumpUtils.findModifiedDataInDump((ShellContext)this.context, (File)dataDumpDirectory);
        modifiedOnServer = new TreeMap(modifiedOnServer);
        Collections.sort(mappableMetadataFiles);
        Collections.sort(newMetadataFiles);
        Collections.sort(locallyModifiedMetadata);
        Collections.sort(newDataFiles);
        Collections.sort(locallyModifiedData);
        ArrayList newFiles = new ArrayList();
        ArrayList locallyModified = new ArrayList();
        newFiles.addAll(newMetadataFiles);
        newFiles.addAll(newDataFiles);
        locallyModified.addAll(locallyModifiedMetadata);
        locallyModified.addAll(locallyModifiedData);
        StringBuilder output = new StringBuilder();
        if (unmappableMetadataFiles.size() > 0) {
            output.append((CharSequence)this.printUnmappableFiles(unmappableMetadataFiles));
        }
        for (File file : newFiles) {
            locallyModified.remove(file);
            modifiedOnServer.remove(file);
        }
        if (locallyModified.isEmpty() && modifiedOnServer.isEmpty() && newFiles.isEmpty() && missingMetadataInDump.isEmpty()) {
            output.append((CharSequence)this.printAllFilesUpToDate());
        } else {
            if (locallyModified.isEmpty()) {
                output.append((CharSequence)this.printNoFilesModified(LOCALLY_MODIFIED, !newFiles.isEmpty() || !modifiedOnServer.isEmpty() || !missingMetadataInDump.isEmpty()));
            } else {
                output.append((CharSequence)this.printModifiedLocally(locallyModified));
            }
            if (modifiedOnServer.isEmpty()) {
                output.append((CharSequence)this.printNoFilesModified(MODIFIED_ON_SERVER, !newFiles.isEmpty() || !missingMetadataInDump.isEmpty()));
            } else {
                output.append((CharSequence)this.printModifiedOnServer(modifiedOnServer));
            }
            if (!locallyModified.isEmpty() && !modifiedOnServer.isEmpty()) {
                ArrayList modifiedOnServerList = new ArrayList(modifiedOnServer.keySet());
                output.append((CharSequence)this.printConflictFiles(locallyModified, modifiedOnServerList));
            }
            if (!newFiles.isEmpty()) {
                output.append((CharSequence)this.printNewFiles(newFiles, !modifiedOnServer.isEmpty() || !missingMetadataInDump.isEmpty()));
            }
            if (!missingMetadataInDump.isEmpty()) {
                List missingFileNames = missingMetadataInDump.stream().map(object -> object.getName() + ".json").collect(Collectors.toList());
                output.append((CharSequence)this.printMissingFiles(missingFileNames));
            }
        }
        return output;
    }

    public StringBuilder formatRemoteStatus() throws IOException {
        logger.error(this.printFirstLineServer().toString());
        StringBuilder output = new StringBuilder();
        output.append((CharSequence)this.printServerContent());
        output.append("\n");
        return output;
    }

    protected StringBuilder printFirstLineStatus() {
        StringBuilder output = new StringBuilder();
        output.append("Checking status of project ");
        output.append(this.context.getCurrentProject());
        output.append(" (");
        output.append(this.context.getProjectTitle());
        output.append(") ");
        output.append("against dump ");
        output.append("...\n");
        return output;
    }

    protected StringBuilder printFirstLineServer() {
        StringBuilder output = new StringBuilder();
        output.append("Checking project ");
        output.append(this.context.getCurrentProject());
        output.append(" (");
        output.append(this.context.getProjectTitle());
        output.append(") ");
        output.append("metadata content on ");
        output.append(this.context.getConnectedServerRelativeUrl());
        output.append("...\n");
        return output;
    }

    protected StringBuilder printAllFilesUpToDate() {
        StringBuilder output = new StringBuilder();
        output.append("All files are up to date with project ");
        output.append(this.context.getCurrentProject());
        output.append("\n");
        return output;
    }

    protected StringBuilder printNoFilesModified(String phrase, boolean newLine) {
        StringBuilder output = new StringBuilder();
        output.append("No files have been ");
        output.append(phrase);
        output.append("\n");
        if (newLine) {
            output.append("\n");
        }
        return output;
    }

    protected StringBuilder printUnmappableFiles(List<File> unmappableFiles) {
        StringBuilder output = new StringBuilder();
        output.append(unmappableFiles.size());
        output.append(unmappableFiles.size() == 1 ? " file" : " files");
        output.append(unmappableFiles.size() == 1 ? " contains" : " contain");
        output.append(" syntax errors and/or constraint violations:\n");
        for (File file : unmappableFiles) {
            output.append("\t");
            output.append(file.getAbsolutePath());
            output.append("\n");
        }
        output.append("\n");
        return output;
    }

    protected StringBuilder printModifiedLocally(List<File> modifiedFiles) {
        StringBuilder output = new StringBuilder();
        output.append(modifiedFiles.size());
        output.append(modifiedFiles.size() == 1 ? " file" : " files");
        output.append(modifiedFiles.size() == 1 ? " has been " : " have been ");
        output.append(LOCALLY_MODIFIED);
        output.append(":\n");
        for (File file : modifiedFiles) {
            output.append("\t");
            output.append(file.getAbsolutePath());
            output.append("\n");
        }
        output.append("\n");
        return output;
    }

    protected StringBuilder printModifiedOnServer(Map<File, Long> modifiedFiles) {
        StringBuilder output = new StringBuilder();
        output.append(modifiedFiles.size());
        output.append(modifiedFiles.size() == 1 ? " file" : " files");
        output.append(modifiedFiles.size() == 1 ? " has been " : " have been ");
        output.append(MODIFIED_ON_SERVER);
        output.append(":\n");
        for (Map.Entry<File, Long> entry : modifiedFiles.entrySet()) {
            output.append("\t");
            if (entry.getValue() == 0L) {
                output.append("(deleted on server) ");
            }
            output.append(entry.getKey().getAbsolutePath());
            output.append("\n");
        }
        return output;
    }

    protected StringBuilder printConflictFiles(List<File> locallyModified, List<File> modifiedOnServer) {
        StringBuilder output = new StringBuilder();
        ArrayList<File> conflictFiles = new ArrayList<File>();
        for (File file : locallyModified) {
            if (!modifiedOnServer.contains(file)) continue;
            conflictFiles.add(file);
        }
        if (conflictFiles.size() > 0) {
            output.append("\n");
            output.append(conflictFiles.size());
            output.append(conflictFiles.size() == 1 ? " file" : " files");
            output.append(conflictFiles.size() == 1 ? " has been " : " have been ");
            output.append("modified both locally, and on the server:\n");
            for (File file : conflictFiles) {
                output.append("\t");
                output.append(file.getAbsolutePath());
                output.append("\n");
            }
        }
        return output;
    }

    protected StringBuilder printNewFiles(List<File> newFiles, boolean newLine) {
        StringBuilder output = new StringBuilder();
        if (newLine) {
            output.append("\n");
        }
        output.append(newFiles.size());
        output.append(" new");
        output.append(newFiles.size() == 1 ? " file" : " files");
        output.append(newFiles.size() == 1 ? " has been " : " have been ");
        output.append("detected:");
        for (File file : newFiles) {
            output.append("\n\t");
            output.append(file.getAbsolutePath());
        }
        output.append("\n");
        return output;
    }

    protected StringBuilder printMissingFiles(List<String> missingMetadataInDump) {
        StringBuilder output = new StringBuilder();
        output.append(missingMetadataInDump.size());
        output.append(missingMetadataInDump.size() == 1 ? " file" : " files");
        output.append(missingMetadataInDump.size() == 1 ? " is " : " are ");
        output.append("missing from dump (deleted locally):");
        for (String fileName : missingMetadataInDump) {
            output.append("\n\t");
            output.append(fileName);
        }
        output.append("\n");
        return output;
    }

    protected StringBuilder printServerContent() throws IOException {
        StringBuilder output = new StringBuilder();
        AbstractShellClient shellClient = this.context.getShellClient();
        MdObjectsList objectsList = shellClient.getObjectsList(this.context);
        output.append((CharSequence)this.printMdList(objectsList));
        return output;
    }

    protected StringBuilder printMdList(MdObjectsList objectsList) {
        StringBuilder output = new StringBuilder();
        for (String mdObjectType : MdObjectType.getList()) {
            List objects = objectsList.getObjectsList(mdObjectType);
            ArrayList<String> nameList = new ArrayList<String>();
            for (MdObjectDTO mdObject : objects) {
                nameList.add(mdObject.getName());
            }
            output.append(mdObjectType);
            output.append(":\n\t");
            if (nameList.size() > 0) {
                Collections.sort(nameList);
                for (int i = 0; i < nameList.size(); ++i) {
                    output.append((String)nameList.get(i));
                    if (i < nameList.size() - 1) {
                        output.append("\n\t");
                        continue;
                    }
                    if (mdObjectType.equals("views")) continue;
                    output.append("\n\t\n");
                }
                continue;
            }
            output.append("[no objects]");
            if (mdObjectType.equals("views")) continue;
            output.append("\n\n");
        }
        return output;
    }
}

