/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDwhTypeDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetsDTO;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.DumpFileWriteException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DumpProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(DumpProjectCommand.class);
    private final ShellContext context;

    @Autowired
    public DumpProjectCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"dumpProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"dumpProject"}, help="Dump project data and metadata to a directory. If the dump is successful, the current dump is opened.")
    public void dumpProjectCmd(@CliOption(key={"skipData"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip data dump.") boolean skipData, @CliOption(key={"skipMetadata"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip metadata dump.") boolean skipMetadata, @CliOption(key={"force"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Overwrite local dump.") boolean force, @CliOption(key={"ignoreFailedDatasets"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip failed dataset dumps (for projects with incomplete data).") boolean ignoreFailedDatasets, @CliOption(key={"nativeDatasetsOnly"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import only native project datasets (without origin attribute).") boolean nativeDatasetsOnly) throws Exception {
        this.dumpProject(skipData, skipMetadata, nativeDatasetsOnly, force, ignoreFailedDatasets);
    }

    protected void dumpProject(boolean skipData, boolean skipMetadata, boolean nativeDatasetsOnly, boolean force, boolean ignoreFailedDatasets) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (skipData && skipMetadata) {
                logger.error("Skipping project dump - nothing to dump\n");
                return;
            }
            if (this.context.hasDumpMetadataFile() && !force) {
                logger.error("Dump already present. Use openDump to open dump or dumpProject --force to overwrite current dump.\n");
                return;
            }
            File shellDirectory = DumpProjectCommand.createShellDirectory((ShellContext)this.context);
            File projectDirectory = DumpProjectCommand.createProjectDirectory((File)shellDirectory, (ShellContext)this.context);
            File dataDumpDirectory = DumpProjectCommand.createDataDumpDirectory((File)projectDirectory, (ShellContext)this.context);
            File metadataDumpDirectory = DumpProjectCommand.createMetadataDumpDirectory((File)projectDirectory, (ShellContext)this.context);
            AbstractShellClient shellClient = this.context.getShellClient();
            shellClient.createMetadataDumpFile(this.context);
            if (force) {
                DumpUtils.cleanMetadataDirectories((File)metadataDumpDirectory);
                FileUtils.cleanDirectory((File)dataDumpDirectory);
            }
            if (!skipMetadata) {
                this.dumpMetadata(metadataDumpDirectory);
            } else {
                logger.error("Skipping metadata dump of project {}\n", (Object)this.context.getCurrentProject());
            }
            if (!skipData) {
                this.dumpData(dataDumpDirectory, nativeDatasetsOnly, ignoreFailedDatasets);
            } else {
                logger.error("Skipping data dump of project {}\n", (Object)this.context.getCurrentProject());
            }
            logger.error("Dump opened\n");
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected void dumpData(File dataDumpPath, boolean nativeDatasetsOnly, boolean skipErrors) throws IOException {
        MdDatasetClient datasetClient = this.context.getDatasetClient();
        DatasetsDTO dwhDatasets = nativeDatasetsOnly ? datasetClient.getNativeDatasets(this.context.getCurrentProject()) : datasetClient.getDatasetsByType(this.context.getCurrentProject(), DatasetDwhTypeDTO.class);
        DwhShellClient dwhShellClient = new DwhShellClient(this.context.getCanRestClient(), this.context.getProxyHost(), this.context.getProxyPort());
        dwhShellClient.dumpData(this.context, (List)dwhDatasets, skipErrors);
        logger.error("\nProject DWH data successfully dumped to {}\n", (Object)dataDumpPath.getPath());
    }

    protected void dumpMetadata(File metadataDumpPath) throws IOException {
        logger.error("Metadata dump started...\n");
        AbstractShellClient shellClient = this.context.getShellClient();
        shellClient.dumpObjectsLocal(this.context);
        logger.error("\nProject metadata successfully dumped to {}\n", (Object)metadataDumpPath.getPath());
    }

    protected static File createShellDirectory(ShellContext context) {
        File shellDirectory;
        if (context.getDumpDirectory() == null) {
            shellDirectory = new File(System.getProperty("user.dir"));
            logger.error("No directory specified, setting " + String.valueOf(shellDirectory) + " as shell directory");
        } else {
            shellDirectory = new File(context.getDumpDirectory());
        }
        if (!shellDirectory.exists()) {
            if (shellDirectory.mkdirs()) {
                logger.error("Creating shell directory {}", (Object)shellDirectory);
            } else {
                throw new DumpFileWriteException("Cannot create shell directory=" + shellDirectory.getAbsolutePath() + ".");
            }
        }
        context.setDumpDirectory(shellDirectory.toString());
        return shellDirectory;
    }

    protected static File createProjectDirectory(File shellDirectory, ShellContext context) {
        context.setOpenDump(true);
        File projectDirectory = Paths.get(shellDirectory.getAbsolutePath(), context.getCurrentProject()).toFile();
        if (!projectDirectory.exists()) {
            if (projectDirectory.mkdirs()) {
                logger.error("Creating project directory {}", (Object)projectDirectory);
            } else {
                throw new DumpFileWriteException("Cannot create project directory=" + projectDirectory.getAbsolutePath() + ".");
            }
        }
        return projectDirectory;
    }

    protected static File createDataDumpDirectory(File projectDirectory, ShellContext context) {
        if (context.getDataDumpPath().toFile().exists()) {
            return context.getDataDumpPath().toFile();
        }
        File dataDumpDirectory = Paths.get(projectDirectory.getAbsolutePath(), "data").toFile();
        if (!dataDumpDirectory.exists()) {
            if (dataDumpDirectory.mkdirs()) {
                logger.error("Creating data dump directory {}", (Object)dataDumpDirectory);
            } else {
                throw new DumpFileWriteException("Cannot create data dump directory=" + dataDumpDirectory.getAbsolutePath() + ".");
            }
        }
        return dataDumpDirectory;
    }

    protected static File createMetadataDumpDirectory(File projectDirectory, ShellContext context) {
        if (context.getMetadataDumpPath().toFile().exists()) {
            return context.getMetadataDumpPath().toFile();
        }
        File metadataDumpDirectory = Paths.get(projectDirectory.getAbsolutePath(), "metadata").toFile();
        if (!metadataDumpDirectory.exists()) {
            if (metadataDumpDirectory.mkdirs()) {
                logger.error("Creating metadata dump directory {}", (Object)metadataDumpDirectory);
                List typeList = MdObjectType.getList();
                for (String objectType : typeList) {
                    File subdirectory = Paths.get(context.getMetadataDumpPath().toString(), objectType).toFile();
                    if (subdirectory.mkdirs()) continue;
                    throw new DumpFileWriteException("Cannot create metadata type subdirectory=" + metadataDumpDirectory.getAbsolutePath() + ".");
                }
            } else {
                throw new DumpFileWriteException("Cannot create metadata dump directory=" + metadataDumpDirectory.getAbsolutePath() + ".");
            }
        }
        return metadataDumpDirectory;
    }
}

