/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.client.CanRestClient;
import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.exception.MdException;
import com.cleveranalytics.service.md.rest.dto.GenerateDatasetRequestDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.md.rest.dto.MdObjectTypeEnum;
import com.cleveranalytics.service.md.rest.dto.MdObjectsDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectsList;
import com.cleveranalytics.service.md.rest.dto.MdReferenceTree;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.md.util.AdditionalPropsAllowingMdObjectMapper;
import com.cleveranalytics.service.md.util.CanPrettyPrinter;
import com.cleveranalytics.service.md.util.ETag;
import com.cleveranalytics.service.md.util.UriUtils;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.Role;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.MdRestoreCollection;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DiffClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.ProjectIdLinkReplacer;
import com.cleveranalytics.shell.client.ProjectIdPlaceholderLinkReplacer;
import com.cleveranalytics.shell.client.ReferenceReplaceUtils;
import com.cleveranalytics.shell.client.ReferenceReplacer;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.JsonSyntaxException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import difflib.Chunk;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.util.Assert;

public class MdShellClient
extends AbstractShellClient {
    private static final Logger logger = LoggerFactory.getLogger(MdShellClient.class);
    private final ObjectMapper mapper = new AdditionalPropsAllowingMdObjectMapper();
    private final MdObjectClient mdObjectClient;

    public MdShellClient(CanRestClient canRestClient) {
        this.mdObjectClient = new MdObjectClient(canRestClient);
    }

    public MdObjectsList getObjectsList(ShellContext context) {
        MdObjectsList objectsList = new MdObjectsList();
        ProjectClient projectClient = new ProjectClient(context.getCanRestClient());
        Role projectRole = projectClient.getMembershipInProject(context.getCurrentProject()).getRole();
        block30: for (String mdObjectType : MdObjectType.getList()) {
            if (mdObjectType.equals("dataPermissions") && !projectRole.equals((Object)Role.ADMIN)) {
                objectsList = objectsList.withDataPermissions(new ArrayList());
                continue;
            }
            MdObjectsDTO mdObjects = this.mdObjectClient.getMdObjects(context.getCurrentProject(), mdObjectType);
            switch (mdObjectType) {
                case "attributeStyles": {
                    objectsList = objectsList.withAttributeStyles((List)mdObjects);
                    continue block30;
                }
                case "dashboards": {
                    objectsList = objectsList.withDashboards((List)mdObjects);
                    continue block30;
                }
                case "dataPermissions": {
                    objectsList = objectsList.withDataPermissions((List)mdObjects);
                    continue block30;
                }
                case "datasets": {
                    objectsList = objectsList.withDatasets((List)mdObjects);
                    continue block30;
                }
                case "exports": {
                    objectsList = objectsList.withExports((List)mdObjects);
                    continue block30;
                }
                case "indicatorDrills": {
                    objectsList = objectsList.withIndicatorDrills((List)mdObjects);
                    continue block30;
                }
                case "indicators": {
                    objectsList = objectsList.withIndicators((List)mdObjects);
                    continue block30;
                }
                case "maps": {
                    objectsList = objectsList.withMaps((List)mdObjects);
                    continue block30;
                }
                case "markers": {
                    objectsList = objectsList.withMarkers((List)mdObjects);
                    continue block30;
                }
                case "markerSelectors": {
                    objectsList = objectsList.withMarkerSelectors((List)mdObjects);
                    continue block30;
                }
                case "metrics": {
                    objectsList = objectsList.withMetrics((List)mdObjects);
                    continue block30;
                }
                case "projectSettings": {
                    objectsList = objectsList.withProjectSettings((List)mdObjects);
                    continue block30;
                }
                case "views": {
                    objectsList = objectsList.withViews((List)mdObjects);
                    continue block30;
                }
            }
            logger.error("\"" + mdObjectType + "\" is not a valid MdObject type.");
        }
        return objectsList;
    }

    public List<String> getObjectsTree(ShellContext context, String objectName, boolean includeDatasets) {
        MdReferenceTree tree = this.mdObjectClient.getReferenceTree(context.getCurrentProject(), objectName, includeDatasets);
        Set objectNames = this.parseReferenceTree(tree, new HashSet());
        return new ArrayList<String>(objectNames);
    }

    private Set<String> parseReferenceTree(MdReferenceTree tree, Set<String> objectNames) {
        objectNames.add(tree.getName());
        for (MdReferenceTree reference : tree.getReferences()) {
            this.parseReferenceTree(reference, objectNames);
        }
        return objectNames;
    }

    public List<MdReferenceTree> getOrphanObjects(ShellContext context) {
        List trees = this.mdObjectClient.getReferenceOrphans(context.getCurrentProject());
        HashSet allObjectReferences = new HashSet();
        for (MdReferenceTree tree : trees) {
            Set objectReferences = this.flattenReferenceTree(tree, new HashSet());
            allObjectReferences.addAll(objectReferences);
        }
        return new ArrayList<MdReferenceTree>(allObjectReferences);
    }

    private Set<MdReferenceTree> flattenReferenceTree(MdReferenceTree tree, Set<MdReferenceTree> objectReferences) {
        objectReferences.add(tree);
        for (MdReferenceTree reference : tree.getReferences()) {
            this.flattenReferenceTree(reference, objectReferences);
        }
        return objectReferences;
    }

    public void dumpObjectsLocal(ShellContext context) throws IOException {
        String projectId = context.getCurrentProject();
        ProjectClient projectClient = new ProjectClient(context.getCanRestClient());
        Role projectRole = projectClient.getMembershipInProject(context.getCurrentProject()).getRole();
        for (String mdObjectType : MdObjectType.getList()) {
            MdObjectsDTO mdObjects;
            if (mdObjectType.equals("dataPermissions") && !projectRole.equals((Object)Role.ADMIN) || (mdObjects = this.mdObjectClient.getMdObjects(projectId, mdObjectType)).isEmpty()) continue;
            logger.error("Dumping " + mdObjectType);
            for (MdObjectDTO mdObject : mdObjects) {
                this.wrapAndSaveMdObject(context, mdObject);
            }
        }
    }

    public void wrapAndSaveMdObject(ShellContext context, MdObjectDTO mdObject) throws IOException {
        Assert.notNull((Object)context, (String)"ShellContext is null.");
        Assert.notNull((Object)mdObject, (String)"MdObject is null.");
        String serverETagValue = this.headMdObjectETag(context.getCurrentProject(), mdObject);
        mdObject = ReferenceReplaceUtils.replaceReferencesInMdObject((MdObjectDTO)mdObject, (ReferenceReplacer)new ProjectIdLinkReplacer(mdObject.getName()));
        mdObject.setVersion(new ETag(serverETagValue).getVersion());
        MdObjectDumpDTO objectDump = DumpUtils.wrapMdObject((String)context.getCurrentProject(), (MdObjectDTO)mdObject);
        String filename = DumpUtils.appendExtension((String)mdObject.getName(), (String)".json");
        File typeDirectory = this.createMetadataSubfolder(context.getMetadataDumpPath().toFile(), mdObject.getType());
        Path path = Paths.get(typeDirectory.toString(), filename);
        DumpUtils.saveObjectToJson((Object)objectDump, (String)path.toString());
        this.putMetadataChecksumListElement(context, path.toFile());
    }

    public void addObject(String projectId, File file, boolean silent) throws IOException {
        MdObjectDTO mdObject;
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)file, (String)"File path of object to add is null.");
        try {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            mdObject = (MdObjectDTO)this.mapper.readValue(content, MdObjectDTO.class);
        }
        catch (JsonProcessingException exception) {
            throw new JsonSyntaxException(file, (Object)"addMetadata", exception);
        }
        try {
            if (!mdObject.getName().equals(FilenameUtils.removeExtension((String)file.getName()))) {
                throw new CleverMapsShellException("JSON object name=" + mdObject.getName() + " and the filename=" + file.getName() + " do not match.");
            }
            mdObject = ReferenceReplaceUtils.replaceReferencesInMdObject((MdObjectDTO)mdObject, (ReferenceReplacer)new ProjectIdPlaceholderLinkReplacer(projectId, mdObject.getName()));
            MdObjectDTO createdMdObject = this.mdObjectClient.postMdObject(projectId, mdObject);
            createdMdObject = ReferenceReplaceUtils.replaceReferencesInMdObject((MdObjectDTO)createdMdObject, (ReferenceReplacer)new ProjectIdLinkReplacer(mdObject.getName()));
            String serverETagValue = this.headMdObjectETag(projectId, createdMdObject);
            createdMdObject.setVersion(new ETag(serverETagValue).getVersion());
            MdObjectDumpDTO objectDump = DumpUtils.wrapMdObject((String)projectId, (MdObjectDTO)createdMdObject);
            DumpUtils.saveObjectToJson((Object)objectDump, (String)file.getAbsolutePath());
        }
        catch (MdException ex) {
            if (!silent) {
                logger.error("Failed to add object " + file.getName());
            }
            throw ex;
        }
    }

    public void pushObject(String projectId, File file) throws IOException {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)file, (String)"File path of object to push is null.");
        MdObjectDumpDTO mdObjectDump = this.validateAndMapToMdObjectDump(file);
        MdObjectDTO mdObject = mdObjectDump.getContent();
        try {
            mdObject = ReferenceReplaceUtils.replaceReferencesInMdObject((MdObjectDTO)mdObject, (ReferenceReplacer)new ProjectIdPlaceholderLinkReplacer(projectId, mdObject.getName()));
            mdObject.setVersion(Long.valueOf(Long.parseLong(mdObjectDump.getVersion())));
            MdObjectDTO updatedMdObject = this.mdObjectClient.putMdObject(projectId, mdObject.getType().toStringPlural(), mdObject.getId(), mdObject);
            updatedMdObject = ReferenceReplaceUtils.replaceReferencesInMdObject((MdObjectDTO)updatedMdObject, (ReferenceReplacer)new ProjectIdLinkReplacer(mdObject.getName()));
            String serverETagValue = this.headMdObjectETag(projectId, updatedMdObject);
            updatedMdObject.setVersion(new ETag(serverETagValue).getVersion());
            MdObjectDumpDTO objectDump = DumpUtils.wrapMdObject((String)projectId, (MdObjectDTO)updatedMdObject);
            DumpUtils.saveObjectToJson((Object)objectDump, (String)file.getAbsolutePath());
        }
        catch (MdException ex) {
            logger.error("Failed to push object " + file.getName());
            throw ex;
        }
    }

    private MdObjectDumpDTO validateAndMapToMdObjectDump(File file) throws IOException {
        try {
            DumpUtils.validateMdObjectDump((File)file);
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            MdObjectDumpDTO mdObjectDump = (MdObjectDumpDTO)this.mapper.readValue(content, MdObjectDumpDTO.class);
            if (!mdObjectDump.getContent().getName().equals(FilenameUtils.removeExtension((String)file.getName()))) {
                throw new CleverMapsShellException("JSON object name=" + mdObjectDump.getContent().getName() + " and the filename=" + file.getName() + " do not match.");
            }
            return mdObjectDump;
        }
        catch (JsonProcessingException exception) {
            throw new JsonSyntaxException(file, (Object)"pushProject", exception);
        }
    }

    public void removeObjectByName(ShellContext context, String mdObjectType, String filename) {
        Assert.notNull((Object)context, (String)"Context cannot be null.");
        Assert.hasText((String)mdObjectType, (String)"Missing property type.");
        Assert.hasText((String)filename, (String)"Missing filename of object to delete.");
        String objectName = FilenameUtils.removeExtension((String)filename);
        MdObjectDTO mdObject = this.mdObjectClient.getMdObjectByName(context.getCurrentProject(), mdObjectType, objectName);
        this.mdObjectClient.deleteMdObjectById(context.getCurrentProject(), mdObjectType, mdObject.getId());
    }

    public void removeObjectById(String projectId, String mdObjectType, String id) {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.hasText((String)mdObjectType, (String)"Missing property type.");
        Assert.hasText((String)id, (String)"Missing id of object to delete.");
        this.mdObjectClient.deleteMdObjectById(projectId, mdObjectType, id);
    }

    public DatasetDTO generateDataset(String projectId, String name, String subtype, String primaryKey, String geometry, File csvFile, Character csvSeparator, Character csvQuote, Character csvEscape) throws IOException {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.hasText((String)name, (String)"Missing property name.");
        Assert.hasText((String)subtype, (String)"Missing property subtype.");
        Assert.notNull((Object)csvFile, (String)"Missing csv file.");
        String csvContent = DumpUtils.loadCsvLines((File)csvFile, (int)10);
        return this.mdObjectClient.generateDataset(projectId, name, subtype, Optional.ofNullable(primaryKey), csvContent, Optional.ofNullable(geometry), Optional.ofNullable(csvSeparator), Optional.ofNullable(csvQuote), Optional.ofNullable(csvEscape));
    }

    public DatasetDTO generateDataset(String projectId, GenerateDatasetRequestDTO generateRequest) {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)generateRequest, (String)"GenerateDatasetRequest must not be null.");
        return this.mdObjectClient.generateDataset(projectId, generateRequest);
    }

    public MdObjectDumpDTO renameObject(ShellContext context, File localFile, String oldName, String newName) throws IOException {
        Assert.notNull((Object)context, (String)"ShellContext is null.");
        Assert.notNull((Object)localFile, (String)"LocalFile is null.");
        Assert.hasText((String)oldName, (String)"Missing oldName of object to be renamed.");
        Assert.hasText((String)newName, (String)"Missing newName of object to be renamed.");
        File renamedLocalFile = DumpUtils.renameLocalObject((File)localFile, (String)newName);
        if (!renamedLocalFile.exists()) {
            throw new IOException("Failed to rename local object " + oldName);
        }
        logger.error("Object:");
        logger.error("\tLocal object {} successfully renamed to {}", (Object)oldName, (Object)newName);
        FileUtils.deleteQuietly((File)localFile);
        AbstractShellClient shellClient = context.getShellClient();
        String oldObjectName = FilenameUtils.removeExtension((String)oldName);
        String newObjectName = FilenameUtils.removeExtension((String)newName);
        shellClient.pushObject(context.getCurrentProject(), renamedLocalFile);
        logger.error("\tRemote object {} successfully renamed to {}\n", (Object)oldObjectName, (Object)newObjectName);
        shellClient.removeMetadataChecksumListElement(context, localFile);
        shellClient.putMetadataChecksumListElement(context, renamedLocalFile);
        return DumpUtils.loadFileAsMdObjectDump((File)renamedLocalFile);
    }

    public void renameObjectReferences(ShellContext context, MdObjectDumpDTO objectDumpToRename, List<MdObjectDumpDTO> renamedReferences) throws IOException {
        logger.error("Object references:");
        if (!renamedReferences.isEmpty()) {
            for (MdObjectDumpDTO renamedReference : renamedReferences) {
                String objectName = renamedReference.getContent().getName();
                String filename = DumpUtils.appendExtension((String)objectName, (String)".json");
                Path path = Paths.get(context.getMetadataDumpPath().toString(), renamedReference.getContent().getType().toStringPlural(), filename);
                DumpUtils.saveObjectToJson((Object)renamedReference, (String)path.toAbsolutePath().toString());
                String objectType = objectDumpToRename.getContent().getType().toString();
                logger.error("\tRenamed {} reference(s) key in local file {} and uploaded it", (Object)objectType, (Object)filename);
                AbstractShellClient shellClient = context.getShellClient();
                shellClient.pushObject(context.getCurrentProject(), path.toFile());
                shellClient.putMetadataChecksumListElement(context, path.toFile());
            }
            logger.error("");
        } else {
            logger.error("\tThis object is not referenced in any other object(s).\n");
        }
    }

    public List<DatasetDTO> loadDatasetsFromPath(File path, List<String> namesToLoad) throws IOException {
        ArrayList<DatasetDTO> datasets = new ArrayList<DatasetDTO>();
        File[] files = path.listFiles();
        if (files != null) {
            for (File datasetFile : files) {
                DatasetDTO dataset;
                if (DumpUtils.isValidMdObjectDump((File)datasetFile)) {
                    MdObjectDumpDTO mdObjectDump = DumpUtils.loadFileAsMdObjectDump((File)datasetFile);
                    dataset = (DatasetDTO)DumpUtils.unwrapMdObject((MdObjectDumpDTO)mdObjectDump);
                } else {
                    dataset = (DatasetDTO)DumpUtils.loadFileAsClass((File)datasetFile, DatasetDTO.class);
                }
                if (!namesToLoad.isEmpty() && !namesToLoad.contains(dataset.getName())) continue;
                datasets.add(dataset);
            }
        }
        return datasets;
    }

    public void saveDatasetsToPath(List<DatasetDTO> datasets, File path) throws IOException {
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Failed to create directory=" + String.valueOf(path));
        }
        for (DatasetDTO dataset : datasets) {
            String datasetName = DumpUtils.appendExtension((String)dataset.getName(), (String)".json");
            Path finalPath = Paths.get(path.toString(), datasetName);
            DumpUtils.saveObjectToJson((Object)dataset, (String)finalPath.toString());
        }
    }

    public void saveMdObjectsToPath(List<MdObjectDTO> mdObjects, File path) throws IOException {
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Failed to create directory=" + String.valueOf(path));
        }
        for (MdObjectDTO mdObject : mdObjects) {
            String mdObjectName = DumpUtils.appendExtension((String)mdObject.getName(), (String)".json");
            String type = mdObject.getType().toStringPlural();
            Path finalPath = Paths.get(path.toString(), type, mdObjectName);
            DumpUtils.saveObjectToJson((Object)mdObject, (String)finalPath.toString());
        }
    }

    public File getCurrentDatasetsPath(ShellContext context) {
        return Paths.get(context.getMetadataDumpPath().toString(), "datasets").toFile();
    }

    public void fetchSingleObject(ShellContext context, String objectName, boolean force) throws IOException {
        logger.error("Fetching object {}..." + OsUtils.LINE_SEPARATOR, (Object)objectName);
        String nameWithoutExtension = DumpUtils.removeExtension((String)objectName, (String)".json");
        MdObjectDTO serverMdObjectDTO = this.getMdObjectByName(context, nameWithoutExtension);
        if (force) {
            if (serverMdObjectDTO == null) {
                logger.error("Object {} does not exist.", (Object)objectName);
            } else {
                this.wrapAndSaveMdObject(context, serverMdObjectDTO);
                logger.error("Dumping object {} with force enabled", (Object)serverMdObjectDTO.getName());
                logger.error("Fetching completed.");
            }
            return;
        }
        File localMdFile = DumpUtils.findMetadataInDump((ShellContext)context, (String)objectName);
        if (serverMdObjectDTO == null && localMdFile == null) {
            logger.error("Object {} does not exist.", (Object)objectName);
            return;
        }
        if (localMdFile == null) {
            this.dumpMissingFiles(context, Collections.singletonList(serverMdObjectDTO));
            return;
        }
        boolean isModifiedLocally = DumpUtils.modifiedSinceDumpMd5((File)localMdFile, (File)context.getDumpMetadataFile());
        boolean isValidMdDumpObject = DumpUtils.isValidMdObjectDump((File)localMdFile);
        if (serverMdObjectDTO == null) {
            if (isModifiedLocally && isValidMdDumpObject) {
                this.unwrapDeletedFilesOnServerAndLocallyModified(Collections.singletonList(localMdFile));
            } else {
                this.deleteUnmodifiedLocalFiles(Collections.singletonList(localMdFile));
            }
            logger.error("Fetching completed.");
            return;
        }
        if (!isValidMdDumpObject) {
            logger.error("Object {} is not valid metadata object." + OsUtils.LINE_SEPARATOR, (Object)objectName);
            logger.error("Fix the metadata object or use --force to fetch and overwrite local object." + OsUtils.LINE_SEPARATOR);
            return;
        }
        MdObjectDTO localMdObjectDTO = DumpUtils.unwrapMdObject((MdObjectDumpDTO)DumpUtils.loadFileAsMdObjectDump((File)localMdFile));
        if (serverMdObjectDTO.getVersion() > localMdObjectDTO.getVersion()) {
            if (isModifiedLocally) {
                this.dumpConflictingFiles(context, Collections.singletonList(localMdFile));
                logger.error("Fetching completed.");
            } else {
                this.wrapAndSaveMdObject(context, serverMdObjectDTO);
                logger.error("Dumping object {}" + OsUtils.LINE_SEPARATOR, (Object)serverMdObjectDTO.getName());
                logger.error("Fetching completed.");
            }
        } else {
            logger.error("Object {} is up-to-date.", (Object)objectName);
        }
    }

    private MdObjectDTO getMdObjectByName(ShellContext context, String objectName) {
        MdObjectDTO mdObjectDTO = this.mdObjectClient.getMdObjectByName(context.getCurrentProject(), objectName);
        if (this.canUserGetDataPermissionsMdObject(context, mdObjectDTO)) {
            return null;
        }
        return mdObjectDTO;
    }

    private boolean canUserGetDataPermissionsMdObject(ShellContext context, MdObjectDTO mdObjectDTO) {
        if (mdObjectDTO == null) {
            return false;
        }
        ProjectClient projectClient = new ProjectClient(context.getCanRestClient());
        Role projectRole = projectClient.getMembershipInProject(context.getCurrentProject()).getRole();
        return mdObjectDTO.getType().equals((Object)MdObjectTypeEnum.DATA_PERMISSION) && !projectRole.equals((Object)Role.ADMIN);
    }

    public void fetchAllObjects(ShellContext context, boolean force) throws IOException {
        logger.error("Fetching metadata objects from server..." + OsUtils.LINE_SEPARATOR);
        File metadataDump = context.getMetadataDumpPath().toFile();
        List allMetadataInDump = DumpUtils.findAllMetadataInDump((File)metadataDump);
        List unmappableFiles = DumpUtils.filterMappableMetadataFiles((List)allMetadataInDump);
        if (!unmappableFiles.isEmpty()) {
            this.printUnmappableFiles(unmappableFiles);
            logger.error("Fix these metadata objects before fetching changes or use fetch --objectName <filename> --force to overwrite local object.");
            return;
        }
        List modifiedLocally = DumpUtils.findModifiedMetadataInDump((ShellContext)context, (File)metadataDump);
        List missingMdObjectsFromDump = DumpUtils.findAllMissingFilesInDump((ShellContext)context, (List)allMetadataInDump);
        Map modifiedOnServer = DumpUtils.findModifiedMetadataOnServer((ShellContext)context, (File)metadataDump);
        ArrayList<File> conflictingFiles = new ArrayList<File>();
        ArrayList<File> filesForDelete = new ArrayList<File>();
        ArrayList<File> filesDeletedOnServerAndLocallyModified = new ArrayList<File>();
        ArrayList<File> filesModifiedOnlyOnServer = new ArrayList<File>();
        for (Map.Entry fileEntry : modifiedOnServer.entrySet()) {
            File file = (File)fileEntry.getKey();
            Long fileVersion = (Long)fileEntry.getValue();
            if (modifiedLocally.contains(file)) {
                if (fileVersion == 0L || fileVersion == -1L) {
                    filesDeletedOnServerAndLocallyModified.add(file);
                    continue;
                }
                if (force) {
                    filesModifiedOnlyOnServer.add(file);
                    continue;
                }
                conflictingFiles.add(file);
                continue;
            }
            if (fileVersion == 0L || fileVersion == -1L) {
                filesForDelete.add(file);
                continue;
            }
            filesModifiedOnlyOnServer.add(file);
        }
        int changedFiles = missingMdObjectsFromDump.size() + conflictingFiles.size() + filesForDelete.size() + filesDeletedOnServerAndLocallyModified.size() + filesModifiedOnlyOnServer.size();
        if (changedFiles == 0) {
            logger.error("All objects are up-to-date, no changes made.");
            return;
        }
        this.dumpMissingFiles(context, missingMdObjectsFromDump);
        this.dumpChangesFromServer(context, filesModifiedOnlyOnServer);
        this.deleteUnmodifiedLocalFiles(filesForDelete);
        this.unwrapDeletedFilesOnServerAndLocallyModified(filesDeletedOnServerAndLocallyModified);
        this.dumpConflictingFiles(context, conflictingFiles);
        logger.error("Fetching completed. {} objects impacted.", (Object)changedFiles);
    }

    public MdRestoreCollection restoreSingleObject(ShellContext context, String objectName) throws IOException {
        logger.error("Restoring object {}..." + OsUtils.LINE_SEPARATOR, (Object)objectName);
        MdRestoreCollection restoreCollection = new MdRestoreCollection();
        String nameWithoutExtension = DumpUtils.removeExtension((String)objectName, (String)".json");
        File localMdFile = DumpUtils.findMetadataInDump((ShellContext)context, (String)objectName);
        MdObjectDTO serverMdObject = this.getMdObjectByName(context, nameWithoutExtension);
        if (localMdFile == null && serverMdObject == null) {
            logger.error("Object {} is not present in dump or on the server.", (Object)objectName);
            return restoreCollection;
        }
        if (localMdFile == null) {
            restoreCollection.addMdObjectToDelete(serverMdObject.getName());
            return restoreCollection;
        }
        if (!DumpUtils.isValidMdObjectDump((File)localMdFile)) {
            logger.error("Object {} is not valid metadata object." + OsUtils.LINE_SEPARATOR, (Object)objectName);
            return restoreCollection;
        }
        MdObjectDumpDTO localMdObjectDump = DumpUtils.loadFileAsMdObjectDump((File)localMdFile);
        if (serverMdObject == null) {
            MdObjectDTO localMdObject = DumpUtils.unwrapMdObject((MdObjectDumpDTO)localMdObjectDump);
            DumpUtils.saveObjectToJson((Object)localMdObject, (String)localMdFile.getAbsolutePath());
            this.removeMetadataChecksumListElement(context, localMdFile);
            restoreCollection.addMdObjectToAdd(localMdFile);
            return restoreCollection;
        }
        if (localMdObjectDump.getVersion().equals(serverMdObject.getVersion().toString())) {
            logger.error("Local and server object are same.");
        } else {
            localMdObjectDump.setVersion(serverMdObject.getVersion().toString());
            DumpUtils.saveObjectToJson((Object)localMdObjectDump, (String)localMdFile.getAbsolutePath());
            restoreCollection.addMdObjectToRestore(localMdFile);
        }
        return restoreCollection;
    }

    public MdRestoreCollection restoreAllObjects(ShellContext context) throws IOException {
        logger.error("Restoring objects..." + OsUtils.LINE_SEPARATOR);
        MdRestoreCollection restoreCollection = new MdRestoreCollection();
        File metadataDump = context.getMetadataDumpPath().toFile();
        List allMetadataInDump = DumpUtils.findAllMetadataInDump((File)metadataDump);
        List unmappableFiles = DumpUtils.filterMappableMetadataFiles((List)allMetadataInDump);
        if (!unmappableFiles.isEmpty()) {
            this.printUnmappableFiles(unmappableFiles);
            logger.error("Fix these metadata objects before restoring or use fetch --objectName <filename> --force to overwrite local object.");
            return restoreCollection;
        }
        List mdObjectsForDelete = DumpUtils.findAllMissingFilesInDump((ShellContext)context, (List)allMetadataInDump);
        mdObjectsForDelete.forEach(mdObject -> restoreCollection.addMdObjectToDelete(mdObject.getName()));
        Map modifiedOnServer = DumpUtils.findModifiedMetadataOnServer((ShellContext)context, (File)metadataDump);
        for (Map.Entry fileEntry : modifiedOnServer.entrySet()) {
            Long serverMdVersion = (Long)fileEntry.getValue();
            File localMdFile = (File)fileEntry.getKey();
            MdObjectDumpDTO mdObjectDump = DumpUtils.loadFileAsMdObjectDump((File)localMdFile);
            if (serverMdVersion == 0L || serverMdVersion == -1L) {
                MdObjectDTO localMdObject = DumpUtils.unwrapMdObject((MdObjectDumpDTO)mdObjectDump);
                DumpUtils.saveObjectToJson((Object)localMdObject, (String)localMdFile.getAbsolutePath());
                this.removeMetadataChecksumListElement(context, localMdFile);
                restoreCollection.addMdObjectToAdd(localMdFile);
                continue;
            }
            mdObjectDump.setVersion(serverMdVersion.toString());
            DumpUtils.saveObjectToJson((Object)mdObjectDump, (String)localMdFile.getAbsolutePath());
            restoreCollection.addMdObjectToRestore(localMdFile);
        }
        return restoreCollection;
    }

    private void unwrapDeletedFilesOnServerAndLocallyModified(List<File> files) throws IOException {
        if (files.isEmpty()) {
            return;
        }
        logger.error("Following objects were deleted on server and locally modified. They are unwrapped and can be added by addMetadata:");
        for (File file : files) {
            MdObjectDTO mdObjectDTO = DumpUtils.unwrapMdObject((MdObjectDumpDTO)DumpUtils.loadFileAsMdObjectDump((File)file));
            DumpUtils.saveObjectToJson((Object)mdObjectDTO, (String)file.getAbsolutePath());
            logger.error("\t {}", (Object)file.getName());
        }
    }

    private void dumpConflictingFiles(ShellContext context, List<File> conflictingFiles) throws IOException {
        if (conflictingFiles.isEmpty()) {
            return;
        }
        ArrayList<MdObjectDTO> localMdObjects = new ArrayList<MdObjectDTO>();
        ArrayList<MdObjectDTO> serverMdObjects = new ArrayList<MdObjectDTO>();
        for (File conflictingFile : conflictingFiles) {
            localMdObjects.add(DumpUtils.unwrapMdObject((MdObjectDumpDTO)DumpUtils.loadFileAsMdObjectDump((File)conflictingFile)));
            MdObjectDTO serverMdObject = this.getMdObjectByName(context, DumpUtils.removeExtension((String)conflictingFile.getName(), (String)".json"));
            Assert.notNull((Object)serverMdObject, (String)"MdObject is null.");
            serverMdObjects.add(serverMdObject);
        }
        Map mergedMdObjects = this.mergeMdObjects(context, localMdObjects, serverMdObjects, conflictingFiles);
        logger.error("Dumping conflicting objects...");
        AbstractShellClient shellClient = context.getShellClient();
        for (Map.Entry mergedObject : mergedMdObjects.entrySet()) {
            File file = (File)mergedObject.getKey();
            StringBuilder builder = (StringBuilder)mergedObject.getValue();
            DumpUtils.saveStringToJsonUnchecked((String)builder.toString(), (String)file.getAbsolutePath());
            shellClient.putMetadataChecksumListElement(context, file);
            logger.error("\t {}", (Object)file.getName());
        }
    }

    private Map<File, StringBuilder> mergeMdObjects(ShellContext context, List<MdObjectDTO> localMdObjects, List<MdObjectDTO> serverMdObjects, List<File> conflictingFiles) throws JsonProcessingException {
        HashMap<File, StringBuilder> mergedMdObjects = new HashMap<File, StringBuilder>(conflictingFiles.size());
        DiffClient diffClient = new DiffClient(context);
        CanPrettyPrinter canPrettyPrinter = new CanPrettyPrinter();
        ObjectWriter objectWriter = this.mapper.writer().with((PrettyPrinter)canPrettyPrinter);
        for (int i = 0; i < localMdObjects.size(); ++i) {
            MdObjectDTO localMdObject = localMdObjects.get(i);
            if (localMdObject.getType().equals((Object)MdObjectTypeEnum.DATA_PERMISSION) && !this.canUserGetDataPermissionsMdObject(context, localMdObject)) continue;
            MdObjectDTO serverMdObject = serverMdObjects.get(i);
            Long version = serverMdObject.getVersion();
            this.unifyPropertiesForDiff(localMdObject, serverMdObject);
            ArrayList localObjectLines = diffClient.processStringInput(objectWriter.writeValueAsString((Object)localMdObject));
            ArrayList serverObjectLines = diffClient.processStringInput(objectWriter.writeValueAsString((Object)serverMdObject));
            StringBuilder objectDiff = new StringBuilder();
            this.printWrapperHead(context, objectDiff, serverMdObject, version);
            this.performDiff(objectDiff, localObjectLines, serverObjectLines);
            this.printWrapperTail(objectDiff);
            mergedMdObjects.put(conflictingFiles.get(i), objectDiff);
        }
        return mergedMdObjects;
    }

    private void unifyPropertiesForDiff(MdObjectDTO localMdObject, MdObjectDTO serverMdObject) {
        localMdObject.setId(serverMdObject.getId());
        localMdObject.setAccessInfo(serverMdObject.getAccessInfo());
        localMdObject.setAdditionalProperty("links", serverMdObject.getAdditionalProperties().get("links"));
        serverMdObject.setVersion(null);
        localMdObject.setVersion(null);
    }

    private void printWrapperHead(ShellContext context, StringBuilder objectDiff, MdObjectDTO serverMdObject, Long version) {
        URI uri = UriUtils.objectIdToURI((String)context.getCurrentProject(), (String)serverMdObject.getType().toStringPlural(), (String)serverMdObject.getId());
        objectDiff.append("{").append(OsUtils.LINE_SEPARATOR);
        objectDiff.append("    \"url\": \"").append(uri).append("\",").append(OsUtils.LINE_SEPARATOR);
        objectDiff.append("    \"dumpTime\": \"").append(DumpUtils.formatTimeToIso8601((Date)new Date())).append("\",").append(OsUtils.LINE_SEPARATOR);
        objectDiff.append("    \"version\": \"").append(version).append("\",").append(OsUtils.LINE_SEPARATOR);
        objectDiff.append("    \"content\": {").append(OsUtils.LINE_SEPARATOR);
    }

    private void printWrapperTail(StringBuilder objectDiff) {
        objectDiff.append("}");
    }

    private void performDiff(StringBuilder builder, ArrayList<String> localObjectLines, ArrayList<String> serverObjectLines) {
        Patch patch = DiffUtils.diff(localObjectLines, serverObjectLines);
        List deltas = patch.getDeltas();
        if (deltas.isEmpty()) {
            for (int i = 1; i < localObjectLines.size(); ++i) {
                String line = localObjectLines.get(i);
                builder.append("    ").append(line).append(OsUtils.LINE_SEPARATOR);
            }
            return;
        }
        int currentLine = 1;
        Delta topDelta = (Delta)deltas.get(0);
        deltas.remove(0);
        while (currentLine < localObjectLines.size()) {
            String line = localObjectLines.get(currentLine);
            if (topDelta.getOriginal().getPosition() == currentLine + 1) {
                builder.append("    ").append(line).append(OsUtils.LINE_SEPARATOR);
                ++currentLine;
                switch (1.$SwitchMap$difflib$Delta$TYPE[topDelta.getType().ordinal()]) {
                    case 1: 
                    case 2: {
                        currentLine += this.printChangeInFile(builder, topDelta);
                        break;
                    }
                    case 3: {
                        this.printChangeInFile(builder, topDelta);
                        ++currentLine;
                        break;
                    }
                    default: {
                        throw new CleverMapsShellException("Unknown type of delta diff - " + String.valueOf(topDelta.getType()));
                    }
                }
                if (deltas.isEmpty()) continue;
                topDelta = (Delta)deltas.get(0);
                deltas.remove(0);
                continue;
            }
            builder.append("    ").append(line).append(OsUtils.LINE_SEPARATOR);
            ++currentLine;
        }
    }

    private int printChangeInFile(StringBuilder builder, Delta<String> delta) {
        Chunk local = delta.getOriginal();
        Chunk server = delta.getRevised();
        builder.append("<<<<<<< local").append(OsUtils.LINE_SEPARATOR);
        this.printChunk(builder, local);
        builder.append("=============").append(OsUtils.LINE_SEPARATOR);
        this.printChunk(builder, server);
        builder.append(">>>>>>> server").append(OsUtils.LINE_SEPARATOR);
        return local.size();
    }

    private void printChunk(StringBuilder builder, Chunk<String> chunk) {
        for (String line : chunk.getLines()) {
            builder.append("    ").append(line).append(OsUtils.LINE_SEPARATOR);
        }
    }

    private void deleteUnmodifiedLocalFiles(List<File> filesForDelete) {
        if (filesForDelete.isEmpty()) {
            return;
        }
        logger.error("Deleting local objects...");
        for (File file : filesForDelete) {
            String fileName = file.getName();
            if (!FileUtils.deleteQuietly((File)file)) {
                logger.error("Cannot delete object {}, skipping.", (Object)fileName);
                continue;
            }
            logger.error("\t {}", (Object)fileName);
        }
    }

    private void printUnmappableFiles(List<File> unmappableFiles) {
        if (unmappableFiles.isEmpty()) {
            return;
        }
        logger.error("Following objects are not valid metadata files:");
        for (File file : unmappableFiles) {
            logger.error("\t {}", (Object)file.getName());
        }
    }

    private void dumpChangesFromServer(ShellContext context, List<File> modifiedOnServer) throws IOException {
        if (modifiedOnServer.isEmpty()) {
            return;
        }
        logger.error("Dumping objects changed on server...");
        for (File modifiedFile : modifiedOnServer) {
            String nameWithoutExtension = DumpUtils.removeExtension((String)modifiedFile.getName(), (String)".json");
            MdObjectDTO mdObjectDTO = this.getMdObjectByName(context, nameWithoutExtension);
            if (mdObjectDTO == null) {
                logger.error("\t {}", (Object)("Could not dump object=" + nameWithoutExtension + ". Skipping."));
                continue;
            }
            this.wrapAndSaveMdObject(context, mdObjectDTO);
            logger.error("\t {}", (Object)mdObjectDTO.getName());
        }
    }

    private void dumpMissingFiles(ShellContext context, List<MdObjectDTO> missingMdObjectsFromDump) throws IOException {
        if (missingMdObjectsFromDump.isEmpty()) {
            return;
        }
        logger.error("Dumping objects missing in dump...");
        for (MdObjectDTO mdObjectDTO : missingMdObjectsFromDump) {
            logger.error("\t {}", (Object)mdObjectDTO.getName());
            this.wrapAndSaveMdObject(context, mdObjectDTO);
        }
    }

    public String headMdObjectETag(String projectId, MdObjectDTO mdObject) {
        return this.mdObjectClient.headETagValue(projectId, mdObject.getType().toStringPlural(), mdObject.getId());
    }
}

