/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.shell.MdRestoreCollection;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.commands.dump.AddMetadataCommand;
import com.cleveranalytics.shell.commands.dump.PushProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.stereotype.Component;

@Component
public class RestoreMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(RestoreMetadataCommand.class);
    private final ShellContext context;

    @Autowired
    public RestoreMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"restoreMetadata"})
    public boolean isCommandAvailable() {
        return this.context.isOpenDump();
    }

    @CliCommand(value={"restoreMetadata"}, help="Restore a metadata object from a local dump onto server. If the --objectName parameter is not specified, restoreMetadata will restore, add and push all changed objects in the dump. For objects present on server and not in local dump, restoreMetadata prints list of removeMetadata commands to delete server objects.")
    public void restoreMetadataCmd(@CliOption(key={"objectName"}, mandatory=false, help="Name of the object to restore (with or without .json extension)") String objectName) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            AbstractShellClient shellClient = this.context.getShellClient();
            MdRestoreCollection restoreCollection = objectName != null ? shellClient.restoreSingleObject(this.context, objectName) : shellClient.restoreAllObjects(this.context);
            if (restoreCollection.hasMdObjectsToAdd()) {
                new AddMetadataCommand(this.context).addMetadataCmd(objectName);
            }
            if (restoreCollection.hasMdObjectsToRestore()) {
                new PushProjectCommand(this.context).pushMetadata(restoreCollection.getMdObjectsToRestore(), Collections.emptyList());
            }
            if (restoreCollection.hasMdObjectsToDelete()) {
                String output = this.printRemoveCommands(restoreCollection.getMdObjectsToDelete());
                logger.error(output);
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected String printRemoveCommands(List<String> mdObjectNamesToDelete) {
        StringBuilder output = new StringBuilder();
        output.append("Following metadata objects are present on the server and not in the dump:");
        output.append(OsUtils.LINE_SEPARATOR);
        for (String mdObjectName : mdObjectNamesToDelete) {
            output.append("\t");
            output.append(mdObjectName);
            output.append(OsUtils.LINE_SEPARATOR);
        }
        output.append("You can delete them with following commands:");
        output.append(OsUtils.LINE_SEPARATOR);
        for (String mdObjectName : mdObjectNamesToDelete) {
            output.append("\t removeMetadata --objectName ");
            output.append(mdObjectName);
            output.append(OsUtils.LINE_SEPARATOR);
        }
        return output.toString();
    }
}

